/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import java.util.AbstractList;
import org.bouncycastle.util.encoders.Hex;
import org.ethereum.datasource.ObjectDataSource;
import org.ethereum.util.ByteUtil;

public class DataSourceArray<V>
extends AbstractList<V> {
    private ObjectDataSource<V> src;
    private static final byte[] SIZE_KEY = Hex.decode((String)"FFFFFFFFFFFFFFFF");
    private int size = -1;

    public DataSourceArray(ObjectDataSource<V> src) {
        this.src = src;
    }

    public synchronized boolean flush() {
        return this.src.flush();
    }

    @Override
    public synchronized V set(int idx, V value) {
        if (idx >= this.size()) {
            this.setSize(idx + 1);
        }
        this.src.put(ByteUtil.intToBytes(idx), value);
        return value;
    }

    @Override
    public synchronized void add(int index, V element) {
        this.set(index, element);
    }

    @Override
    public synchronized V remove(int index) {
        throw new RuntimeException("Not supported yet.");
    }

    @Override
    public synchronized V get(int idx) {
        if (idx < 0 || idx >= this.size()) {
            throw new IndexOutOfBoundsException(idx + " > " + this.size);
        }
        return (V)this.src.get(ByteUtil.intToBytes(idx));
    }

    @Override
    public synchronized int size() {
        if (this.size < 0) {
            byte[] sizeBB = (byte[])this.src.getSource().get(SIZE_KEY);
            this.size = sizeBB == null ? 0 : ByteUtil.byteArrayToInt(sizeBB);
        }
        return this.size;
    }

    private synchronized void setSize(int newSize) {
        this.size = newSize;
        this.src.getSource().put(SIZE_KEY, ByteUtil.intToBytes(newSize));
    }
}

