/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import org.ethereum.datasource.AbstractCachedSource;
import org.ethereum.datasource.CachedSource;
import org.ethereum.datasource.ReadWriteCache;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.WriteCache;

public abstract class MultiCache<V extends CachedSource>
extends ReadWriteCache.BytesKey<V> {
    public MultiCache(Source<byte[], V> src) {
        super(src, WriteCache.CacheType.SIMPLE);
    }

    @Override
    public synchronized V get(byte[] key) {
        CachedSource ownCache;
        AbstractCachedSource.Entry ownCacheEntry = this.getCached(key);
        CachedSource cachedSource = ownCache = ownCacheEntry == null ? null : (CachedSource)ownCacheEntry.value();
        if (ownCache == null) {
            CachedSource v = this.getSource() != null ? (CachedSource)super.get(key) : null;
            ownCache = this.create(key, v);
            this.put(key, ownCache);
        }
        return (V)ownCache;
    }

    @Override
    public synchronized boolean flushImpl() {
        boolean ret = false;
        for (byte[] key : this.writeCache.getModified()) {
            CachedSource value = (CachedSource)super.get(key);
            if (value == null) {
                ret |= this.flushChild(key, value);
                if (this.getSource() == null) continue;
                this.getSource().delete(key);
                continue;
            }
            if (value.getSource() != null) {
                ret |= this.flushChild(key, value);
                continue;
            }
            this.getSource().put(key, value);
            ret = true;
        }
        return ret;
    }

    protected boolean flushChild(byte[] key, V childCache) {
        return childCache != null ? childCache.flush() : true;
    }

    protected abstract V create(byte[] var1, V var2);
}

