/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import org.ethereum.crypto.HashUtil;
import org.ethereum.datasource.Serializer;

public class NodeKeyCompositor
implements Serializer<byte[], byte[]> {
    public static final int HASH_LEN = 32;
    public static final int PREFIX_BYTES = 16;
    private byte[] addrHash;

    public NodeKeyCompositor(byte[] addrOrHash) {
        this.addrHash = NodeKeyCompositor.addrHash(addrOrHash);
    }

    @Override
    public byte[] serialize(byte[] key) {
        return NodeKeyCompositor.composeInner(key, this.addrHash);
    }

    @Override
    public byte[] deserialize(byte[] stream) {
        return stream;
    }

    public static byte[] compose(byte[] key, byte[] addrOrHash) {
        return NodeKeyCompositor.composeInner(key, NodeKeyCompositor.addrHash(addrOrHash));
    }

    private static byte[] composeInner(byte[] key, byte[] addrHash) {
        NodeKeyCompositor.validateKey(key);
        byte[] derivative = new byte[key.length];
        System.arraycopy(key, 0, derivative, 0, 16);
        System.arraycopy(addrHash, 0, derivative, 16, 16);
        return derivative;
    }

    private static void validateKey(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException("Key is not a hash code");
        }
    }

    private static byte[] addrHash(byte[] addrOrHash) {
        return addrOrHash.length == 32 ? addrOrHash : HashUtil.sha3(addrOrHash);
    }
}

