/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import org.ethereum.datasource.ReadCache;
import org.ethereum.datasource.Serializer;
import org.ethereum.datasource.Serializers;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.SourceChainBox;
import org.ethereum.datasource.SourceCodec;

public class ObjectDataSource<V>
extends SourceChainBox<byte[], V, byte[], byte[]> {
    ReadCache<byte[], V> cache;
    SourceCodec<byte[], V, byte[], byte[]> codec;
    Source<byte[], byte[]> byteSource;

    public ObjectDataSource(Source<byte[], byte[]> byteSource, Serializer<V, byte[]> serializer, int readCacheEntries) {
        super(byteSource);
        this.byteSource = byteSource;
        this.codec = new SourceCodec(byteSource, new Serializers.Identity(), serializer);
        this.add(this.codec);
        if (readCacheEntries > 0) {
            this.cache = new ReadCache.BytesKey(this.codec).withMaxCapacity(readCacheEntries);
            this.add(this.cache);
        }
    }
}

