/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import org.ethereum.core.AccountState;
import org.ethereum.core.BlockHeader;
import org.ethereum.datasource.Serializer;
import org.ethereum.util.RLP;
import org.ethereum.util.RLPElement;
import org.ethereum.util.Value;
import org.ethereum.vm.DataWord;

public class Serializers {
    public static final Serializer<AccountState, byte[]> AccountStateSerializer = new Serializer<AccountState, byte[]>(){

        @Override
        public byte[] serialize(AccountState object) {
            return object.getEncoded();
        }

        @Override
        public AccountState deserialize(byte[] stream) {
            return stream == null || stream.length == 0 ? null : new AccountState(stream);
        }
    };
    public static final Serializer<DataWord, byte[]> StorageKeySerializer = new Serializer<DataWord, byte[]>(){

        @Override
        public byte[] serialize(DataWord object) {
            return object.getData();
        }

        @Override
        public DataWord deserialize(byte[] stream) {
            return DataWord.of(stream);
        }
    };
    public static final Serializer<DataWord, byte[]> StorageValueSerializer = new Serializer<DataWord, byte[]>(){

        @Override
        public byte[] serialize(DataWord object) {
            return RLP.encodeElement(object.getNoLeadZeroesData());
        }

        @Override
        public DataWord deserialize(byte[] stream) {
            if (stream == null || stream.length == 0) {
                return null;
            }
            byte[] dataDecoded = ((RLPElement)RLP.decode2(stream).get(0)).getRLPData();
            return DataWord.of(dataDecoded);
        }
    };
    public static final Serializer<Value, byte[]> TrieNodeSerializer = new Serializer<Value, byte[]>(){

        @Override
        public byte[] serialize(Value object) {
            return object.asBytes();
        }

        @Override
        public Value deserialize(byte[] stream) {
            return new Value(stream);
        }
    };
    public static final Serializer<BlockHeader, byte[]> BlockHeaderSerializer = new Serializer<BlockHeader, byte[]>(){

        @Override
        public byte[] serialize(BlockHeader object) {
            return object == null ? null : object.getEncoded();
        }

        @Override
        public BlockHeader deserialize(byte[] stream) {
            return stream == null ? null : new BlockHeader(stream);
        }
    };
    public static final Serializer<byte[], byte[]> AsIsSerializer = new Serializer<byte[], byte[]>(){

        @Override
        public byte[] serialize(byte[] object) {
            return object;
        }

        @Override
        public byte[] deserialize(byte[] stream) {
            return stream;
        }
    };

    public static class Identity<T>
    implements Serializer<T, T> {
        @Override
        public T serialize(T object) {
            return object;
        }

        @Override
        public T deserialize(T stream) {
            return stream;
        }
    }
}

