/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import org.ethereum.datasource.AbstractChainedSource;
import org.ethereum.datasource.Source;
import org.ethereum.util.ByteUtil;

public class XorDataSource<V>
extends AbstractChainedSource<byte[], V, byte[], V> {
    private byte[] subKey;

    public XorDataSource(Source<byte[], V> source, byte[] subKey) {
        super(source);
        this.subKey = subKey;
    }

    private byte[] convertKey(byte[] key) {
        return ByteUtil.xorAlignRight(key, this.subKey);
    }

    @Override
    public V get(byte[] key) {
        return (V)this.getSource().get(this.convertKey(key));
    }

    @Override
    public void put(byte[] key, V value) {
        this.getSource().put(this.convertKey(key), value);
    }

    @Override
    public void delete(byte[] key) {
        this.getSource().delete(this.convertKey(key));
    }

    @Override
    protected boolean flushImpl() {
        return false;
    }
}

