/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db;

import org.ethereum.core.AccountState;
import org.ethereum.core.Repository;
import org.ethereum.datasource.CachedSource;
import org.ethereum.datasource.MultiCache;
import org.ethereum.datasource.NodeKeyCompositor;
import org.ethereum.datasource.ReadWriteCache;
import org.ethereum.datasource.Serializers;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.SourceCodec;
import org.ethereum.datasource.WriteCache;
import org.ethereum.db.RepositoryImpl;
import org.ethereum.trie.SecureTrie;
import org.ethereum.trie.Trie;
import org.ethereum.trie.TrieImpl;
import org.ethereum.vm.DataWord;

public class RepositoryRoot
extends RepositoryImpl {
    private Source<byte[], byte[]> stateDS;
    private CachedSource.BytesKey<byte[]> trieCache;
    private Trie<byte[]> stateTrie;

    public RepositoryRoot(Source<byte[], byte[]> stateDS) {
        this(stateDS, null);
    }

    public RepositoryRoot(Source<byte[], byte[]> stateDS, byte[] root) {
        this.stateDS = stateDS;
        this.trieCache = new WriteCache.BytesKey<byte[]>(stateDS, WriteCache.CacheType.COUNTING);
        this.stateTrie = new SecureTrie(this.trieCache, root);
        SourceCodec.BytesKey<AccountState, byte[]> accountStateCodec = new SourceCodec.BytesKey<AccountState, byte[]>((Source<byte[], byte[]>)this.stateTrie, Serializers.AccountStateSerializer);
        ReadWriteCache.BytesKey<byte[]> accountStateCache = new ReadWriteCache.BytesKey<byte[]>((Source<byte[], byte[]>)accountStateCodec, WriteCache.CacheType.SIMPLE);
        MultiStorageCache storageCache = new MultiStorageCache();
        WriteCache.BytesKey<byte[]> codeCache = new WriteCache.BytesKey<byte[]>(stateDS, WriteCache.CacheType.COUNTING);
        this.init(accountStateCache, codeCache, storageCache);
    }

    @Override
    public synchronized void commit() {
        super.commit();
        this.stateTrie.flush();
        this.trieCache.flush();
    }

    @Override
    public synchronized byte[] getRoot() {
        this.storageCache.flush();
        this.accountStateCache.flush();
        return this.stateTrie.getRootHash();
    }

    @Override
    public synchronized void flush() {
        this.commit();
    }

    @Override
    public Repository getSnapshotTo(byte[] root) {
        return new RepositoryRoot(this.stateDS, root);
    }

    @Override
    public Repository clone() {
        return this.getSnapshotTo(this.getRoot());
    }

    @Override
    public synchronized String dumpStateTrie() {
        return ((TrieImpl)this.stateTrie).dumpTrie();
    }

    @Override
    public synchronized void syncToRoot(byte[] root) {
        this.stateTrie.setRoot(root);
    }

    protected TrieImpl createTrie(Source<byte[], byte[]> trieCache, byte[] root) {
        return new SecureTrie(trieCache, root);
    }

    private class MultiStorageCache
    extends MultiCache<StorageCache> {
        public MultiStorageCache() {
            super(null);
        }

        @Override
        protected synchronized StorageCache create(byte[] key, StorageCache srcCache) {
            AccountState accountState = (AccountState)RepositoryRoot.this.accountStateCache.get(key);
            NodeKeyCompositor keyCompositor = new NodeKeyCompositor(key);
            SourceCodec.KeyOnly composingSrc = new SourceCodec.KeyOnly(RepositoryRoot.this.trieCache, keyCompositor);
            TrieImpl storageTrie = RepositoryRoot.this.createTrie(composingSrc, accountState == null ? null : accountState.getStateRoot());
            return new StorageCache(storageTrie);
        }

        @Override
        protected synchronized boolean flushChild(byte[] key, StorageCache childCache) {
            if (super.flushChild(key, childCache)) {
                if (childCache != null) {
                    AccountState storageOwnerAcct = (AccountState)RepositoryRoot.this.accountStateCache.get(key);
                    childCache.trie.flush();
                    byte[] rootHash = childCache.trie.getRootHash();
                    RepositoryRoot.this.accountStateCache.put(key, storageOwnerAcct.withStateRoot(rootHash));
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    private static class StorageCache
    extends ReadWriteCache<DataWord, DataWord> {
        Trie<byte[]> trie;

        public StorageCache(Trie<byte[]> trie) {
            super(new SourceCodec<DataWord, DataWord, byte[], byte[]>(trie, Serializers.StorageKeySerializer, Serializers.StorageValueSerializer), WriteCache.CacheType.SIMPLE);
            this.trie = trie;
        }
    }
}

