/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ethereum.db.index.Index;

public class ArrayListIndex
implements Index {
    private List<Long> index;

    public ArrayListIndex(Collection<Long> numbers) {
        this.index = new ArrayList<Long>(numbers);
        this.sort();
    }

    @Override
    public synchronized void addAll(Collection<Long> nums) {
        this.index.addAll(nums);
        this.sort();
    }

    @Override
    public synchronized void add(Long num) {
        this.index.add(num);
        this.sort();
    }

    @Override
    public synchronized Long peek() {
        return this.index.get(0);
    }

    @Override
    public synchronized Long poll() {
        Long num = this.index.get(0);
        this.index.remove(0);
        return num;
    }

    @Override
    public synchronized boolean contains(Long num) {
        return Collections.binarySearch(this.index, num) >= 0;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.index.size();
    }

    @Override
    public synchronized void clear() {
        this.index.clear();
    }

    private void sort() {
        Collections.sort(this.index);
    }

    @Override
    public synchronized Iterator<Long> iterator() {
        return new ArrayList<Long>(this.index).iterator();
    }

    @Override
    public synchronized void removeAll(Collection<Long> indexes) {
        this.index.removeAll(indexes);
    }

    @Override
    public synchronized Long peekLast() {
        if (this.index.isEmpty()) {
            return null;
        }
        return this.index.get(this.index.size() - 1);
    }

    @Override
    public synchronized void remove(Long num) {
        this.index.remove(num);
    }
}

