/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.trie;

import org.ethereum.crypto.HashUtil;
import org.ethereum.datasource.Source;
import org.ethereum.trie.TrieImpl;
import org.ethereum.util.ByteUtil;

public class SecureTrie
extends TrieImpl {
    public SecureTrie(byte[] root) {
        super(root);
    }

    public SecureTrie(Source<byte[], byte[]> cache) {
        super(cache, null);
    }

    public SecureTrie(Source<byte[], byte[]> cache, byte[] root) {
        super(cache, root);
    }

    @Override
    public byte[] get(byte[] key) {
        return super.get(HashUtil.sha3(key));
    }

    @Override
    public void put(byte[] key, byte[] value) {
        super.put(HashUtil.sha3(key), value);
    }

    @Override
    public void delete(byte[] key) {
        this.put(key, ByteUtil.EMPTY_BYTE_ARRAY);
    }
}

