/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class CollectionUtils {
    public static <T> List<T> truncate(List<T> items, int limit) {
        if (limit > items.size()) {
            return new ArrayList<T>(items);
        }
        ArrayList<T> truncated = new ArrayList<T>(limit);
        for (T item : items) {
            truncated.add(item);
            if (truncated.size() != limit) continue;
            break;
        }
        return truncated;
    }

    public static <T> List<T> truncateRand(List<T> items, int limit) {
        int i2;
        if (limit > items.size()) {
            return new ArrayList<T>(items);
        }
        ArrayList truncated = new ArrayList(limit);
        LinkedList<Integer> index = new LinkedList<Integer>();
        for (i2 = 0; i2 < items.size(); ++i2) {
            index.add(i2);
        }
        if (limit * 2 < items.size()) {
            HashSet<Integer> smallIndex = new HashSet<Integer>();
            for (int i3 = 0; i3 < limit; ++i3) {
                int randomNum = ThreadLocalRandom.current().nextInt(0, index.size());
                smallIndex.add((Integer)index.remove(randomNum));
            }
            smallIndex.forEach(i -> truncated.add(items.get((int)i)));
        } else {
            for (i2 = 0; i2 < items.size() - limit; ++i2) {
                int randomNum = ThreadLocalRandom.current().nextInt(0, index.size());
                index.remove(randomNum);
            }
            index.forEach(i -> truncated.add(items.get((int)i)));
        }
        return truncated;
    }
}

