/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;

public class ExecutorPipeline<In, Out> {
    private BlockingQueue<Runnable> queue;
    private ThreadPoolExecutor exec;
    private boolean preserveOrder = false;
    private Function<In, Out> processor;
    private Consumer<Throwable> exceptionHandler;
    private ExecutorPipeline<Out, ?> next;
    private AtomicLong orderCounter = new AtomicLong();
    private long nextOutTaskNumber = 0L;
    private Map<Long, Out> orderMap = new HashMap<Long, Out>();
    private ReentrantLock lock = new ReentrantLock();
    private String threadPoolName;
    private static AtomicInteger pipeNumber = new AtomicInteger(1);
    private AtomicInteger threadNumber = new AtomicInteger(1);

    public ExecutorPipeline(int threads, int queueSize, boolean preserveOrder, Function<In, Out> processor, Consumer<Throwable> exceptionHandler) {
        this.queue = new LimitedQueue<Runnable>(queueSize);
        this.exec = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, this.queue, r -> new Thread(r, this.threadPoolName + "-" + this.threadNumber.getAndIncrement()));
        this.preserveOrder = preserveOrder;
        this.processor = processor;
        this.exceptionHandler = exceptionHandler;
        this.threadPoolName = "pipe-" + pipeNumber.getAndIncrement();
    }

    public ExecutorPipeline<Out, Void> add(int threads, int queueSize, Consumer<Out> consumer) {
        return this.add(threads, queueSize, false, out -> {
            consumer.accept(out);
            return null;
        });
    }

    public <NextOut> ExecutorPipeline<Out, NextOut> add(int threads, int queueSize, boolean preserveOrder, Function<Out, NextOut> processor) {
        ExecutorPipeline<Out, NextOut> ret = new ExecutorPipeline<Out, NextOut>(threads, queueSize, preserveOrder, processor, this.exceptionHandler);
        this.next = ret;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushNext(long order, Out res) {
        block9: {
            if (this.next != null) {
                if (!this.preserveOrder) {
                    this.next.push(res);
                } else {
                    this.lock.lock();
                    try {
                        if (order == this.nextOutTaskNumber) {
                            this.next.push(res);
                            while (true) {
                                ++this.nextOutTaskNumber;
                                Out out = this.orderMap.remove(this.nextOutTaskNumber);
                                if (out == null) {
                                    break block9;
                                }
                                this.next.push(out);
                            }
                        }
                        this.orderMap.put(order, res);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
        }
    }

    public void push(In in) {
        long order = this.orderCounter.getAndIncrement();
        this.exec.execute(() -> {
            try {
                this.pushNext(order, this.processor.apply(in));
            }
            catch (Throwable e) {
                this.exceptionHandler.accept(e);
            }
        });
    }

    public void pushAll(List<In> list) {
        for (In in : list) {
            this.push(in);
        }
    }

    public ExecutorPipeline<In, Out> setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
        return this;
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.queue;
    }

    public Map<Long, Out> getOrderMap() {
        return this.orderMap;
    }

    public void shutdown() {
        try {
            this.exec.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.next != null) {
            this.exec.shutdown();
        }
    }

    public boolean isShutdown() {
        return this.exec.isShutdown();
    }

    public void join() throws InterruptedException {
        this.exec.shutdown();
        this.exec.awaitTermination(10L, TimeUnit.MINUTES);
        if (this.next != null) {
            this.next.join();
        }
    }

    private static class LimitedQueue<E>
    extends LinkedBlockingQueue<E> {
        public LimitedQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        public boolean offer(E e) {
            try {
                this.put(e);
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }
}

