/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.DecodeResult;
import org.ethereum.util.RLPElement;
import org.ethereum.util.RLPItem;
import org.ethereum.util.RLPList;
import org.ethereum.util.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RLP {
    private static final Logger logger = LoggerFactory.getLogger((String)"rlp");
    public static final byte[] EMPTY_ELEMENT_RLP = RLP.encodeElement(new byte[0]);
    private static final int MAX_DEPTH = 16;
    private static final double MAX_ITEM_LENGTH = Math.pow(256.0, 8.0);
    private static final int SIZE_THRESHOLD = 56;
    private static final int OFFSET_SHORT_ITEM = 128;
    private static final int OFFSET_LONG_ITEM = 183;
    private static final int OFFSET_SHORT_LIST = 192;
    private static final int OFFSET_LONG_LIST = 247;

    private static byte decodeOneByteItem(byte[] data, int index) {
        if ((data[index] & 0xFF) == 128) {
            return (byte)(data[index] - 128);
        }
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) == 129) {
            return data[index + 1];
        }
        return 0;
    }

    public static int decodeInt(byte[] data, int index) {
        int value = 0;
        if (data[index] == 0) {
            throw new RuntimeException("not a number");
        }
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) <= 132) {
            int length = data[index] - 128;
            byte pow = (byte)(length - 1);
            for (int i = 1; i <= length; ++i) {
                value += (data[index + i] & 0xFF) << 8 * pow;
                pow = (byte)(pow - 1);
            }
        } else {
            throw new RuntimeException("wrong decode attempt");
        }
        return value;
    }

    static short decodeShort(byte[] data, int index) {
        short value = 0;
        if (data[index] == 0) {
            throw new RuntimeException("not a number");
        }
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) <= 130) {
            int length = data[index] - 128;
            byte pow = (byte)(length - 1);
            for (int i = 1; i <= length; ++i) {
                value = (short)(value + ((data[index + i] & 0xFF) << 8 * pow));
                pow = (byte)(pow - 1);
            }
        } else {
            throw new RuntimeException("wrong decode attempt");
        }
        return value;
    }

    public static long decodeLong(byte[] data, int index) {
        long value = 0L;
        if (data[index] == 0) {
            throw new RuntimeException("not a number");
        }
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) <= 136) {
            int length = data[index] - 128;
            byte pow = (byte)(length - 1);
            for (int i = 1; i <= length; ++i) {
                value += (long)(data[index + i] & 0xFF) << 8 * pow;
                pow = (byte)(pow - 1);
            }
        } else {
            throw new RuntimeException("wrong decode attempt");
        }
        return value;
    }

    private static String decodeStringItem(byte[] data, int index) {
        byte[] valueBytes = RLP.decodeItemBytes(data, index);
        if (valueBytes.length == 0) {
            return "";
        }
        return new String(valueBytes);
    }

    public static BigInteger decodeBigInteger(byte[] data, int index) {
        byte[] valueBytes = RLP.decodeItemBytes(data, index);
        if (valueBytes.length == 0) {
            return BigInteger.ZERO;
        }
        BigInteger res = new BigInteger(1, valueBytes);
        return res;
    }

    private static byte[] decodeByteArray(byte[] data, int index) {
        return RLP.decodeItemBytes(data, index);
    }

    private static int nextItemLength(byte[] data, int index) {
        if (index >= data.length) {
            return -1;
        }
        if ((data[index] & 0xFF) > 247) {
            byte lengthOfLength = (byte)(data[index] - 247);
            return RLP.calcLength(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) >= 192 && (data[index] & 0xFF) <= 247) {
            return (byte)((data[index] & 0xFF) - 192);
        }
        if ((data[index] & 0xFF) > 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            return RLP.calcLength(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) <= 183) {
            return (byte)((data[index] & 0xFF) - 128);
        }
        if ((data[index] & 0xFF) <= 128) {
            return 1;
        }
        return -1;
    }

    public static byte[] decodeIP4Bytes(byte[] data, int index) {
        int offset = 1;
        byte[] result = new byte[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = RLP.decodeOneByteItem(data, index + offset);
            if ((data[index + offset] & 0xFF) > 128) {
                offset += 2;
                continue;
            }
            ++offset;
        }
        return result;
    }

    public static int getFirstListElement(byte[] payload, int pos) {
        if (pos >= payload.length) {
            return -1;
        }
        if ((payload[pos] & 0xFF) > 247) {
            byte lengthOfLength = (byte)(payload[pos] - 247);
            return pos + lengthOfLength + 1;
        }
        if ((payload[pos] & 0xFF) >= 192 && (payload[pos] & 0xFF) <= 247) {
            return pos + 1;
        }
        if ((payload[pos] & 0xFF) > 183 && (payload[pos] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(payload[pos] - 183);
            return pos + lengthOfLength + 1;
        }
        return -1;
    }

    public static int getNextElementIndex(byte[] payload, int pos) {
        if (pos >= payload.length) {
            return -1;
        }
        if ((payload[pos] & 0xFF) > 247) {
            byte lengthOfLength = (byte)(payload[pos] - 247);
            int length = RLP.calcLength(lengthOfLength, payload, pos);
            return pos + lengthOfLength + length + 1;
        }
        if ((payload[pos] & 0xFF) >= 192 && (payload[pos] & 0xFF) <= 247) {
            byte length = (byte)((payload[pos] & 0xFF) - 192);
            return pos + 1 + length;
        }
        if ((payload[pos] & 0xFF) > 183 && (payload[pos] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(payload[pos] - 183);
            int length = RLP.calcLength(lengthOfLength, payload, pos);
            return pos + lengthOfLength + length + 1;
        }
        if ((payload[pos] & 0xFF) > 128 && (payload[pos] & 0xFF) <= 183) {
            byte length = (byte)((payload[pos] & 0xFF) - 128);
            return pos + 1 + length;
        }
        if ((payload[pos] & 0xFF) == 128) {
            return pos + 1;
        }
        if ((payload[pos] & 0xFF) < 128) {
            return pos + 1;
        }
        return -1;
    }

    private static int calcLength(int lengthOfLength, byte[] msgData, int pos) {
        byte pow = (byte)(lengthOfLength - 1);
        int length = 0;
        for (int i = 1; i <= lengthOfLength; ++i) {
            int bt = msgData[pos + i] & 0xFF;
            int shift = 8 * pow;
            if (bt == 0 && length == 0) {
                throw new RuntimeException("RLP length contains leading zeros");
            }
            if (32 - Integer.numberOfLeadingZeros(bt) + shift > 31) {
                return Integer.MAX_VALUE;
            }
            length += bt << shift;
            pow = (byte)(pow - 1);
        }
        RLP.verifyLength(length, msgData.length - pos - lengthOfLength);
        return length;
    }

    public static byte getCommandCode(byte[] data) {
        int index = RLP.getFirstListElement(data, 0);
        byte command = data[index];
        return (command & 0xFF) == 128 ? (byte)0 : command;
    }

    public static RLPList decode2(byte[] msgData, int depthLimit) {
        if (depthLimit < 1) {
            throw new RuntimeException("Depth limit should be 1 or higher");
        }
        RLPList rlpList = new RLPList();
        RLP.fullTraverse(msgData, 0, 0, msgData.length, rlpList, depthLimit);
        return rlpList;
    }

    public static RLPList decode2(byte[] msgData) {
        RLPList rlpList = new RLPList();
        RLP.fullTraverse(msgData, 0, 0, msgData.length, rlpList, Integer.MAX_VALUE);
        return rlpList;
    }

    public static RLPList unwrapList(byte[] msgData) {
        return (RLPList)RLP.decode2(msgData, 2).get(0);
    }

    public static RLPElement decode2OneItem(byte[] msgData, int startPos) {
        RLPList rlpList = new RLPList();
        RLP.fullTraverse(msgData, 0, startPos, startPos + 1, rlpList, Integer.MAX_VALUE);
        return (RLPElement)rlpList.get(0);
    }

    static void fullTraverse(byte[] msgData, int level, int startPos, int endPos, RLPList rlpList, int depth) {
        if (level > 16) {
            throw new RuntimeException(String.format("Error: Traversing over max RLP depth (%s)", 16));
        }
        try {
            if (msgData == null || msgData.length == 0) {
                return;
            }
            int pos = startPos;
            while (pos < endPos) {
                logger.debug("fullTraverse: level: " + level + " startPos: " + pos + " endPos: " + endPos);
                if ((msgData[pos] & 0xFF) > 247) {
                    byte lengthOfLength = (byte)(msgData[pos] - 247);
                    int length = RLP.calcLength(lengthOfLength, msgData, pos);
                    if (length < 56) {
                        throw new RuntimeException("Short list has been encoded as long list");
                    }
                    RLP.verifyLength(length, msgData.length - pos - lengthOfLength);
                    byte[] rlpData = new byte[lengthOfLength + length + 1];
                    System.arraycopy(msgData, pos, rlpData, 0, lengthOfLength + length + 1);
                    if (level + 1 < depth) {
                        RLPList newLevelList = new RLPList();
                        newLevelList.setRLPData(rlpData);
                        RLP.fullTraverse(msgData, level + 1, pos + lengthOfLength + 1, pos + lengthOfLength + length + 1, newLevelList, depth);
                        rlpList.add(newLevelList);
                    } else {
                        rlpList.add(new RLPItem(rlpData));
                    }
                    pos += lengthOfLength + length + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 192 && (msgData[pos] & 0xFF) <= 247) {
                    byte length = (byte)((msgData[pos] & 0xFF) - 192);
                    byte[] rlpData = new byte[length + 1];
                    System.arraycopy(msgData, pos, rlpData, 0, length + 1);
                    if (level + 1 < depth) {
                        RLPList newLevelList = new RLPList();
                        newLevelList.setRLPData(rlpData);
                        if (length > 0) {
                            RLP.fullTraverse(msgData, level + 1, pos + 1, pos + length + 1, newLevelList, depth);
                        }
                        rlpList.add(newLevelList);
                    } else {
                        rlpList.add(new RLPItem(rlpData));
                    }
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) > 183 && (msgData[pos] & 0xFF) < 192) {
                    byte lengthOfLength = (byte)(msgData[pos] - 183);
                    int length = RLP.calcLength(lengthOfLength, msgData, pos);
                    if (length < 56) {
                        throw new RuntimeException("Short item has been encoded as long item");
                    }
                    RLP.verifyLength(length, msgData.length - pos - lengthOfLength);
                    byte[] item = new byte[length];
                    System.arraycopy(msgData, pos + lengthOfLength + 1, item, 0, length);
                    RLPItem rlpItem = new RLPItem(item);
                    rlpList.add(rlpItem);
                    pos += lengthOfLength + length + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) > 128 && (msgData[pos] & 0xFF) <= 183) {
                    byte length = (byte)((msgData[pos] & 0xFF) - 128);
                    byte[] item = new byte[length];
                    System.arraycopy(msgData, pos + 1, item, 0, length);
                    if (length == 1 && (item[0] & 0xFF) < 128) {
                        throw new RuntimeException("Single byte has been encoded as byte string");
                    }
                    RLPItem rlpItem = new RLPItem(item);
                    rlpList.add(rlpItem);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) == 128) {
                    byte[] item = ByteUtil.EMPTY_BYTE_ARRAY;
                    RLPItem rlpItem = new RLPItem(item);
                    rlpList.add(rlpItem);
                    ++pos;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 128) continue;
                byte[] item = new byte[]{(byte)(msgData[pos] & 0xFF)};
                RLPItem rlpItem = new RLPItem(item);
                rlpList.add(rlpItem);
                ++pos;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("RLP wrong encoding (" + Hex.toHexString((byte[])msgData, (int)startPos, (int)(endPos - startPos)) + ")", e);
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Invalid RLP (excessive mem allocation while parsing) (" + Hex.toHexString((byte[])msgData, (int)startPos, (int)(endPos - startPos)) + ")", e);
        }
    }

    private static void verifyLength(int suppliedLength, int availableLength) {
        if (suppliedLength > availableLength) {
            throw new RuntimeException(String.format("Length parsed from RLP (%s bytes) is greater than possible size of entity (%s bytes)", suppliedLength, availableLength));
        }
    }

    public static DecodeResult decode(byte[] data, int pos) {
        if (data == null || data.length < 1) {
            return null;
        }
        int prefix = data[pos] & 0xFF;
        if (prefix == 128) {
            return new DecodeResult(pos + 1, "");
        }
        if (prefix < 128) {
            return new DecodeResult(pos + 1, new byte[]{data[pos]});
        }
        if (prefix <= 183) {
            int len = prefix - 128;
            return new DecodeResult(pos + 1 + len, java.util.Arrays.copyOfRange(data, pos + 1, pos + 1 + len));
        }
        if (prefix < 192) {
            int lenlen = prefix - 183;
            int lenbytes = ByteUtil.byteArrayToInt(java.util.Arrays.copyOfRange(data, pos + 1, pos + 1 + lenlen));
            RLP.verifyLength(lenbytes, data.length - pos - 1 - lenlen);
            return new DecodeResult(pos + 1 + lenlen + lenbytes, java.util.Arrays.copyOfRange(data, pos + 1 + lenlen, pos + 1 + lenlen + lenbytes));
        }
        if (prefix <= 247) {
            int len = prefix - 192;
            int prevPos = pos++;
            return RLP.decodeList(data, pos, prevPos, len);
        }
        if (prefix <= 255) {
            int lenlen = prefix - 247;
            int lenlist = ByteUtil.byteArrayToInt(java.util.Arrays.copyOfRange(data, pos + 1, pos + 1 + lenlen));
            pos = pos + lenlen + 1;
            int prevPos = lenlist;
            return RLP.decodeList(data, pos, prevPos, lenlist);
        }
        throw new RuntimeException("Only byte values between 0x00 and 0xFF are supported, but got: " + prefix);
    }

    public static LList decodeLazyList(byte[] data) {
        return RLP.decodeLazyList(data, 0, data.length).getList(0);
    }

    public static LList decodeLazyList(byte[] data, int pos, int length) {
        if (data == null || data.length < 1) {
            return null;
        }
        LList ret = new LList(data);
        int end = pos + length;
        while (pos < end) {
            int lenlen;
            int len;
            int prefix = data[pos] & 0xFF;
            if (prefix == 128) {
                ret.add(pos, 0, false);
                ++pos;
                continue;
            }
            if (prefix < 128) {
                ret.add(pos, 1, false);
                ++pos;
                continue;
            }
            if (prefix <= 183) {
                len = prefix - 128;
                ret.add(pos + 1, len, false);
                pos += len + 1;
                continue;
            }
            if (prefix < 192) {
                lenlen = prefix - 183;
                int lenbytes = ByteUtil.byteArrayToInt(java.util.Arrays.copyOfRange(data, pos + 1, pos + 1 + lenlen));
                RLP.verifyLength(lenbytes, data.length - pos - 1 - lenlen);
                ret.add(pos + 1 + lenlen, lenbytes, false);
                pos += 1 + lenlen + lenbytes;
                continue;
            }
            if (prefix <= 247) {
                len = prefix - 192;
                ret.add(pos + 1, len, true);
                pos += 1 + len;
                continue;
            }
            if (prefix <= 255) {
                lenlen = prefix - 247;
                int lenlist = ByteUtil.byteArrayToInt(java.util.Arrays.copyOfRange(data, pos + 1, pos + 1 + lenlen));
                RLP.verifyLength(lenlist, data.length - pos - 1 - lenlen);
                ret.add(pos + 1 + lenlen, lenlist, true);
                pos += 1 + lenlen + lenlist;
                continue;
            }
            throw new RuntimeException("Only byte values between 0x00 and 0xFF are supported, but got: " + prefix);
        }
        return ret;
    }

    private static DecodeResult decodeList(byte[] data, int pos, int prevPos, int len) {
        RLP.verifyLength(len, data.length - pos);
        ArrayList<Object> slice = new ArrayList<Object>();
        for (int i = 0; i < len; i += prevPos - pos) {
            DecodeResult result = RLP.decode(data, pos);
            slice.add(result.getDecoded());
            prevPos = result.getPos();
            pos = prevPos;
        }
        return new DecodeResult(pos, slice.toArray());
    }

    public static byte[] encode(Object input) {
        Value val = new Value(input);
        if (val.isList()) {
            List<Object> inputArray = val.asList();
            if (inputArray.isEmpty()) {
                return RLP.encodeLength(inputArray.size(), 192);
            }
            byte[] output = ByteUtil.EMPTY_BYTE_ARRAY;
            for (Object object : inputArray) {
                output = Arrays.concatenate((byte[])output, (byte[])RLP.encode(object));
            }
            byte[] prefix = RLP.encodeLength(output.length, 192);
            return Arrays.concatenate((byte[])prefix, (byte[])output);
        }
        byte[] inputAsBytes = RLP.toBytes(input);
        if (inputAsBytes.length == 1 && (inputAsBytes[0] & 0xFF) <= 128) {
            return inputAsBytes;
        }
        byte[] firstByte = RLP.encodeLength(inputAsBytes.length, 128);
        return Arrays.concatenate((byte[])firstByte, (byte[])inputAsBytes);
    }

    public static byte[] encodeLength(int length, int offset) {
        if (length < 56) {
            byte firstByte = (byte)(length + offset);
            return new byte[]{firstByte};
        }
        if ((double)length < MAX_ITEM_LENGTH) {
            byte[] binaryLength = length > 255 ? ByteUtil.intToBytesNoLeadZeroes(length) : new byte[]{(byte)length};
            byte firstByte = (byte)(binaryLength.length + offset + 56 - 1);
            return Arrays.concatenate((byte[])new byte[]{firstByte}, (byte[])binaryLength);
        }
        throw new RuntimeException("Input too long");
    }

    public static byte[] encodeByte(byte singleByte) {
        if ((singleByte & 0xFF) == 0) {
            return new byte[]{-128};
        }
        if ((singleByte & 0xFF) <= 127) {
            return new byte[]{singleByte};
        }
        return new byte[]{-127, singleByte};
    }

    public static byte[] encodeShort(short singleShort) {
        if ((singleShort & 0xFF) == singleShort) {
            return RLP.encodeByte((byte)singleShort);
        }
        return new byte[]{-126, (byte)(singleShort >> 8 & 0xFF), (byte)(singleShort >> 0 & 0xFF)};
    }

    public static byte[] encodeInt(int singleInt) {
        if ((singleInt & 0xFF) == singleInt) {
            return RLP.encodeByte((byte)singleInt);
        }
        if ((singleInt & 0xFFFF) == singleInt) {
            return RLP.encodeShort((short)singleInt);
        }
        if ((singleInt & 0xFFFFFF) == singleInt) {
            return new byte[]{-125, (byte)(singleInt >>> 16), (byte)(singleInt >>> 8), (byte)singleInt};
        }
        return new byte[]{-124, (byte)(singleInt >>> 24), (byte)(singleInt >>> 16), (byte)(singleInt >>> 8), (byte)singleInt};
    }

    public static byte[] encodeString(String srcString) {
        return RLP.encodeElement(srcString.getBytes());
    }

    public static byte[] encodeBigInteger(BigInteger srcBigInteger) {
        if (srcBigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new RuntimeException("negative numbers are not allowed");
        }
        if (srcBigInteger.equals(BigInteger.ZERO)) {
            return RLP.encodeByte((byte)0);
        }
        return RLP.encodeElement(BigIntegers.asUnsignedByteArray((BigInteger)srcBigInteger));
    }

    public static byte[] encodeElement(byte[] srcData) {
        int tmpLength;
        if (ByteUtil.isNullOrZeroArray(srcData)) {
            return new byte[]{-128};
        }
        if (ByteUtil.isSingleZero(srcData)) {
            return srcData;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return srcData;
        }
        if (srcData.length < 56) {
            byte length = (byte)(128 + srcData.length);
            byte[] data = java.util.Arrays.copyOf(srcData, srcData.length + 1);
            System.arraycopy(data, 0, data, 1, srcData.length);
            data[0] = length;
            return data;
        }
        int lengthOfLength = 0;
        for (tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            lengthOfLength = (byte)(lengthOfLength + 1);
        }
        byte[] data = new byte[1 + lengthOfLength + srcData.length];
        data[0] = (byte)(183 + lengthOfLength);
        tmpLength = srcData.length;
        for (int i = lengthOfLength; i > 0; --i) {
            data[i] = (byte)(tmpLength & 0xFF);
            tmpLength >>= 8;
        }
        System.arraycopy(srcData, 0, data, 1 + lengthOfLength, srcData.length);
        return data;
    }

    public static int calcElementPrefixSize(byte[] srcData) {
        if (ByteUtil.isNullOrZeroArray(srcData)) {
            return 0;
        }
        if (ByteUtil.isSingleZero(srcData)) {
            return 0;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return 0;
        }
        if (srcData.length < 56) {
            return 1;
        }
        int byteNum = 0;
        for (int tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        return 1 + byteNum;
    }

    public static byte[] encodeListHeader(int size) {
        byte[] header;
        if (size == 0) {
            return new byte[]{-64};
        }
        int totalLength = size;
        if (totalLength < 56) {
            header = new byte[]{(byte)(192 + totalLength)};
        } else {
            int tmpLength;
            int byteNum = 0;
            for (tmpLength = totalLength; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            tmpLength = totalLength;
            byte[] lenBytes = new byte[byteNum];
            for (int i = 0; i < byteNum; ++i) {
                lenBytes[byteNum - 1 - i] = (byte)(tmpLength >> 8 * i & 0xFF);
            }
            header = new byte[1 + lenBytes.length];
            header[0] = (byte)(247 + byteNum);
            System.arraycopy(lenBytes, 0, header, 1, lenBytes.length);
        }
        return header;
    }

    public static byte[] encodeLongElementHeader(int length) {
        if (length < 56) {
            if (length == 0) {
                return new byte[]{-128};
            }
            return new byte[]{(byte)(128 + length)};
        }
        int byteNum = 0;
        for (int tmpLength = length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        byte[] lenBytes = new byte[byteNum];
        for (int i = 0; i < byteNum; ++i) {
            lenBytes[byteNum - 1 - i] = (byte)(length >> 8 * i & 0xFF);
        }
        byte[] header = new byte[1 + lenBytes.length];
        header[0] = (byte)(183 + byteNum);
        System.arraycopy(lenBytes, 0, header, 1, lenBytes.length);
        return header;
    }

    public static byte[] encodeSet(Set<ByteArrayWrapper> data) {
        int dataLength = 0;
        HashSet<byte[]> encodedElements = new HashSet<byte[]>();
        for (ByteArrayWrapper element : data) {
            byte[] encodedElement = RLP.encodeElement(element.getData());
            dataLength += encodedElement.length;
            encodedElements.add(encodedElement);
        }
        byte[] listHeader = RLP.encodeListHeader(dataLength);
        byte[] output = new byte[listHeader.length + dataLength];
        System.arraycopy(listHeader, 0, output, 0, listHeader.length);
        int cummStart = listHeader.length;
        for (byte[] element : encodedElements) {
            System.arraycopy(element, 0, output, cummStart, element.length);
            cummStart += element.length;
        }
        return output;
    }

    public static byte[] wrapList(byte[] ... data) {
        byte[][] elements = new byte[data.length][];
        for (int i = 0; i < data.length; ++i) {
            elements[i] = RLP.encodeElement(data[i]);
        }
        return RLP.encodeList(elements);
    }

    public static byte[] encodeList(byte[] ... elements) {
        int copyPos;
        byte[] data;
        if (elements == null) {
            return new byte[]{-64};
        }
        int totalLength = 0;
        for (byte[] element1 : elements) {
            totalLength += element1.length;
        }
        if (totalLength < 56) {
            data = new byte[1 + totalLength];
            data[0] = (byte)(192 + totalLength);
            copyPos = 1;
        } else {
            int tmpLength;
            int byteNum = 0;
            for (tmpLength = totalLength; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            tmpLength = totalLength;
            byte[] lenBytes = new byte[byteNum];
            for (int i = 0; i < byteNum; ++i) {
                lenBytes[byteNum - 1 - i] = (byte)(tmpLength >> 8 * i & 0xFF);
            }
            data = new byte[1 + lenBytes.length + totalLength];
            data[0] = (byte)(247 + byteNum);
            System.arraycopy(lenBytes, 0, data, 1, lenBytes.length);
            copyPos = lenBytes.length + 1;
        }
        for (byte[] element : elements) {
            System.arraycopy(element, 0, data, copyPos, element.length);
            copyPos += element.length;
        }
        return data;
    }

    private static byte[] toBytes(Object input) {
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input instanceof String) {
            String inputString = (String)input;
            return inputString.getBytes();
        }
        if (input instanceof Long) {
            Long inputLong = (Long)input;
            return inputLong == 0L ? ByteUtil.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray((BigInteger)BigInteger.valueOf(inputLong));
        }
        if (input instanceof Integer) {
            Integer inputInt = (Integer)input;
            return inputInt == 0 ? ByteUtil.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray((BigInteger)BigInteger.valueOf(inputInt.intValue()));
        }
        if (input instanceof BigInteger) {
            BigInteger inputBigInt = (BigInteger)input;
            return inputBigInt.equals(BigInteger.ZERO) ? ByteUtil.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray((BigInteger)inputBigInt);
        }
        if (input instanceof Value) {
            Value val = (Value)input;
            return RLP.toBytes(val.asObj());
        }
        throw new RuntimeException("Unsupported type: Only accepting String, Integer and BigInteger for now");
    }

    private static byte[] decodeItemBytes(byte[] data, int index) {
        int length = RLP.calculateItemLength(data, index);
        if (length == 0) {
            return new byte[0];
        }
        if ((data[index] & 0xFF) < 128) {
            byte[] valueBytes = new byte[1];
            System.arraycopy(data, index, valueBytes, 0, 1);
            return valueBytes;
        }
        if ((data[index] & 0xFF) <= 183) {
            byte[] valueBytes = new byte[length];
            System.arraycopy(data, index + 1, valueBytes, 0, length);
            return valueBytes;
        }
        if ((data[index] & 0xFF) > 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            byte[] valueBytes = new byte[length];
            System.arraycopy(data, index + 1 + lengthOfLength, valueBytes, 0, length);
            return valueBytes;
        }
        throw new RuntimeException("wrong decode attempt");
    }

    private static int calculateItemLength(byte[] data, int index) {
        if ((data[index] & 0xFF) > 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            return RLP.calcLength(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) <= 183) {
            return (byte)(data[index] - 128);
        }
        if ((data[index] & 0xFF) == 128) {
            return 0;
        }
        if ((data[index] & 0xFF) < 128) {
            return 1;
        }
        throw new RuntimeException("wrong decode attempt");
    }

    public static final class LList {
        private final byte[] rlp;
        private final int[] offsets = new int[32];
        private final int[] lens = new int[32];
        private int cnt;

        public LList(byte[] rlp) {
            this.rlp = rlp;
        }

        public byte[] getEncoded() {
            byte[][] encoded = new byte[this.cnt][];
            for (int i = 0; i < this.cnt; ++i) {
                encoded[i] = RLP.encodeElement(this.getBytes(i));
            }
            return RLP.encodeList(encoded);
        }

        public void add(int off, int len, boolean isList) {
            this.offsets[this.cnt] = off;
            this.lens[this.cnt] = isList ? -1 - len : len;
            ++this.cnt;
        }

        public byte[] getBytes(int idx) {
            int len = this.lens[idx];
            len = len < 0 ? -len - 1 : len;
            byte[] ret = new byte[len];
            System.arraycopy(this.rlp, this.offsets[idx], ret, 0, len);
            return ret;
        }

        public LList getList(int idx) {
            return RLP.decodeLazyList(this.rlp, this.offsets[idx], -this.lens[idx] - 1);
        }

        public boolean isList(int idx) {
            return this.lens[idx] < 0;
        }

        public int size() {
            return this.cnt;
        }
    }
}

