/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.vm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nuls.core.crypto.HexUtil;
import java.math.BigInteger;
import java.util.Arrays;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.FastByteComparisons;

public final class DataWord
implements Comparable<DataWord> {
    public static final int MAX_POW = 256;
    public static final BigInteger _2_256 = BigInteger.valueOf(2L).pow(256);
    public static final BigInteger MAX_VALUE = _2_256.subtract(BigInteger.ONE);
    public static final DataWord ZERO = new DataWord(new byte[32]);
    public static final DataWord ONE = DataWord.of((byte)1);
    public static final long MEM_SIZE = 64L;
    private final byte[] data;
    private String sData;

    private DataWord(byte[] data) {
        if (data == null) {
            throw new RuntimeException("Input byte array should have 32 bytes in it!");
        }
        this.data = data;
    }

    public static DataWord of(byte[] data) {
        if (data == null || data.length == 0) {
            return ZERO;
        }
        int leadingZeroBits = ByteUtil.numberOfLeadingZeros(data);
        int valueBits = 8 * data.length - leadingZeroBits;
        if (valueBits <= 8) {
            if (data[data.length - 1] == 0) {
                return ZERO;
            }
            if (data[data.length - 1] == 1) {
                return ONE;
            }
        }
        if (data.length >= 32) {
            return new DataWord(Arrays.copyOf(data, data.length));
        }
        if (data.length <= 32) {
            byte[] bytes = new byte[32];
            System.arraycopy(data, 0, bytes, 32 - data.length, data.length);
            return new DataWord(bytes);
        }
        throw new RuntimeException(String.format("Data word can't exceed 32 bytes: 0x%s", ByteUtil.toHexString(data)));
    }

    public DataWord(String data) {
        this(data.getBytes());
        this.sData = data;
    }

    public static DataWord of(ByteArrayWrapper wrappedData) {
        return DataWord.of(wrappedData.getData());
    }

    @JsonCreator
    public static DataWord of(String data) {
        return DataWord.of(HexUtil.decode((String)data));
    }

    public static DataWord of(byte num) {
        byte[] bb = new byte[32];
        bb[31] = num;
        return new DataWord(bb);
    }

    public static DataWord of(int num) {
        return DataWord.of(ByteUtil.intToBytes(num));
    }

    public static DataWord of(long num) {
        return DataWord.of(ByteUtil.longToBytes(num));
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    private byte[] copyData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public byte[] getNoLeadZeroesData() {
        return ByteUtil.stripLeadingZeroes(this.copyData());
    }

    public byte[] getLast20Bytes() {
        return Arrays.copyOfRange(this.data, 12, this.data.length);
    }

    public BigInteger value() {
        return new BigInteger(1, this.data);
    }

    public int intValue() {
        int intVal = 0;
        for (byte aData : this.data) {
            intVal = (intVal << 8) + (aData & 0xFF);
        }
        return intVal;
    }

    public int intValueSafe() {
        int bytesOccupied = this.bytesOccupied();
        int intValue = this.intValue();
        if (bytesOccupied > 4 || intValue < 0) {
            return Integer.MAX_VALUE;
        }
        return intValue;
    }

    public long longValue() {
        long longVal = 0L;
        for (byte aData : this.data) {
            longVal = (longVal << 8) + (long)(aData & 0xFF);
        }
        return longVal;
    }

    public long longValueSafe() {
        int bytesOccupied = this.bytesOccupied();
        long longValue = this.longValue();
        if (bytesOccupied > 8 || longValue < 0L) {
            return Long.MAX_VALUE;
        }
        return longValue;
    }

    public BigInteger sValue() {
        return new BigInteger(this.data);
    }

    public String bigIntValue() {
        return new BigInteger(this.data).toString();
    }

    public boolean isZero() {
        if (this == ZERO) {
            return true;
        }
        return this.compareTo(ZERO) == 0;
    }

    public boolean isNegative() {
        int result = this.data[0] & 0x80;
        return result == 128;
    }

    public DataWord and(DataWord word) {
        byte[] newData = this.copyData();
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            newData[n] = (byte)(newData[n] & word.data[i]);
        }
        return new DataWord(newData);
    }

    public DataWord or(DataWord word) {
        byte[] newData = this.copyData();
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            newData[n] = (byte)(newData[n] | word.data[i]);
        }
        return new DataWord(newData);
    }

    public DataWord xor(DataWord word) {
        byte[] newData = this.copyData();
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            newData[n] = (byte)(newData[n] ^ word.data[i]);
        }
        return new DataWord(newData);
    }

    public DataWord negate() {
        if (this.isZero()) {
            return ZERO;
        }
        return this.bnot().add(ONE);
    }

    public DataWord bnot() {
        if (this.isZero()) {
            return new DataWord(ByteUtil.copyToArray(MAX_VALUE));
        }
        return new DataWord(ByteUtil.copyToArray(MAX_VALUE.subtract(this.value())));
    }

    public DataWord add(DataWord word) {
        byte[] newData = new byte[32];
        int overflow = 0;
        for (int i = 31; i >= 0; --i) {
            int v = (this.data[i] & 0xFF) + (word.data[i] & 0xFF) + overflow;
            newData[i] = (byte)v;
            overflow = v >>> 8;
        }
        return new DataWord(newData);
    }

    public DataWord add2(DataWord word) {
        BigInteger result = this.value().add(word.value());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord mul(DataWord word) {
        BigInteger result = this.value().multiply(word.value());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord div(DataWord word) {
        if (word.isZero()) {
            return ZERO;
        }
        BigInteger result = this.value().divide(word.value());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord sDiv(DataWord word) {
        if (word.isZero()) {
            return ZERO;
        }
        BigInteger result = this.sValue().divide(word.sValue());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord sub(DataWord word) {
        BigInteger result = this.value().subtract(word.value());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord exp(DataWord word) {
        BigInteger newData = this.value().modPow(word.value(), _2_256);
        return new DataWord(ByteUtil.copyToArray(newData));
    }

    public DataWord mod(DataWord word) {
        if (word.isZero()) {
            return ZERO;
        }
        BigInteger result = this.value().mod(word.value());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord sMod(DataWord word) {
        if (word.isZero()) {
            return ZERO;
        }
        BigInteger result = this.sValue().abs().mod(word.sValue().abs());
        result = this.sValue().signum() == -1 ? result.negate() : result;
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord addmod(DataWord word1, DataWord word2) {
        if (word2.isZero()) {
            return ZERO;
        }
        BigInteger result = this.value().add(word1.value()).mod(word2.value());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord mulmod(DataWord word1, DataWord word2) {
        if (this.isZero() || word1.isZero() || word2.isZero()) {
            return ZERO;
        }
        BigInteger result = this.value().multiply(word1.value()).mod(word2.value());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord shiftLeft(DataWord arg) {
        if (arg.value().compareTo(BigInteger.valueOf(256L)) >= 0) {
            return ZERO;
        }
        BigInteger result = this.value().shiftLeft(arg.intValueSafe());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord shiftRight(DataWord arg) {
        if (arg.value().compareTo(BigInteger.valueOf(256L)) >= 0) {
            return ZERO;
        }
        BigInteger result = this.value().shiftRight(arg.intValueSafe());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    public DataWord shiftRightSigned(DataWord arg) {
        if (arg.value().compareTo(BigInteger.valueOf(256L)) >= 0) {
            if (this.isNegative()) {
                return ONE.negate();
            }
            return ZERO;
        }
        BigInteger result = this.sValue().shiftRight(arg.intValueSafe());
        return new DataWord(ByteUtil.copyToArray(result.and(MAX_VALUE)));
    }

    @JsonValue
    public String toString() {
        return this.sData != null ? this.sData : ByteUtil.toHexString(this.data);
    }

    public String toPrefixString() {
        byte[] pref = this.getNoLeadZeroesData();
        if (pref.length == 0) {
            return "";
        }
        if (pref.length < 7) {
            return HexUtil.encode((byte[])pref);
        }
        return HexUtil.encode((byte[])pref).substring(0, 6);
    }

    public String shortHex() {
        String hexValue = HexUtil.encode((byte[])this.getNoLeadZeroesData()).toUpperCase();
        return "0x" + hexValue.replaceFirst("^0+(?!$)", "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataWord that = (DataWord)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public int compareTo(DataWord o) {
        if (o == null) {
            return -1;
        }
        int result = FastByteComparisons.compareTo(this.data, 0, this.data.length, o.data, 0, o.data.length);
        return (int)Math.signum(result);
    }

    public DataWord signExtend(byte k) {
        if (0 > k || k > 31) {
            throw new IndexOutOfBoundsException();
        }
        int mask = this.sValue().testBit(k * 8 + 7) ? -1 : 0;
        byte[] newData = this.copyData();
        for (int i = 31; i > k; --i) {
            newData[31 - i] = mask;
        }
        return new DataWord(newData);
    }

    public int bytesOccupied() {
        int firstNonZero = ByteUtil.firstNonZeroByte(this.data);
        if (firstNonZero == -1) {
            return 0;
        }
        return 31 - firstNonZero + 1;
    }

    public boolean isHex(String hex) {
        return HexUtil.encode((byte[])this.data).equals(hex);
    }

    public String asString() {
        return new String(this.getNoLeadZeroesData());
    }

    public DataWord(BigInteger bigInteger) {
        this(bigInteger.toString());
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.asString());
    }
}

