/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rockdb.manager;

import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.util.DBUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBManager {
    private static final ConcurrentHashMap<String, RocksDB> TABLES = new ConcurrentHashMap();
    private static final String BASE_DB_NAME = "rocksdb";
    private static ReentrantLock lock = new ReentrantLock();
    private static String dataPath;

    public static void setDataPath(String dataPath) {
        RocksDBManager.dataPath = dataPath;
    }

    public static void init(String path) throws Exception {
        RocksDBManager.init(path, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String path, Options options, Set<String> skipTables) throws Exception {
        Class<RocksDBManager> clazz = RocksDBManager.class;
        synchronized (RocksDBManager.class) {
            File dir = DBUtils.loadDataPath(path);
            dataPath = dir.getPath();
            Log.info((String)("RocksDBManager dataPath is " + dataPath));
            File[] tableFiles = dir.listFiles();
            String dbPath = null;
            for (File tableFile : tableFiles) {
                if (skipTables != null && skipTables.contains(tableFile.getName()) || !tableFile.isDirectory() || TABLES.get(tableFile.getName()) != null) continue;
                try {
                    dbPath = tableFile.getPath() + File.separator + BASE_DB_NAME;
                    RocksDB db = options == null ? RocksDBManager.initOpenDB(dbPath) : RocksDBManager.initOpenDB(dbPath, options);
                    if (db == null) continue;
                    TABLES.put(tableFile.getName(), db);
                }
                catch (Exception e) {
                    Log.warn((String)("load table failed, tableName: " + tableFile.getName() + ", dbPath: " + dbPath), (Throwable)e);
                    throw e;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static RocksDB initOpenDB(String dbPath, Options options) throws RocksDBException {
        File checkFile = new File(dbPath + File.separator + "CURRENT");
        if (!checkFile.exists()) {
            return null;
        }
        return RocksDB.open((Options)options, (String)dbPath);
    }

    private static RocksDB initOpenDB(String dbPath) throws RocksDBException {
        File checkFile = new File(dbPath + File.separator + "CURRENT");
        if (!checkFile.exists()) {
            return null;
        }
        Options options = RocksDBManager.getCommonOptions(false);
        return RocksDB.open((Options)options, (String)dbPath);
    }

    private static RocksDB openDB(String dbPath, boolean createIfMissing, Options options) throws RocksDBException {
        options.setCreateIfMissing(createIfMissing);
        return RocksDB.open((Options)options, (String)dbPath);
    }

    private static RocksDB openDB(String dbPath, boolean createIfMissing) throws RocksDBException {
        Options options = RocksDBManager.getCommonOptions(createIfMissing);
        return RocksDB.open((Options)options, (String)dbPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createTable(String tableName, Options options) throws Exception {
        lock.lock();
        try {
            if (StringUtils.isBlank((String)tableName)) {
                throw new Exception("Parameter can not be null");
            }
            if (TABLES.containsKey(tableName)) {
                throw new Exception("DB table exists");
            }
            if (StringUtils.isBlank((String)dataPath) || !DBUtils.checkPathLegal(tableName)) {
                throw new Exception("Create DB table path error");
            }
            try {
                File dir = new File(dataPath + File.separator + tableName);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                String filePath = dataPath + File.separator + tableName + File.separator + BASE_DB_NAME;
                RocksDB db = options == null ? RocksDBManager.openDB(filePath, true) : RocksDBManager.openDB(filePath, true, options);
                TABLES.put(tableName, db);
            }
            catch (Exception e) {
                Log.error((String)("error create table: " + tableName), (Throwable)e);
                throw new Exception("Create DB table error");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static boolean createTable(String tableName) throws Exception {
        return RocksDBManager.createTable(tableName, null);
    }

    public static RocksDB getTable(String tableName) {
        return TABLES.get(tableName);
    }

    public static boolean destroyTable(String tableName) throws Exception {
        if (!RocksDBManager.baseCheckTable(tableName)) {
            throw new Exception("DB table not exists");
        }
        if (StringUtils.isBlank((String)dataPath) || !DBUtils.checkPathLegal(tableName)) {
            throw new Exception("Create DB table path error");
        }
        try {
            RocksDB db = TABLES.remove(tableName);
            db.close();
            File dir = new File(dataPath + File.separator + tableName);
            if (!dir.exists()) {
                throw new Exception("DB table not exists");
            }
            String filePath = dataPath + File.separator + tableName + File.separator + BASE_DB_NAME;
            RocksDBManager.destroyDB(filePath);
        }
        catch (Exception e) {
            Log.error((String)("error destroy table: " + tableName), (Throwable)e);
            throw new Exception("Destroy DB table error");
        }
        return true;
    }

    private static void destroyDB(String dbPath) throws RocksDBException {
        Options options = new Options();
        RocksDB.destroyDB((String)dbPath, (Options)options);
    }

    public static void close() {
        Set<Map.Entry<String, RocksDB>> entries = TABLES.entrySet();
        for (Map.Entry<String, RocksDB> entry : entries) {
            try {
                TABLES.remove(entry.getKey());
                entry.getValue().close();
            }
            catch (Exception e) {
                Log.warn((String)"close rocksdb error", (Throwable)e);
            }
        }
    }

    public static void closeTable(String tableName) {
        try {
            RocksDB db = TABLES.remove(tableName);
            db.close();
        }
        catch (Exception e) {
            Log.warn((String)("close rocksdb tableName error:" + tableName), (Throwable)e);
        }
    }

    private static boolean baseCheckTable(String tableName) {
        if (StringUtils.isBlank((String)tableName) || !TABLES.containsKey(tableName)) {
            Log.warn((String)"tableName = {} is not in TABLES", (Object[])new Object[]{tableName});
            return false;
        }
        return true;
    }

    public static String[] listTable() {
        int i = 0;
        Enumeration<String> keys = TABLES.keys();
        String[] tables = new String[TABLES.size()];
        int length = tables.length;
        while (keys.hasMoreElements()) {
            tables[i++] = keys.nextElement();
            if (i != length) continue;
            break;
        }
        return tables;
    }

    public static boolean put(String table, byte[] key, byte[] value) throws Exception {
        if (!RocksDBManager.baseCheckTable(table)) {
            throw new Exception("DB table not exists");
        }
        if (key == null || value == null) {
            throw new Exception("Parameter can not be null");
        }
        try {
            RocksDB db = TABLES.get(table);
            db.put(key, value);
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new Exception("DB error");
        }
    }

    public static boolean delete(String table, byte[] key) throws Exception {
        if (!RocksDBManager.baseCheckTable(table)) {
            throw new Exception("DB table not exists");
        }
        if (key == null) {
            throw new Exception("Parameter can not be null");
        }
        try {
            RocksDB db = TABLES.get(table);
            db.delete(key);
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new Exception("DB error");
        }
    }

    public static boolean batchPut(String table, Map<byte[], byte[]> kvs) throws Exception {
        boolean bl;
        if (!RocksDBManager.baseCheckTable(table)) {
            throw new Exception("DB table not exists");
        }
        if (kvs == null || kvs.size() == 0) {
            throw new Exception("Parameter can not be null");
        }
        WriteBatch writeBatch = new WriteBatch();
        try {
            RocksDB db = TABLES.get(table);
            for (Map.Entry<byte[], byte[]> entry : kvs.entrySet()) {
                writeBatch.put(entry.getKey(), entry.getValue());
            }
            db.write(new WriteOptions(), writeBatch);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writeBatch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                Log.error((Throwable)ex);
                throw new Exception("DB error");
            }
        }
        writeBatch.close();
        return bl;
    }

    public static boolean deleteKeys(String table, List<byte[]> keys) throws Exception {
        boolean bl;
        if (!RocksDBManager.baseCheckTable(table)) {
            throw new Exception("DB table not exists");
        }
        if (keys == null || keys.size() == 0) {
            throw new Exception("Parameter can not be null");
        }
        WriteBatch writeBatch = new WriteBatch();
        try {
            RocksDB db = TABLES.get(table);
            for (byte[] key : keys) {
                writeBatch.delete(key);
            }
            db.write(new WriteOptions(), writeBatch);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writeBatch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                Log.error((Throwable)ex);
                throw new Exception("DB error");
            }
        }
        writeBatch.close();
        return bl;
    }

    public static byte[] get(String table, byte[] key) {
        if (!RocksDBManager.baseCheckTable(table)) {
            Log.error((String)"get table={}: error", (Object[])new Object[]{table});
            return null;
        }
        if (key == null) {
            return null;
        }
        try {
            RocksDB db = TABLES.get(table);
            return db.get(key);
        }
        catch (Exception e) {
            Log.error((String)"get table={}: error", (Object[])new Object[]{table});
            Log.error((Throwable)e);
            return null;
        }
    }

    public static boolean keyMayExist(String table, byte[] key) {
        if (!RocksDBManager.baseCheckTable(table)) {
            Log.error((String)"keyMayExist table={}: error", (Object[])new Object[]{table});
            return false;
        }
        if (key == null) {
            return false;
        }
        try {
            RocksDB db = TABLES.get(table);
            boolean rs = db.keyMayExist(key, new StringBuilder());
            return rs && db.get(key) != null;
        }
        catch (Exception e) {
            Log.error((String)"keyMayExist table={}: error", (Object[])new Object[]{table});
            Log.error((Throwable)e);
            return false;
        }
    }

    public static Map<byte[], byte[]> multiGet(String table, List<byte[]> keys) {
        if (!RocksDBManager.baseCheckTable(table)) {
            Log.error((String)"multiGet table={}: error", (Object[])new Object[]{table});
            return null;
        }
        if (keys == null || keys.size() == 0) {
            return null;
        }
        try {
            RocksDB db = TABLES.get(table);
            return db.multiGet(keys);
        }
        catch (Exception ex) {
            Log.error((String)"multiGet table={}: error", (Object[])new Object[]{table});
            Log.error((Throwable)ex);
            return null;
        }
    }

    public static List<byte[]> multiGetAsList(String table, List<byte[]> keys) {
        if (!RocksDBManager.baseCheckTable(table)) {
            return null;
        }
        if (keys == null || keys.size() == 0) {
            return null;
        }
        try {
            RocksDB db = TABLES.get(table);
            List list = db.multiGetAsList(keys);
            ArrayList<byte[]> rs = new ArrayList<byte[]>();
            for (byte[] tx : list) {
                if (null == tx) continue;
                rs.add(tx);
            }
            return rs;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<byte[]> multiGetValueList(String table, List<byte[]> keys) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        if (!RocksDBManager.baseCheckTable(table)) {
            Log.error((String)"multiGetValueList table={}: error", (Object[])new Object[]{table});
            return list;
        }
        if (keys == null || keys.size() == 0) {
            return list;
        }
        try {
            RocksDB db = TABLES.get(table);
            Map map = db.multiGet(keys);
            if (map != null && map.size() > 0) {
                list.addAll(map.values());
            }
            return list;
        }
        catch (Exception ex) {
            Log.error((String)"multiGetValueList table={}: error", (Object[])new Object[]{table});
            Log.error((Throwable)ex);
            return list;
        }
    }

    public static List<byte[]> multiGetKeyList(String table, List<byte[]> keys) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        if (!RocksDBManager.baseCheckTable(table)) {
            Log.error((String)"multiGetKeyList table={}: error", (Object[])new Object[]{table});
            return list;
        }
        if (keys == null || keys.size() == 0) {
            return list;
        }
        try {
            RocksDB db = TABLES.get(table);
            Map map = db.multiGet(keys);
            if (map != null && map.size() > 0) {
                list.addAll(map.keySet());
            }
            return list;
        }
        catch (Exception ex) {
            Log.error((String)"multiGetKeyList table={}: error", (Object[])new Object[]{table});
            Log.error((Throwable)ex);
            return list;
        }
    }

    public static List<byte[]> keyList(String table) {
        if (!RocksDBManager.baseCheckTable(table)) {
            Log.error((String)"keyList table={}: error", (Object[])new Object[]{table});
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        try {
            RocksDB db = TABLES.get(table);
            try (RocksIterator iterator = db.newIterator();){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    list.add(iterator.key());
                    iterator.next();
                }
            }
            return list;
        }
        catch (Exception ex) {
            Log.error((String)"keyList table={}: error", (Object[])new Object[]{table});
            Log.error((Throwable)ex);
            return null;
        }
    }

    public static List<byte[]> valueList(String table) {
        if (!RocksDBManager.baseCheckTable(table)) {
            Log.error((String)"valueList table={}: error", (Object[])new Object[]{table});
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        try {
            RocksDB db = TABLES.get(table);
            try (RocksIterator iterator = db.newIterator();){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    list.add(iterator.value());
                    iterator.next();
                }
            }
            return list;
        }
        catch (Exception ex) {
            Log.error((String)"valueList table={}: error", (Object[])new Object[]{table});
            Log.error((Throwable)ex);
            return null;
        }
    }

    public static List<Entry<byte[], byte[]>> entryList(String table) {
        if (!RocksDBManager.baseCheckTable(table)) {
            Log.error((String)"entryList table={}: error", (Object[])new Object[]{table});
            return null;
        }
        ArrayList<Entry<byte[], byte[]>> entryList = new ArrayList<Entry<byte[], byte[]>>();
        try {
            RocksDB db = TABLES.get(table);
            try (RocksIterator iterator = db.newIterator();){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    entryList.add(new Entry<byte[], byte[]>(iterator.key(), iterator.value()));
                    iterator.next();
                }
            }
            return entryList;
        }
        catch (Exception ex) {
            Log.error((String)"entryList table={}: error", (Object[])new Object[]{table});
            Log.error((Throwable)ex);
            return null;
        }
    }

    private static synchronized Options getCommonOptions(boolean createIfMissing) {
        Options options = new Options();
        options.setCreateIfMissing(createIfMissing);
        options.setAllowMmapReads(true);
        options.setCompressionType(CompressionType.NO_COMPRESSION);
        options.setMaxOpenFiles(-1);
        BlockBasedTableConfig tableOption = new BlockBasedTableConfig();
        tableOption.setNoBlockCache(true);
        tableOption.setBlockRestartInterval(4);
        tableOption.setFilterPolicy((Filter)new BloomFilter(10, true));
        options.setTableFormatConfig((TableFormatConfig)tableOption);
        options.setMaxBackgroundCompactions(16);
        options.setNewTableReaderForCompactionInputs(true);
        options.setCompactionReadaheadSize(131072L);
        options.setNewTableReaderForCompactionInputs(true);
        return options;
    }
}

