/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rockdb.service;

import io.nuls.core.log.Log;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.service.BatchOperation;
import org.rocksdb.RocksDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBBatchOperation
implements BatchOperation {
    private String table;
    private RocksDB db;
    private WriteBatch batch;
    private volatile boolean isClose = false;

    RocksDBBatchOperation(String table) {
        this.table = table;
        this.db = RocksDBManager.getTable(table);
        if (this.db != null) {
            this.batch = new WriteBatch();
        }
    }

    public boolean checkBatch() throws Exception {
        if (this.db == null) {
            throw new Exception("DB table not exists");
        }
        if (this.batch == null) {
            throw new Exception("DB error");
        }
        return true;
    }

    @Override
    public boolean put(byte[] key, byte[] value) throws Exception {
        if (key == null || value == null) {
            throw new Exception("Parameter can not be null");
        }
        this.batch.put(key, value);
        return true;
    }

    @Override
    public boolean delete(byte[] key) throws Exception {
        if (key == null) {
            throw new Exception("Parameter can not be null");
        }
        this.batch.delete(key);
        return true;
    }

    private void close() {
        this.isClose = true;
    }

    private boolean checkClose() {
        return this.isClose;
    }

    @Override
    public boolean executeBatch() throws Exception {
        if (this.checkClose()) {
            throw new Exception("DB batch operation closed");
        }
        try {
            this.db.write(new WriteOptions(), this.batch);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new Exception("DB error");
        }
        finally {
            if (this.batch != null) {
                this.close();
                this.batch.close();
            }
        }
        return true;
    }
}

