/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.protocol;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public interface TransactionProcessor {
    public static final Comparator<TransactionProcessor> COMPARATOR = Comparator.comparingInt(TransactionProcessor::getPriority);

    public int getType();

    @ResponseData(description="Return amap,mapIt contains verification error codes and transactions that did not pass verification", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="errorCode", description="Error code"), @Key(name="txList", valueType=List.class, valueElement=Transaction.class, description="The return type isList<Transaction>")}))
    public Map<String, Object> validate(int var1, List<Transaction> var2, Map<Integer, List<Transaction>> var3, BlockHeader var4);

    public boolean commit(int var1, List<Transaction> var2, BlockHeader var3);

    public boolean rollback(int var1, List<Transaction> var2, BlockHeader var3);

    default public int getPriority() {
        return 1;
    }
}

