/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.protocol.cmd;

import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.core.basic.VersionChangeInvoker;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.message.Response;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.NC)
public class CommonProtocolCmd
extends BaseCmd {
    @CmdAnnotation(cmd="protocolVersionChange", version=1.0, scope="private", description="")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int"), @Parameter(parameterName="protocolVersion", parameterType="short")})
    public Response process(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        short protocolVersion = Short.parseShort(map.get("protocolVersion").toString());
        ProtocolGroupManager.updateProtocol(chainId, protocolVersion);
        try {
            VersionChangeInvoker invoker = ProtocolGroupManager.getVersionChangeInvoker();
            Log.info((String)("protocolVersion change invoker-" + invoker));
            invoker.process(chainId);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.error((String)"getVersionChangeInvoker error");
            System.exit(1);
        }
        Log.info((String)("protocolVersion change-" + protocolVersion));
        return this.success();
    }
}

