/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.protocol.cmd;

import io.nuls.base.protocol.MessageProcessor;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.message.Response;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.NC)
public final class MessageDispatcher
extends BaseCmd {
    private List<MessageProcessor> processors;

    public List<MessageProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<MessageProcessor> processors) {
        processors.forEach(e -> Log.info((String)("register MessageProcessor-" + e.toString())));
        this.processors = processors;
    }

    @CmdAnnotation(cmd="msgProcess", version=1.0, description="")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int"), @Parameter(parameterName="nodeId", parameterType="String"), @Parameter(parameterName="cmd", parameterType="String"), @Parameter(parameterName="messageBody", parameterType="String")})
    public Response msgProcess(Map params) {
        ObjectUtils.canNotEmpty(params.get("chainId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("nodeId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("cmd"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("messageBody"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = (String)params.get("nodeId");
        String cmd = (String)params.get("cmd");
        String msgStr = (String)params.get("messageBody");
        for (MessageProcessor processor : this.processors) {
            if (!cmd.equals(processor.getCmd())) continue;
            try {
                processor.process(chainId, nodeId, msgStr);
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
            }
        }
        return this.success();
    }
}

