/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.protocol.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.CommonAdvice;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@NulsCoresCmd(module=ModuleE.NC)
public final class TransactionDispatcher
extends BaseCmd {
    private List<TransactionProcessor> processors;
    private Map<String, CommonAdvice> commitAdviceMap = new HashMap<String, CommonAdvice>();
    private Map<String, CommonAdvice> rollbackAdviceMap = new HashMap<String, CommonAdvice>();

    public List<TransactionProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<TransactionProcessor> processors) {
        processors.forEach(e -> Log.info((String)("register TransactionProcessor-" + e.toString())));
        processors.sort(TransactionProcessor.COMPARATOR);
        this.processors = processors;
    }

    public void register(ModuleE module, CommonAdvice commitAdvice, CommonAdvice rollbackAdvice) {
        if (module == ModuleE.SC) {
            if (commitAdvice != null) {
                this.commitAdviceMap.put(String.valueOf(10), commitAdvice);
            }
            if (rollbackAdvice != null) {
                this.rollbackAdviceMap.put(String.valueOf(10), rollbackAdvice);
            }
        }
        if (commitAdvice != null) {
            this.commitAdviceMap.put(module.abbr, commitAdvice);
        }
        if (rollbackAdvice != null) {
            this.rollbackAdviceMap.put(module.abbr, rollbackAdvice);
        }
    }

    @CmdAnnotation(cmd="txValidator", version=1.0, description="")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int"), @Parameter(parameterName="txList", parameterType="List"), @Parameter(parameterName="blockHeader", parameterType="String")})
    public Response txValidator(Map params) {
        ObjectUtils.canNotEmpty(params.get("chainId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("txList"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String blockHeaderStr = (String)params.get("blockHeader");
        BlockHeader blockHeader = null;
        if (StringUtils.isNotBlank((String)blockHeaderStr)) {
            blockHeader = (BlockHeader)RPCUtil.getInstanceRpcStr((String)blockHeaderStr, BlockHeader.class);
        }
        List txList = (List)params.get("txList");
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        ArrayList finalInvalidTxs = new ArrayList();
        for (Object txStr : txList) {
            Transaction transaction = (Transaction)RPCUtil.getInstanceRpcStr((String)txStr, Transaction.class);
            txs.add(transaction);
        }
        HashMap<Integer, List<Transaction>> map = new HashMap<Integer, List<Transaction>>();
        for (TransactionProcessor transactionProcessor : this.processors) {
            for (Transaction tx : txs) {
                List transactions = map.computeIfAbsent(transactionProcessor.getType(), k -> new ArrayList());
                if (tx.getType() != transactionProcessor.getType()) continue;
                transactions.add(tx);
            }
        }
        String errorCode = "";
        for (TransactionProcessor processor : this.processors) {
            List invalidTxs;
            Map<String, Object> validateMap;
            List transactions = (List)map.get(processor.getType());
            if (transactions.isEmpty() || (validateMap = processor.validate(chainId, transactions, map, blockHeader)) == null || (invalidTxs = (List)validateMap.get("txList")) == null || invalidTxs.isEmpty()) continue;
            errorCode = (String)validateMap.get("errorCode");
            finalInvalidTxs.addAll(invalidTxs);
            invalidTxs.forEach(e -> ((List)map.get(e.getType())).remove(e));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        List list = finalInvalidTxs.stream().map(e -> e.getHash().toHex()).collect(Collectors.toList());
        hashMap.put("errorCode", errorCode);
        hashMap.put("list", list);
        return this.success(hashMap);
    }

    @CmdAnnotation(cmd="txCommit", version=1.0, description="")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int"), @Parameter(parameterName="txList", parameterType="List"), @Parameter(parameterName="blockHeader", parameterType="String")})
    public Response txCommit(Map params) {
        ObjectUtils.canNotEmpty(params.get("chainId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        int chainId = Integer.parseInt(params.get("chainId").toString());
        if (ProtocolGroupManager.getCurrentVersion(chainId) >= 21) {
            return this._txCommitAfterP21(params);
        }
        return this._txCommit(params);
    }

    private Response _txCommitAfterP21(Map params) {
        ObjectUtils.canNotEmpty(params.get("chainId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("txList"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("blockHeader"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String blockHeaderStr = (String)params.get("blockHeader");
        BlockHeader blockHeader = (BlockHeader)RPCUtil.getInstanceRpcStr((String)blockHeaderStr, BlockHeader.class);
        List txList = (List)params.get("txList");
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        for (Object txStr : txList) {
            Transaction tx = (Transaction)RPCUtil.getInstanceRpcStr((String)txStr, Transaction.class);
            txs.add(tx);
        }
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (TransactionProcessor processor : this.processors) {
            for (Transaction tx : txs) {
                List transactions = map.computeIfAbsent(processor.getType(), k -> new ArrayList());
                if (tx.getType() != processor.getType()) continue;
                transactions.add(tx);
            }
        }
        HashSet<CommonAdvice> executed = new HashSet<CommonAdvice>();
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
        ArrayList<TransactionProcessor> completedProcessors = new ArrayList<TransactionProcessor>();
        for (TransactionProcessor processor : this.processors) {
            boolean commit;
            List transactions = (List)map.get(processor.getType());
            if (transactions.isEmpty()) continue;
            String moduleCode = (String)ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(processor.getType());
            CommonAdvice commitAdvice = this.commitAdviceMap.get(moduleCode);
            if (commitAdvice == null) {
                commitAdvice = this.commitAdviceMap.get(String.valueOf(processor.getType()));
            }
            if (commitAdvice != null && !executed.contains(commitAdvice)) {
                commitAdvice.begin(chainId, txs, blockHeader);
                executed.add(commitAdvice);
            }
            if (!(commit = processor.commit(chainId, transactions, blockHeader))) {
                completedProcessors.forEach(e -> e.rollback(chainId, (List)map.get(e.getType()), blockHeader));
                resultMap.put("value", commit);
                return this.success(resultMap);
            }
            completedProcessors.add(processor);
        }
        resultMap.put("value", true);
        if (!executed.isEmpty()) {
            executed.forEach(c -> c.end(chainId, txs, blockHeader));
        }
        return this.success(resultMap);
    }

    private Response _txCommit(Map params) {
        List transactions;
        ObjectUtils.canNotEmpty(params.get("chainId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("txList"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("blockHeader"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String blockHeaderStr = (String)params.get("blockHeader");
        BlockHeader blockHeader = (BlockHeader)RPCUtil.getInstanceRpcStr((String)blockHeaderStr, BlockHeader.class);
        List txList = (List)params.get("txList");
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        for (String txStr : txList) {
            Transaction tx = (Transaction)RPCUtil.getInstanceRpcStr((String)txStr, Transaction.class);
            txs.add(tx);
        }
        boolean commitAdviceBegin = false;
        CommonAdvice commitAdvice = null;
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (TransactionProcessor processor : this.processors) {
            for (Transaction tx : txs) {
                transactions = map.computeIfAbsent(processor.getType(), k -> new ArrayList());
                if (tx.getType() != processor.getType()) continue;
                transactions.add(tx);
            }
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
        ArrayList<TransactionProcessor> completedProcessors = new ArrayList<TransactionProcessor>();
        for (TransactionProcessor processor : this.processors) {
            boolean commit;
            transactions = (List)map.get(processor.getType());
            if (transactions.isEmpty()) continue;
            if (!commitAdviceBegin) {
                commitAdviceBegin = true;
                String moduleCode = (String)ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(processor.getType());
                commitAdvice = this.commitAdviceMap.get(moduleCode);
                if (commitAdvice == null) {
                    commitAdvice = this.commitAdviceMap.get(String.valueOf(processor.getType()));
                }
                if (commitAdvice != null) {
                    commitAdvice.begin(chainId, txs, blockHeader);
                }
            }
            if (!(commit = processor.commit(chainId, transactions, blockHeader))) {
                completedProcessors.forEach(e -> e.rollback(chainId, (List)map.get(e.getType()), blockHeader));
                resultMap.put("value", commit);
                return this.success(resultMap);
            }
            completedProcessors.add(processor);
        }
        resultMap.put("value", true);
        if (commitAdvice != null) {
            commitAdvice.end(chainId, txs, blockHeader);
        }
        return this.success(resultMap);
    }

    @CmdAnnotation(cmd="txRollback", version=1.0, description="")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int"), @Parameter(parameterName="txList", parameterType="List"), @Parameter(parameterName="blockHeader", parameterType="String")})
    public Response txRollback(Map params) {
        ObjectUtils.canNotEmpty(params.get("chainId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        int chainId = Integer.parseInt(params.get("chainId").toString());
        if (ProtocolGroupManager.getCurrentVersion(chainId) >= 21) {
            return this._txRollbackAfterP21(params);
        }
        return this._txRollback(params);
    }

    private Response _txRollbackAfterP21(Map params) {
        ObjectUtils.canNotEmpty(params.get("chainId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("txList"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("blockHeader"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String blockHeaderStr = (String)params.get("blockHeader");
        BlockHeader blockHeader = (BlockHeader)RPCUtil.getInstanceRpcStr((String)blockHeaderStr, BlockHeader.class);
        List txList = (List)params.get("txList");
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        Transaction coinbase = null;
        for (Object txStr : txList) {
            Transaction tx = (Transaction)RPCUtil.getInstanceRpcStr((String)txStr, Transaction.class);
            if (coinbase == null && tx.getType() == 1) {
                coinbase = tx;
            }
            txs.add(tx);
        }
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (TransactionProcessor processor : this.processors) {
            for (Transaction tx : txs) {
                List transactions = map.computeIfAbsent(processor.getType(), k -> new ArrayList());
                if (tx.getType() != processor.getType()) continue;
                transactions.add(tx);
            }
        }
        HashSet<CommonAdvice> executed = new HashSet<CommonAdvice>();
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
        ArrayList<TransactionProcessor> completedProcessors = new ArrayList<TransactionProcessor>();
        for (TransactionProcessor processor : this.processors) {
            boolean rollback;
            List transactions = (List)map.get(processor.getType());
            if (transactions.isEmpty()) continue;
            String moduleCode = (String)ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(processor.getType());
            CommonAdvice rollbackAdvice = this.rollbackAdviceMap.get(moduleCode);
            if (rollbackAdvice == null) {
                rollbackAdvice = this.rollbackAdviceMap.get(String.valueOf(processor.getType()));
            }
            if (rollbackAdvice != null && !executed.contains(rollbackAdvice)) {
                rollbackAdvice.begin(chainId, txs, blockHeader);
                rollbackAdvice.coinbase(chainId, coinbase, blockHeader);
                executed.add(rollbackAdvice);
            }
            if (!(rollback = processor.rollback(chainId, transactions, blockHeader))) {
                completedProcessors.forEach(e -> e.commit(chainId, (List)map.get(e.getType()), blockHeader));
                resultMap.put("value", rollback);
                return this.success(resultMap);
            }
            completedProcessors.add(processor);
        }
        resultMap.put("value", true);
        if (!executed.isEmpty()) {
            executed.forEach(r -> r.end(chainId, txs, blockHeader));
        }
        return this.success(resultMap);
    }

    private Response _txRollback(Map params) {
        List transactions;
        ObjectUtils.canNotEmpty(params.get("chainId"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("txList"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        ObjectUtils.canNotEmpty(params.get("blockHeader"), (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String blockHeaderStr = (String)params.get("blockHeader");
        BlockHeader blockHeader = (BlockHeader)RPCUtil.getInstanceRpcStr((String)blockHeaderStr, BlockHeader.class);
        List txList = (List)params.get("txList");
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        for (String txStr : txList) {
            Transaction tx = (Transaction)RPCUtil.getInstanceRpcStr((String)txStr, Transaction.class);
            txs.add(tx);
        }
        boolean rollbackAdviceBegin = false;
        CommonAdvice rollbackAdvice = null;
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (TransactionProcessor processor : this.processors) {
            for (Transaction tx : txs) {
                transactions = map.computeIfAbsent(processor.getType(), k -> new ArrayList());
                if (tx.getType() != processor.getType()) continue;
                transactions.add(tx);
            }
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
        ArrayList<TransactionProcessor> completedProcessors = new ArrayList<TransactionProcessor>();
        for (TransactionProcessor processor : this.processors) {
            boolean rollback;
            transactions = (List)map.get(processor.getType());
            if (transactions.isEmpty()) continue;
            if (!rollbackAdviceBegin) {
                rollbackAdviceBegin = true;
                String moduleCode = (String)ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(processor.getType());
                rollbackAdvice = this.rollbackAdviceMap.get(moduleCode);
                if (rollbackAdvice == null) {
                    rollbackAdvice = this.rollbackAdviceMap.get(String.valueOf(processor.getType()));
                }
                if (rollbackAdvice != null) {
                    rollbackAdvice.begin(chainId, txs, blockHeader);
                }
            }
            if (!(rollback = processor.rollback(chainId, transactions, blockHeader))) {
                completedProcessors.forEach(e -> e.commit(chainId, (List)map.get(e.getType()), blockHeader));
                resultMap.put("value", rollback);
                return this.success(resultMap);
            }
            completedProcessors.add(processor);
        }
        resultMap.put("value", true);
        if (rollbackAdvice != null) {
            rollbackAdvice.end(chainId, txs, blockHeader);
        }
        return this.success(resultMap);
    }
}

