/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.basic;

import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.VarInt;
import io.nuls.core.constant.ToolsConstant;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class NulsOutputStreamBuffer {
    private final OutputStream out;

    public NulsOutputStreamBuffer(OutputStream out) {
        this.out = out;
    }

    public void writeByte(byte b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    public void write(int val) throws IOException {
        this.out.write(val);
    }

    public void writeVarInt(int val) throws IOException {
        this.out.write(new VarInt((long)val).encode());
    }

    public void writeVarInt(long val) throws IOException {
        this.out.write(new VarInt(val).encode());
    }

    public void writeBytesWithLength(byte[] bytes) throws IOException {
        if (null == bytes || bytes.length == 0) {
            this.out.write(new VarInt(0L).encode());
        } else {
            this.out.write(new VarInt((long)bytes.length).encode());
            this.out.write(bytes);
        }
    }

    public void writeBoolean(boolean val) throws IOException {
        this.out.write(val ? 1 : 0);
    }

    public void writeShort(short val) throws IOException {
        SerializeUtils.int16ToByteStreamLE((short)val, (OutputStream)this.out);
    }

    public void writeUint8(short val) throws IOException {
        SerializeUtils.uint8ToByteStreamLE((short)val, (OutputStream)this.out);
    }

    public void writeUint16(int val) throws IOException {
        SerializeUtils.uint16ToByteStreamLE((int)val, (OutputStream)this.out);
    }

    public void writeUint32(long val) throws IOException {
        SerializeUtils.uint32ToByteStreamLE((long)val, (OutputStream)this.out);
    }

    public void writeUint48(long time) throws IOException {
        this.write(SerializeUtils.uint48ToBytes((long)time));
    }

    public void writeBigInteger(BigInteger val) throws IOException {
        if (val.compareTo(BigInteger.ZERO) < 0) {
            throw new UnsupportedOperationException();
        }
        this.write(SerializeUtils.bigInteger2Bytes((BigInteger)val));
    }

    public void writeInt64(long val) throws IOException {
        SerializeUtils.int64ToByteStreamLE((long)val, (OutputStream)this.out);
    }

    public void writeDouble(double val) throws IOException {
        this.out.write(ByteUtils.doubleToBytes((double)val));
    }

    public void writeString(String val) {
        if (StringUtils.isBlank((String)val)) {
            try {
                this.out.write(new VarInt(0L).encode());
            }
            catch (IOException e) {
                Log.error((Throwable)e);
                throw new NulsRuntimeException((Throwable)e);
            }
            return;
        }
        try {
            this.writeBytesWithLength(val.getBytes(ToolsConstant.DEFAULT_ENCODING));
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            throw new NulsRuntimeException((Throwable)e);
        }
    }

    public void writeNulsData(BaseNulsData data) throws IOException {
        if (null == data) {
            this.write(ToolsConstant.PLACE_HOLDER);
        } else {
            this.write(data.serialize());
        }
    }
}

