/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class BlockExtendsData
extends BaseNulsData {
    private long roundIndex;
    private int consensusMemberCount;
    private long roundStartTime;
    private int packingIndexOfRound;
    private short mainVersion;
    private short blockVersion;
    private byte effectiveRatio;
    private short continuousIntervalCount;
    private byte[] stateRoot;
    private byte[] seed;
    private byte[] nextSeedHash;

    public BlockExtendsData() {
    }

    public BlockExtendsData(byte[] extend) {
        try {
            this.parse(extend, 0);
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
        }
    }

    public short getMainVersion() {
        return this.mainVersion;
    }

    public void setMainVersion(short mainVersion) {
        this.mainVersion = mainVersion;
    }

    public short getBlockVersion() {
        return this.blockVersion;
    }

    public void setBlockVersion(short blockVersion) {
        this.blockVersion = blockVersion;
    }

    public byte getEffectiveRatio() {
        return this.effectiveRatio;
    }

    public void setEffectiveRatio(byte effectiveRatio) {
        this.effectiveRatio = effectiveRatio;
    }

    public short getContinuousIntervalCount() {
        return this.continuousIntervalCount;
    }

    public void setContinuousIntervalCount(short continuousIntervalCount) {
        this.continuousIntervalCount = continuousIntervalCount;
    }

    public long getRoundEndTime(long packingInterval) {
        return this.roundStartTime + (long)this.consensusMemberCount * packingInterval;
    }

    public int getConsensusMemberCount() {
        return this.consensusMemberCount;
    }

    public void setConsensusMemberCount(int consensusMemberCount) {
        this.consensusMemberCount = consensusMemberCount;
    }

    public long getRoundStartTime() {
        return this.roundStartTime;
    }

    public void setRoundStartTime(long roundStartTime) {
        this.roundStartTime = roundStartTime;
    }

    public int getPackingIndexOfRound() {
        return this.packingIndexOfRound;
    }

    public void setPackingIndexOfRound(int packingIndexOfRound) {
        this.packingIndexOfRound = packingIndexOfRound;
    }

    public long getRoundIndex() {
        return this.roundIndex;
    }

    public void setRoundIndex(long roundIndex) {
        this.roundIndex = roundIndex;
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint16();
        size += 7;
        size += SerializeUtils.sizeOfBytes((byte[])this.stateRoot);
        if (this.nextSeedHash != null) {
            size += 40;
        }
        return size;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint32(this.roundIndex);
        stream.writeUint16(this.consensusMemberCount);
        stream.writeUint32(this.roundStartTime);
        stream.writeUint16(this.packingIndexOfRound);
        stream.writeShort(this.mainVersion);
        stream.writeShort(this.blockVersion);
        stream.writeByte(this.effectiveRatio);
        stream.writeShort(this.continuousIntervalCount);
        stream.writeBytesWithLength(this.stateRoot);
        if (this.nextSeedHash != null) {
            stream.write(this.seed);
            stream.write(this.nextSeedHash);
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.roundIndex = byteBuffer.readUint32();
        this.consensusMemberCount = byteBuffer.readUint16();
        this.roundStartTime = byteBuffer.readUint32();
        this.packingIndexOfRound = byteBuffer.readUint16();
        this.mainVersion = byteBuffer.readShort();
        this.blockVersion = byteBuffer.readShort();
        this.effectiveRatio = byteBuffer.readByte();
        this.continuousIntervalCount = byteBuffer.readShort();
        this.stateRoot = byteBuffer.readByLengthByte();
        if (!byteBuffer.isFinished() && byteBuffer.getPayload().length >= byteBuffer.getCursor() + 40) {
            this.seed = byteBuffer.readBytes(32);
            this.nextSeedHash = byteBuffer.readBytes(8);
        }
    }

    public byte[] getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(byte[] stateRoot) {
        this.stateRoot = stateRoot;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public void setSeed(byte[] seed) {
        this.seed = seed;
    }

    public byte[] getNextSeedHash() {
        return this.nextSeedHash;
    }

    public void setNextSeedHash(byte[] nextSeedHash) {
        this.nextSeedHash = nextSeedHash;
    }

    public String toString() {
        return "{mainVersion=" + this.mainVersion + ", blockVersion=" + this.blockVersion + ", effectiveRatio=" + this.effectiveRatio + ", continuousIntervalCount=" + this.continuousIntervalCount + "}";
    }
}

