/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class BlockRoundData
extends BaseNulsData {
    protected long roundIndex;
    protected int consensusMemberCount;
    protected long roundStartTime;
    protected int packingIndexOfRound;

    public long getRoundEndTime() {
        return this.roundStartTime + (long)this.consensusMemberCount * BaseConstant.BLOCK_TIME_INTERVAL_SECOND;
    }

    public BlockRoundData() {
    }

    public BlockRoundData(byte[] extend) {
        try {
            this.parse(extend, 0);
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
        }
    }

    public int getConsensusMemberCount() {
        return this.consensusMemberCount;
    }

    public void setConsensusMemberCount(int consensusMemberCount) {
        this.consensusMemberCount = consensusMemberCount;
    }

    public long getRoundStartTime() {
        return this.roundStartTime;
    }

    public void setRoundStartTime(long roundStartTime) {
        this.roundStartTime = roundStartTime;
    }

    public int getPackingIndexOfRound() {
        return this.packingIndexOfRound;
    }

    public void setPackingIndexOfRound(int packingIndexOfRound) {
        this.packingIndexOfRound = packingIndexOfRound;
    }

    public long getRoundIndex() {
        return this.roundIndex;
    }

    public void setRoundIndex(long roundIndex) {
        this.roundIndex = roundIndex;
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint32();
        return size += SerializeUtils.sizeOfUint16();
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint32(this.roundIndex);
        stream.writeUint16(this.consensusMemberCount);
        stream.writeUint32(this.roundStartTime);
        stream.writeUint16(this.packingIndexOfRound);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.roundIndex = byteBuffer.readUint32();
        this.consensusMemberCount = byteBuffer.readUint16();
        this.roundStartTime = byteBuffer.readUint32();
        this.packingIndexOfRound = byteBuffer.readUint16();
    }
}

