/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.Coin;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;

public class CoinFrom
extends Coin {
    private byte[] nonce;
    private byte locked;

    public CoinFrom() {
    }

    public CoinFrom(byte[] address, int assetsChainId, int assetsId) {
        this.address = address;
        this.assetsChainId = assetsChainId;
        this.assetsId = assetsId;
    }

    public CoinFrom(byte[] address, int assetsChainId, int assetsId, BigInteger amount, byte locked) {
        this(address, assetsChainId, assetsId);
        this.amount = amount;
        this.locked = locked;
    }

    public CoinFrom(byte[] address, int assetsChainId, int assetsId, BigInteger amount, byte[] nonce, byte locked) {
        this(address, assetsChainId, assetsId, amount, locked);
        this.nonce = nonce;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBytesWithLength(this.address);
        stream.writeUint16(this.assetsChainId);
        stream.writeUint16(this.assetsId);
        stream.writeBigInteger(this.amount);
        stream.writeBytesWithLength(this.nonce);
        stream.write(this.locked);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.address = byteBuffer.readByLengthByte();
        this.assetsChainId = byteBuffer.readUint16();
        this.assetsId = byteBuffer.readUint16();
        this.amount = byteBuffer.readBigInteger();
        this.nonce = byteBuffer.readByLengthByte();
        this.locked = byteBuffer.readByte();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfBytes((byte[])this.address);
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfBytes((byte[])this.nonce);
        return ++size;
    }

    public String toString() {
        return "CoinFrom{address=" + AddressTool.getStringAddressByBytes(this.address) + ", assetsChainId=" + this.assetsChainId + ", assetsId=" + this.assetsId + ", amount=" + this.amount + ", nonce=" + HexUtil.encode((byte[])this.nonce) + ", locked=" + this.locked + "}";
    }

    @Override
    public byte[] getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(byte[] address) {
        this.address = address;
    }

    @Override
    public int getAssetsChainId() {
        return this.assetsChainId;
    }

    @Override
    public void setAssetsChainId(int assetsChainId) {
        this.assetsChainId = assetsChainId;
    }

    @Override
    public int getAssetsId() {
        return this.assetsId;
    }

    @Override
    public void setAssetsId(int assetsId) {
        this.assetsId = assetsId;
    }

    @Override
    public BigInteger getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public byte getLocked() {
        return this.locked;
    }

    public void setLocked(byte locked) {
        this.locked = locked;
    }
}

