/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.service;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Address;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.crypto.AESEncrypt;
import io.nuls.core.crypto.Base58;
import io.nuls.core.crypto.ECIESUtil;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.CryptoException;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.v2.SDKContext;
import io.nuls.v2.enums.EncodeType;
import io.nuls.v2.error.AccountErrorCode;
import io.nuls.v2.model.Account;
import io.nuls.v2.model.dto.AccountDto;
import io.nuls.v2.model.dto.AccountKeyStoreDto;
import io.nuls.v2.model.dto.RestFulResult;
import io.nuls.v2.model.dto.SignDto;
import io.nuls.v2.util.AccountTool;
import io.nuls.v2.util.CommonValidator;
import io.nuls.v2.util.RestFulUtil;
import io.nuls.v2.util.TxUtils;
import io.nuls.v2.util.ValidateUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AccountService {
    private static AccountService instance = new AccountService();

    private AccountService() {
    }

    public static AccountService getInstance() {
        return instance;
    }

    public Result<List<String>> createAccount(int count, String password) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            if (count < 1) {
                count = 1;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("count", count);
            params.put("password", password);
            RestFulResult restFulResult = RestFulUtil.post("api/account", params);
            if (restFulResult.isSuccess()) {
                Map dataMap = (Map)restFulResult.getData();
                result = Result.getSuccess(dataMap.get("list"));
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result<List<AccountDto>> createOffLineAccount(int count, String password) {
        ValidateUtil.validateChainId();
        ArrayList<AccountDto> list = new ArrayList<AccountDto>();
        try {
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            if (count < 1) {
                count = 1;
            }
            for (int i = 0; i < count; ++i) {
                Account account = StringUtils.isBlank((String)SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id) : AccountTool.createAccount(SDKContext.main_chain_id, null, SDKContext.addressPrefix);
                if (StringUtils.isNotBlank((String)password)) {
                    account.encrypt(password);
                }
                AccountDto accountDto = new AccountDto();
                accountDto.setAddress(account.getAddress().toString());
                accountDto.setPubKey(HexUtil.encode((byte[])account.getPubKey()));
                if (account.isEncrypted()) {
                    accountDto.setPrikey("");
                    accountDto.setEncryptedPrivateKey(HexUtil.encode((byte[])account.getEncryptedPriKey()));
                } else {
                    accountDto.setPrikey(HexUtil.encode((byte[])account.getPriKey()));
                    accountDto.setEncryptedPrivateKey("");
                }
                list.add(accountDto);
            }
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        return Result.getSuccess(list);
    }

    public Result<List<AccountDto>> createOffLineAccount(int chainId, int count, String prefix, String password) {
        ArrayList<AccountDto> list = new ArrayList<AccountDto>();
        try {
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            if (count < 1) {
                count = 1;
            }
            for (int i = 0; i < count; ++i) {
                Account account = StringUtils.isBlank((String)prefix) ? AccountTool.createAccount(chainId) : AccountTool.createAccount(chainId, null, prefix);
                if (StringUtils.isNotBlank((String)password)) {
                    account.encrypt(password);
                }
                AccountDto accountDto = new AccountDto();
                accountDto.setAddress(account.getAddress().toString());
                accountDto.setPubKey(HexUtil.encode((byte[])account.getPubKey()));
                if (account.isEncrypted()) {
                    accountDto.setPrikey("");
                    accountDto.setEncryptedPrivateKey(HexUtil.encode((byte[])account.getEncryptedPriKey()));
                } else {
                    accountDto.setPrikey(HexUtil.encode((byte[])account.getPriKey()));
                    accountDto.setEncryptedPrivateKey("");
                }
                list.add(accountDto);
            }
        }
        catch (NulsException var8) {
            return Result.getFailed((ErrorCode)var8.getErrorCode()).setMsg(var8.format());
        }
        return Result.getSuccess(list);
    }

    public Result getPriKey(String address, String password) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (!AddressTool.validAddress((int)SDKContext.main_chain_id, (String)address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", password);
            RestFulResult restFulResult = RestFulUtil.post("api/account/prikey/" + address, params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result getPriKeyOffline(String address, String encryptedPriKey, String password) {
        ValidateUtil.validateChainId();
        try {
            if (!AddressTool.validAddress((int)SDKContext.main_chain_id, (String)address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank((String)encryptedPriKey)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPriKey is invalid");
            }
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            byte[] priKeyBytes = AESEncrypt.decrypt((byte[])HexUtil.decode((String)encryptedPriKey), (String)password);
            if (!ECKey.isValidPrivteHex((String)HexUtil.encode((byte[])priKeyBytes))) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG);
            }
            Account account = StringUtils.isBlank((String)SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes), SDKContext.addressPrefix);
            if (!address.equals(account.getAddress().getBase58())) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("priKey", HexUtil.encode((byte[])account.getPriKey()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (CryptoException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PASSWORD_IS_WRONG).setMsg(AccountErrorCode.PASSWORD_IS_WRONG.getMsg());
        }
    }

    public Result importKeystore(AccountKeyStoreDto keyStore, String password) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (keyStore == null) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "[keyStore] is invalid");
            }
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("keystoreString", keyStore);
            params.put("password", password);
            params.put("overwrite", true);
            RestFulResult restFulResult = RestFulUtil.post("api/account/import/keystore/string", params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result exportKeyStore(String address, String password, String filePath) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (!AddressTool.validAddress((int)SDKContext.main_chain_id, (String)address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank((String)filePath)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "filePath is invalid");
            }
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", password);
            params.put("path", filePath);
            RestFulResult restFulResult = RestFulUtil.post("api/account/export/" + address, params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result resetPassword(String address, String oldPassword, String newPassword) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (!AddressTool.validAddress((int)SDKContext.main_chain_id, (String)address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (!FormatValidUtils.validPassword((String)oldPassword) || !FormatValidUtils.validPassword((String)newPassword)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", oldPassword);
            params.put("newPassword", newPassword);
            RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.put("api/account/password/" + address, params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result setAlias(String address, String alias, String password) {
        Result result;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("password", password);
        params.put("address", address);
        params.put("alias", alias);
        RestFulResult restFulResult = RestFulUtil.post("api/account/alias/", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result validateAddress(int chainId, String address) {
        boolean b = AddressTool.validAddress((int)chainId, (String)address);
        if (!b) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
        }
        return Result.getSuccess(null);
    }

    public Result resetPasswordOffline(String address, String encryptedPriKey, String oldPassword, String newPassword) {
        ValidateUtil.validateChainId();
        try {
            if (!AddressTool.validAddress((int)SDKContext.main_chain_id, (String)address)) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank((String)encryptedPriKey)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPriKey is invalid");
            }
            if (!FormatValidUtils.validPassword((String)oldPassword) || !FormatValidUtils.validPassword((String)newPassword)) {
                throw new NulsException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            byte[] priKeyBytes = AESEncrypt.decrypt((byte[])HexUtil.decode((String)encryptedPriKey), (String)oldPassword);
            if (!ECKey.isValidPrivteHex((String)HexUtil.encode((byte[])priKeyBytes))) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG);
            }
            Account account = StringUtils.isBlank((String)SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes), SDKContext.addressPrefix);
            if (!address.equals(account.getAddress().getBase58())) {
                throw new NulsException(AccountErrorCode.ADDRESS_ERROR);
            }
            account.encrypt(newPassword);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("newEncryptedPriKey", HexUtil.encode((byte[])account.getEncryptedPriKey()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (CryptoException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PASSWORD_IS_WRONG).setMsg(AccountErrorCode.PASSWORD_IS_WRONG.getMsg());
        }
    }

    public Result sign(List<SignDto> signDtoList, String txHex) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.validateSignDto(signDtoList);
            if (StringUtils.isBlank((String)txHex)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
            }
            ArrayList<ECKey> signEcKeys = new ArrayList<ECKey>();
            for (SignDto signDto : signDtoList) {
                byte[] priKeyBytes;
                if (StringUtils.isNotBlank((String)signDto.getPriKey())) {
                    if (!ECKey.isValidPrivteHex((String)signDto.getPriKey())) {
                        throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getPriKey() + " is invalid");
                    }
                    priKeyBytes = HexUtil.decode((String)signDto.getPriKey());
                } else {
                    try {
                        priKeyBytes = AESEncrypt.decrypt((byte[])HexUtil.decode((String)signDto.getEncryptedPrivateKey()), (String)signDto.getPassword());
                        if (!ECKey.isValidPrivteHex((String)HexUtil.encode((byte[])priKeyBytes))) {
                            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getEncryptedPrivateKey() + " is invalid");
                        }
                    }
                    catch (CryptoException e) {
                        throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + signDto.getEncryptedPrivateKey() + "] password error");
                    }
                }
                Account account = StringUtils.isBlank((String)SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes), SDKContext.addressPrefix);
                if (!signDto.getAddress().equals(account.getAddress().getBase58())) {
                    throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
                }
                ECKey ecKey = account.getEcKey(signDto.getPassword());
                signEcKeys.add(ecKey);
            }
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode((String)txHex)));
            SignatureUtil.createTransactionSignture((Transaction)tx, signEcKeys);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result sign(int chainId, String prefix, List<SignDto> signDtoList, String txHex) {
        try {
            if (StringUtils.isBlank((String)txHex)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
            }
            ArrayList<ECKey> signEcKeys = new ArrayList<ECKey>();
            for (SignDto signDto : signDtoList) {
                byte[] priKeyBytes;
                if (StringUtils.isNotBlank((String)signDto.getPriKey())) {
                    if (!ECKey.isValidPrivteHex((String)signDto.getPriKey())) {
                        throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getPriKey() + " is invalid");
                    }
                    priKeyBytes = HexUtil.decode((String)signDto.getPriKey());
                } else {
                    try {
                        priKeyBytes = AESEncrypt.decrypt((byte[])HexUtil.decode((String)signDto.getEncryptedPrivateKey()), (String)signDto.getPassword());
                        if (!ECKey.isValidPrivteHex((String)HexUtil.encode((byte[])priKeyBytes))) {
                            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getEncryptedPrivateKey() + " is invalid");
                        }
                    }
                    catch (CryptoException e) {
                        throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + signDto.getEncryptedPrivateKey() + "] password error");
                    }
                }
                Account account = StringUtils.isBlank((String)prefix) ? AccountTool.createAccount(chainId, HexUtil.encode((byte[])priKeyBytes)) : AccountTool.createAccount(chainId, HexUtil.encode((byte[])priKeyBytes), prefix);
                if (!signDto.getAddress().equals(account.getAddress().getBase58())) {
                    throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
                }
                ECKey ecKey = account.getEcKey(signDto.getPassword());
                signEcKeys.add(ecKey);
            }
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode((String)txHex)));
            SignatureUtil.createTransactionSignture((Transaction)tx, signEcKeys);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result sign(String txHex, int chainId, String prefix, String address, String encryptedPrivateKey, String password) {
        if (StringUtils.isBlank((String)txHex)) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
        }
        try {
            byte[] priKeyBytes;
            ArrayList<ECKey> signEcKeys = new ArrayList<ECKey>();
            try {
                priKeyBytes = AESEncrypt.decrypt((byte[])HexUtil.decode((String)encryptedPrivateKey), (String)password);
                if (!ECKey.isValidPrivteHex((String)HexUtil.encode((byte[])priKeyBytes))) {
                    throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, encryptedPrivateKey + " is invalid");
                }
            }
            catch (CryptoException e) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + encryptedPrivateKey + "] password error");
            }
            Account account = StringUtils.isBlank((String)prefix) ? AccountTool.createAccount(chainId, HexUtil.encode((byte[])priKeyBytes)) : AccountTool.createAccount(chainId, HexUtil.encode((byte[])priKeyBytes), prefix);
            if (!address.equals(account.getAddress().getBase58())) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
            }
            ECKey ecKey = account.getEcKey(password);
            signEcKeys.add(ecKey);
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode((String)txHex)));
            SignatureUtil.createTransactionSignture((Transaction)tx, signEcKeys);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result multiSign(SignDto signDto, String txHex) {
        ValidateUtil.validateChainId();
        try {
            P2PHKSignature p2PHKSignature;
            Object bytes;
            byte[] priKeyBytes;
            CommonValidator.validateSignDto(signDto);
            if (StringUtils.isBlank((String)txHex)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
            }
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode((String)txHex)));
            if (tx.getTransactionSignature() == null) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "is not multiSign TransferTx");
            }
            if (StringUtils.isNotBlank((String)signDto.getPriKey())) {
                if (!ECKey.isValidPrivteHex((String)signDto.getPriKey())) {
                    throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getPriKey() + " is invalid");
                }
                priKeyBytes = HexUtil.decode((String)signDto.getPriKey());
            } else {
                try {
                    priKeyBytes = AESEncrypt.decrypt((byte[])HexUtil.decode((String)signDto.getEncryptedPrivateKey()), (String)signDto.getPassword());
                    if (!ECKey.isValidPrivteHex((String)HexUtil.encode((byte[])priKeyBytes))) {
                        throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, signDto.getEncryptedPrivateKey() + " is invalid");
                    }
                }
                catch (CryptoException e) {
                    throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + signDto.getEncryptedPrivateKey() + "] password error");
                }
            }
            Account account = StringUtils.isBlank((String)SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes), SDKContext.addressPrefix);
            if (!signDto.getAddress().equals(account.getAddress().getBase58())) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
            }
            MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
            transactionSignature.parse(new NulsByteBuffer(tx.getTransactionSignature()));
            boolean hasPubKey = false;
            Iterator iterator = transactionSignature.getPubKeyList().iterator();
            while (iterator.hasNext()) {
                bytes = (byte[])iterator.next();
                if (!Arrays.equals(bytes, account.getPubKey())) continue;
                hasPubKey = true;
            }
            if (!hasPubKey) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " not one of the multiSign address");
            }
            ArrayList<P2PHKSignature> p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            if (p2PHKSignatures == null) {
                p2PHKSignatures = new ArrayList<P2PHKSignature>();
            }
            bytes = p2PHKSignatures.iterator();
            while (bytes.hasNext()) {
                p2PHKSignature = (P2PHKSignature)bytes.next();
                if (!Arrays.equals(p2PHKSignature.getPublicKey(), account.getPubKey())) continue;
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ALREADY_SIGNED);
            }
            ECKey ecKey = account.getEcKey(signDto.getPassword());
            p2PHKSignature = SignatureUtil.createSignatureByEckey((Transaction)tx, (ECKey)ecKey);
            p2PHKSignatures.add(p2PHKSignature);
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result multiSign(int chainId, String prefix, String address, String encryptedPrivateKey, String password, String txHex) {
        ValidateUtil.validateChainId();
        try {
            P2PHKSignature p2PHKSignature;
            Object bytes;
            byte[] priKeyBytes;
            if (StringUtils.isBlank((String)txHex)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "txHex is invalid");
            }
            Transaction tx = new Transaction();
            tx.parse(new NulsByteBuffer(HexUtil.decode((String)txHex)));
            if (tx.getTransactionSignature() == null) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR, "is not multiSign TransferTx");
            }
            try {
                priKeyBytes = AESEncrypt.decrypt((byte[])HexUtil.decode((String)encryptedPrivateKey), (String)password);
                if (!ECKey.isValidPrivteHex((String)HexUtil.encode((byte[])priKeyBytes))) {
                    throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG, encryptedPrivateKey + " is invalid");
                }
            }
            catch (CryptoException e) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "encryptedPrivateKey[" + encryptedPrivateKey + "] password error");
            }
            Account account = StringUtils.isBlank((String)SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes)) : AccountTool.createAccount(SDKContext.main_chain_id, HexUtil.encode((byte[])priKeyBytes), SDKContext.addressPrefix);
            if (!address.equals(account.getAddress().getBase58())) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " and private key do not match");
            }
            MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
            transactionSignature.parse(new NulsByteBuffer(tx.getTransactionSignature()));
            boolean hasPubKey = false;
            Iterator iterator = transactionSignature.getPubKeyList().iterator();
            while (iterator.hasNext()) {
                bytes = (byte[])iterator.next();
                if (!Arrays.equals(bytes, account.getPubKey())) continue;
                hasPubKey = true;
            }
            if (!hasPubKey) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR, account.getAddress() + " not one of the multiSign address");
            }
            ArrayList<P2PHKSignature> p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            if (p2PHKSignatures == null) {
                p2PHKSignatures = new ArrayList<P2PHKSignature>();
            }
            bytes = p2PHKSignatures.iterator();
            while (bytes.hasNext()) {
                p2PHKSignature = (P2PHKSignature)bytes.next();
                if (!Arrays.equals(p2PHKSignature.getPublicKey(), account.getPubKey())) continue;
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ALREADY_SIGNED);
            }
            ECKey ecKey = account.getEcKey(password);
            p2PHKSignature = SignatureUtil.createSignatureByEckey((Transaction)tx, (ECKey)ecKey);
            p2PHKSignatures.add(p2PHKSignature);
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.SERIALIZE_ERROR).setMsg(AccountErrorCode.SERIALIZE_ERROR.getMsg());
        }
    }

    public Result getAccountBalance(String address, int chainId, int assetsId) {
        Result result;
        ValidateUtil.validateChainId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("assetChainId", chainId);
        params.put("assetId", assetsId);
        RestFulResult restFulResult = RestFulUtil.post("api/accountledger/balance/" + address, params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result importPriKey(String priKey, String password) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (StringUtils.isBlank((String)priKey)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "priKey[" + priKey + "] is invalid");
            }
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "password[" + password + "] is invalid");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("priKey", priKey);
            params.put("password", password);
            params.put("overwrite", true);
            RestFulResult restFulResult = RestFulUtil.post("api/account/import/pri", params);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result createMultiSignAccount(List<String> pubKeys, int minSigns) {
        ValidateUtil.validateChainId();
        try {
            if (pubKeys == null || pubKeys.isEmpty()) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "pubKeys is invalid");
            }
            if (minSigns < 1 || minSigns > pubKeys.size()) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "minSigns is invalid");
            }
            MultiSigAccount multiSigAccount = AccountTool.createMultiSigAccount(SDKContext.main_chain_id, pubKeys, minSigns);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", multiSigAccount.getAddress().getBase58());
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result getAddressByPriKey(String priKey) {
        Account account;
        ValidateUtil.validateChainId();
        if (!ECKey.isValidPrivteHex((String)priKey)) {
            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
        }
        try {
            account = StringUtils.isBlank((String)SDKContext.addressPrefix) ? AccountTool.createAccount(SDKContext.main_chain_id, priKey) : AccountTool.createAccount(SDKContext.main_chain_id, priKey, SDKContext.addressPrefix);
        }
        catch (NulsException e) {
            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", account.getAddress().getBase58());
        return Result.getSuccess(map);
    }

    public Result changeV1addressToV2address(String v1Address) {
        byte[] addressV1 = AccountService.getAddress(v1Address);
        if (addressV1 == null) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR);
        }
        byte[] bytesV1 = new byte[20];
        System.arraycopy(addressV1, 3, bytesV1, 0, 20);
        byte[] addressV2 = SDKContext.main_chain_id == 1 ? new Address(1, "NULS", BaseConstant.DEFAULT_ADDRESS_TYPE, bytesV1).getAddressBytes() : new Address(2, "tNULS", BaseConstant.DEFAULT_ADDRESS_TYPE, bytesV1).getAddressBytes();
        Address address = Address.fromHashs((byte[])addressV2);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", address.getBase58());
        return Result.getSuccess(map);
    }

    public static byte[] getAddress(String addressString) {
        byte[] bytes;
        try {
            bytes = Base58.decode((String)addressString);
        }
        catch (Exception var3) {
            return null;
        }
        byte[] result = new byte[23];
        System.arraycopy(bytes, 0, result, 0, 23);
        return result;
    }

    public Result decryptData(String privateKey, String encryptMsg, EncodeType encodeType) {
        try {
            String result;
            String _privateKey = TxUtils.cleanHexPrefix(privateKey);
            String _encryptMsg = TxUtils.cleanHexPrefix(encryptMsg);
            byte[] decrypt = ECIESUtil.decrypt((byte[])HexUtil.decode((String)_privateKey), (String)_encryptMsg);
            switch (encodeType) {
                case HEX: {
                    result = HexUtil.encode((byte[])decrypt);
                    break;
                }
                case UTF8: {
                    result = new String(decrypt, StandardCharsets.UTF_8);
                    break;
                }
                default: {
                    return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
                }
            }
            return Result.getSuccess((Object)result);
        }
        catch (Throwable e) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.DATA_ERROR).setMsg(e.getMessage());
        }
    }
}

