/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.util;

import com.google.common.primitives.UnsignedBytes;
import io.nuls.base.data.Address;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.crypto.Sha256Hash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.v2.constant.AccountConstant;
import io.nuls.v2.error.AccountErrorCode;
import io.nuls.v2.model.Account;
import io.nuls.v2.util.ValidateUtil;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class AccountTool {
    public static final int CREATE_MAX_SIZE = 100;
    public static final int CREATE_MULTI_SIGACCOUNT_MIN_SIZE = 2;

    public static Address newAddress(int chainId, String prikey) {
        ECKey key;
        try {
            key = ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)prikey)));
        }
        catch (Exception e) {
            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
        }
        return AccountTool.newAddress(chainId, key.getPubKey());
    }

    public static Address newAddress(int chainId, ECKey key) {
        return AccountTool.newAddress(chainId, key.getPubKey());
    }

    public static Address newAddress(int chainId, byte[] publicKey) {
        return new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])publicKey));
    }

    public static Account createAccount(int chainId, String prikey, String prefix) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank((String)prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, prefix, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount1(int chainId, String prikey, String prefix) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank((String)prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate((BigInteger)new BigInteger(HexUtil.decode((String)prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, prefix, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount(int chainId, String prikey) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank((String)prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount1(int chainId, String prikey) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank((String)prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate((BigInteger)new BigInteger(HexUtil.decode((String)prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount(int chainId) throws NulsException {
        return AccountTool.createAccount(chainId, null);
    }

    public static Account createAccount1(int chainId) throws NulsException {
        return AccountTool.createAccount1(chainId, null);
    }

    public static Address createContractAddress(int chainId) {
        ECKey key = new ECKey();
        return new Address(chainId, BaseConstant.CONTRACT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
    }

    public static BigInteger genPrivKey(byte[] encryptedPriKey, byte[] pw) {
        byte[] privSeedSha256 = Sha256Hash.hash((byte[])encryptedPriKey);
        byte[] pwSha256 = Sha256Hash.hash((byte[])pw);
        byte[] pwPriBytes = new byte[privSeedSha256.length + pwSha256.length];
        for (int i = 0; i < pwPriBytes.length; i += 2) {
            int index = i / 2;
            pwPriBytes[index] = privSeedSha256[index];
            pwPriBytes[index + 1] = pwSha256[index];
        }
        return new BigInteger(1, Sha256Hash.hash((byte[])pwPriBytes));
    }

    public static byte[] createMultiSigAccountOriginBytes(int chainId, int n, List<String> pubKeys) throws NulsException {
        byte[] result = null;
        if (n < 2 || (pubKeys == null ? 0 : pubKeys.size()) < n) {
            throw new NulsRuntimeException(AccountErrorCode.FAILED);
        }
        HashSet<String> hashSet = new HashSet<String>(pubKeys);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(hashSet);
        if (pubKeys.size() < n) {
            throw new NulsRuntimeException(AccountErrorCode.FAILED);
        }
        Collections.sort(list, AccountConstant.PUBKEY_COMPARATOR);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(chainId);
            byteArrayOutputStream.write(n);
            for (String pubKey : pubKeys) {
                byteArrayOutputStream.write(HexUtil.decode((String)pubKey));
            }
            result = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new NulsRuntimeException(AccountErrorCode.FAILED);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static MultiSigAccount createMultiSigAccount(int chainId, List<String> pubKeys, int minSigns) throws NulsException {
        HashSet<String> pubkeySet = new HashSet<String>(pubKeys);
        if (pubkeySet.size() < pubKeys.size()) {
            throw new NulsException(AccountErrorCode.PUBKEY_REPEAT);
        }
        pubKeys = new ArrayList<String>(pubKeys);
        Collections.sort(pubKeys, new Comparator<String>(){
            private Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

            @Override
            public int compare(String k1, String k2) {
                return this.comparator.compare(Hex.decode((String)k1), Hex.decode((String)k2));
            }
        });
        Address address = new Address(chainId, BaseConstant.P2SH_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])AccountTool.createMultiSigAccountOriginBytes(chainId, minSigns, pubKeys)));
        MultiSigAccount multiSigAccount = new MultiSigAccount();
        multiSigAccount.setChainId(chainId);
        multiSigAccount.setAddress(address);
        multiSigAccount.setM((byte)minSigns);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (String pubKey : pubKeys) {
            list.add(HexUtil.decode((String)pubKey));
        }
        multiSigAccount.setPubKeyList(list);
        return multiSigAccount;
    }

    public static String getPrefix(String address) {
        for (int i = 1; i < address.length(); ++i) {
            char c = address.charAt(i);
            if (!ValidateUtil.regexMatch(c + "", "^[a-z]{1}$")) continue;
            return address.substring(0, i);
        }
        return null;
    }
}

