/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.util;

import io.nuls.core.parse.JSONUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final int timeOut = 10000;
    private static final Map<String, CloseableHttpClient> httpClientMap = new ConcurrentHashMap<String, CloseableHttpClient>();
    private static final Object syncLock = new Object();

    private static void config(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
        httpRequestBase.setConfig(requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient(String url) {
        String address;
        CloseableHttpClient httpClient;
        String hostname = url.split("/")[2];
        int port = 80;
        if (hostname.contains(":")) {
            String[] arr = hostname.split(":");
            hostname = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        if ((httpClient = httpClientMap.get(address = hostname + ":" + port)) == null) {
            Object object = syncLock;
            synchronized (object) {
                httpClient = httpClientMap.get(address);
                if (httpClient == null) {
                    httpClient = HttpClientUtil.createHttpClient(200, 40, 100, hostname, port);
                    httpClientMap.put(address, httpClient);
                }
            }
        }
        return httpClient;
    }

    public static void resetHttpClient(String url) {
        String hostname = url.split("/")[2];
        int port = 80;
        if (hostname.contains(":")) {
            String[] arr = hostname.split(":");
            hostname = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        String address = hostname + ":" + port;
        CloseableHttpClient client = httpClientMap.remove(address);
        try {
            client.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HttpClientUtil.getHttpClient(url);
    }

    public static CloseableHttpClient createHttpClient(int maxTotal, int maxPerRoute, int maxRoute, String hostname, int port) {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        HttpHost httpHost = new HttpHost(hostname, port);
        cm.setMaxPerRoute(new HttpRoute(httpHost), maxRoute);
        HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(httpRequestRetryHandler).build();
        return httpClient;
    }

    private static void setPostParams(HttpPost httpPost, Map<String, Object> params) throws Exception {
        String json = JSONUtils.obj2json(params);
        StringEntity entity = new StringEntity(json, "UTF-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
    }

    private static void setPutParams(HttpPut httpPut, Map<String, Object> params) throws Exception {
        String json = JSONUtils.obj2json(params);
        StringEntity entity = new StringEntity(json, "UTF-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        httpPut.setEntity((HttpEntity)entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, Object> params) throws Exception {
        CloseableHttpResponse response = null;
        try {
            HttpPost httppost = new HttpPost(url);
            HttpClientUtil.config((HttpRequestBase)httppost);
            HttpClientUtil.setPostParams(httppost, params);
            CloseableHttpClient httpClient = HttpClientUtil.getHttpClient(url);
            response = httpClient.execute((HttpUriRequest)httppost, (HttpContext)HttpClientContext.create());
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String put(String url, Map<String, Object> params) throws Exception {
        CloseableHttpResponse response = null;
        try {
            HttpPut httpPut = new HttpPut(url);
            HttpClientUtil.config((HttpRequestBase)httpPut);
            HttpClientUtil.setPutParams(httpPut, params);
            response = HttpClientUtil.getHttpClient(url).execute((HttpUriRequest)httpPut, (HttpContext)HttpClientContext.create());
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String get(String url) throws Exception {
        return HttpClientUtil.get(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, Object> params) throws Exception {
        if (null != params && !params.isEmpty()) {
            StringBuffer buffer = new StringBuffer("");
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                buffer.append("&" + entry.getKey() + "=" + entry.getValue());
            }
            url = url + buffer.toString();
        }
        HttpGet httpGet = new HttpGet(url);
        HttpClientUtil.config((HttpRequestBase)httpGet);
        CloseableHttpResponse response = null;
        try {
            response = HttpClientUtil.getHttpClient(url).execute((HttpUriRequest)httpGet, (HttpContext)HttpClientContext.create());
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            String result = HttpClientUtil.get("http://127.0.0.1:9898/api/accountledger/balance/tNULSeBaMt7c7sybfvP7iAC2p9d1ickHZvH9Sc");
            System.out.println(result);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("count", 2);
            param.put("password", "abcd1234");
            result = HttpClientUtil.post("http://127.0.0.1:9898/api/account", param);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

