/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.util;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.I18nUtils;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.v2.SDKContext;
import io.nuls.v2.enums.EncodeType;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.dto.AccountAmountDto;
import io.nuls.v2.model.dto.AccountBalanceDto;
import io.nuls.v2.model.dto.AccountDto;
import io.nuls.v2.model.dto.AccountKeyStoreDto;
import io.nuls.v2.model.dto.AliasDto;
import io.nuls.v2.model.dto.BlockDto;
import io.nuls.v2.model.dto.BlockHeaderDto;
import io.nuls.v2.model.dto.ConsensusDto;
import io.nuls.v2.model.dto.ContractCallForm;
import io.nuls.v2.model.dto.ContractConstructorInfoDto;
import io.nuls.v2.model.dto.ContractCreateForm;
import io.nuls.v2.model.dto.ContractDeleteForm;
import io.nuls.v2.model.dto.ContractInfoDto;
import io.nuls.v2.model.dto.ContractMethodForm;
import io.nuls.v2.model.dto.ContractResultDto;
import io.nuls.v2.model.dto.ContractTokenInfoDto;
import io.nuls.v2.model.dto.ContractTokenTransferForm;
import io.nuls.v2.model.dto.ContractTransferForm;
import io.nuls.v2.model.dto.ContractValidateCallForm;
import io.nuls.v2.model.dto.ContractValidateCreateForm;
import io.nuls.v2.model.dto.ContractValidateDeleteForm;
import io.nuls.v2.model.dto.ContractViewCallForm;
import io.nuls.v2.model.dto.CreateAgentForm;
import io.nuls.v2.model.dto.CrossTransferForm;
import io.nuls.v2.model.dto.CrossTransferTxFeeDto;
import io.nuls.v2.model.dto.DepositDto;
import io.nuls.v2.model.dto.DepositForm;
import io.nuls.v2.model.dto.DepositInfoDto;
import io.nuls.v2.model.dto.ImputedGasContractCallForm;
import io.nuls.v2.model.dto.ImputedGasContractCreateForm;
import io.nuls.v2.model.dto.MultiSignAliasDto;
import io.nuls.v2.model.dto.MultiSignConsensusDto;
import io.nuls.v2.model.dto.MultiSignDepositDto;
import io.nuls.v2.model.dto.MultiSignStopConsensusDto;
import io.nuls.v2.model.dto.MultiSignTransferDto;
import io.nuls.v2.model.dto.MultiSignTransferTxFeeDto;
import io.nuls.v2.model.dto.MultiSignWithDrawDto;
import io.nuls.v2.model.dto.ProgramMethod;
import io.nuls.v2.model.dto.ProgramMultyAssetValue;
import io.nuls.v2.model.dto.RpcResult;
import io.nuls.v2.model.dto.RpcResultError;
import io.nuls.v2.model.dto.SignDto;
import io.nuls.v2.model.dto.StopAgentForm;
import io.nuls.v2.model.dto.StopConsensusDto;
import io.nuls.v2.model.dto.TransactionDto;
import io.nuls.v2.model.dto.TransferDto;
import io.nuls.v2.model.dto.TransferForm;
import io.nuls.v2.model.dto.TransferTxFeeDto;
import io.nuls.v2.model.dto.WithDrawDto;
import io.nuls.v2.model.dto.WithdrawForm;
import io.nuls.v2.service.AccountService;
import io.nuls.v2.service.BlockService;
import io.nuls.v2.service.ConsensusService;
import io.nuls.v2.service.ContractService;
import io.nuls.v2.service.TransactionService;
import io.nuls.v2.util.ContractUtil;
import io.nuls.v2.util.JsonRpcUtil;
import io.nuls.v2.util.ListUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class NulsSDKTool {
    private static AccountService accountService = AccountService.getInstance();
    private static TransactionService transactionService = TransactionService.getInstance();
    private static BlockService blockService = BlockService.getInstance();
    private static ConsensusService consensusService = ConsensusService.getInstance();
    private static ContractService contractService = ContractService.getInstance();
    private static final String LANGUAGE = "en";
    private static final String LANGUAGE_PATH = "languages";

    @ApiOperation(description="\u83b7\u53d6\u672c\u94fe\u76f8\u5173\u4fe1\u606f,\u5176\u4e2d\u5171\u8bc6\u8d44\u4ea7\u4e3a\u672c\u94fe\u521b\u5efa\u5171\u8bc6\u8282\u70b9\u4ea4\u6613\u548c\u521b\u5efa\u59d4\u6258\u5171\u8bc6\u4ea4\u6613\u65f6\uff0c\u9700\u8981\u7528\u5230\u7684\u8d44\u4ea7", order=1)
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u672c\u94fe\u4fe1\u606f", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="chainId", description="\u672c\u94fe\u7684ID"), @Key(name="assetId", description="\u672c\u94fe\u9ed8\u8ba4\u4e3b\u8d44\u4ea7\u7684ID"), @Key(name="inflationAmount", description="\u672c\u94fe\u9ed8\u8ba4\u4e3b\u8d44\u4ea7\u7684\u521d\u59cb\u6570\u91cf"), @Key(name="agentChainId", description="\u672c\u94fe\u5171\u8bc6\u8d44\u4ea7\u7684\u94feID"), @Key(name="agentAssetId", description="\u672c\u94fe\u5171\u8bc6\u8d44\u4ea7\u7684ID")}))
    public static Result<Map> getInfo() {
        return blockService.getInfo();
    }

    @ApiOperation(description="\u6279\u91cf\u521b\u5efa\u8d26\u6237", order=101, detailDesc="\u521b\u5efa\u7684\u8d26\u6237\u5b58\u5728\u4e8e\u672c\u5730\u94b1\u5305\u5185")
    @Parameters(value={@Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="\u521b\u5efa\u6570\u91cf"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u8d26\u6237\u5730\u5740\u96c6\u5408", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public static Result<List<String>> createAccount(int count, String password) {
        return accountService.createAccount(count, password);
    }

    @ApiOperation(description="\u4fee\u6539\u8d26\u6237\u5bc6\u7801", order=102)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="oldPassword", parameterDes="\u539f\u5bc6\u7801"), @Parameter(parameterName="newPassword", parameterDes="\u65b0\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="\u662f\u5426\u4fee\u6539\u6210\u529f")}))
    public static Result resetPassword(String address, String oldPassword, String newPassword) {
        return accountService.resetPassword(address, oldPassword, newPassword);
    }

    @ApiOperation(description="\u5bfc\u51fa\u8d26\u6237\u79c1\u94a5", order=103, detailDesc="\u53ea\u80fd\u5bfc\u51fa\u672c\u5730\u94b1\u5305\u5df2\u5b58\u5728\u8d26\u6237\u7684\u79c1\u94a5")
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u79c1\u94a5")}))
    public static Result getPriKey(String address, String password) {
        return accountService.getPriKey(address, password);
    }

    @ApiOperation(description="\u6839\u636e\u79c1\u94a5\u5bfc\u5165\u8d26\u6237", order=104, detailDesc="\u5bfc\u5165\u79c1\u94a5\u65f6\uff0c\u9700\u8981\u8f93\u5165\u5bc6\u7801\u7ed9\u660e\u6587\u79c1\u94a5\u52a0\u5bc6")
    @Parameters(value={@Parameter(parameterName="priKey", parameterDes="\u8d26\u6237\u660e\u6587\u79c1\u94a5"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u8d26\u6237\u5730\u5740", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8d26\u6237\u5730\u5740")}))
    public static Result importPriKey(String priKey, String password) {
        return accountService.importPriKey(priKey, password);
    }

    @ApiOperation(description="\u6839\u636ekeystore\u5bfc\u5165\u8d26\u6237", order=105)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="pubKey", parameterDes="\u516c\u94a5"), @Parameter(parameterName="encryptedPriKey", parameterDes="\u52a0\u5bc6\u540e\u7684\u79c1\u94a5"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8d26\u6237\u5730\u5740")}))
    public static Result importKeystore(AccountKeyStoreDto keyStore, String password) {
        return accountService.importKeystore(keyStore, password);
    }

    @ApiOperation(description="\u5bfc\u51fakeystore\u5230\u6307\u5b9a\u6587\u4ef6\u76ee\u5f55", order=106)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801"), @Parameter(parameterName="filePath", parameterDes="\u6587\u4ef6\u76ee\u5f55")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="path", description="\u5bfc\u51fa\u7684\u6587\u4ef6\u8def\u5f84")}))
    public static Result exportKeyStore(String address, String password, String filePath) {
        return accountService.exportKeyStore(address, password, filePath);
    }

    @ApiOperation(description="\u67e5\u8be2\u8d26\u6237\u4f59\u989d", order=107, detailDesc="\u6839\u636e\u8d44\u4ea7\u94feID\u548c\u8d44\u4ea7ID\uff0c\u67e5\u8be2\u672c\u94fe\u8d26\u6237\u5bf9\u5e94\u8d44\u4ea7\u7684\u4f59\u989d\u4e0enonce\u503c")
    @Parameters(value={@Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8d44\u4ea7\u7684\u94feID"), @Parameter(parameterName="assetsId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8d44\u4ea7ID")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=AccountBalanceDto.class))
    public static Result getAccountBalance(String address, int chainId, int assetsId) {
        return accountService.getAccountBalance(address, chainId, assetsId);
    }

    @ApiOperation(description="\u8bbe\u7f6e\u8d26\u6237\u522b\u540d", order=108, detailDesc="\u522b\u540d\u683c\u5f0f\u4e3a1-20\u4f4d\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u7684\u7ec4\u5408\uff0c\u8bbe\u7f6e\u522b\u540d\u4f1a\u9500\u6bc11\u4e2aNULS")
    @Parameters(value={@Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="alias", requestType=@TypeDescriptor(value=String.class), parameterDes="\u522b\u540d"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8bbe\u7f6e\u522b\u540d\u4ea4\u6613\u7684hash")}))
    public static Result setAlias(String address, String alias, String password) {
        return accountService.setAlias(address, alias, password);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u5730\u5740\u683c\u5f0f\u662f\u5426\u6b63\u786e", order=109, detailDesc="\u9a8c\u8bc1\u672c\u94fe\u5730\u5740\u683c\u5f0f\u662f\u5426\u6b63\u786e")
    @Parameters(value={@Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5730\u5740")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class))
    public static Result validateAddress(String address) {
        return accountService.validateAddress(SDKContext.main_chain_id, address);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u5730\u5740\u683c\u5f0f\u662f\u5426\u6b63\u786e", order=110, detailDesc="\u6839\u636echainId\u9a8c\u8bc1\u5730\u5740\u683c\u5f0f\u662f\u5426\u6b63\u786e")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u94feID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8d26\u6237\u5730\u5740")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class))
    public static Result validateAddress(int chainId, String address) {
        return accountService.validateAddress(chainId, address);
    }

    @ApiOperation(description="\u79bb\u7ebf - \u6279\u91cf\u521b\u5efa\u8d26\u6237", order=150, detailDesc="\u521b\u5efa\u7684\u8d26\u6237\u4e0d\u4f1a\u4fdd\u5b58\u5230\u94b1\u5305\u4e2d,\u63a5\u53e3\u76f4\u63a5\u8fd4\u56de\u8d26\u6237\u7684keystore\u4fe1\u606f")
    @Parameters(value={@Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="\u521b\u5efa\u6570\u91cf"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2a\u8d26\u6237keystore\u96c6\u5408", responseType=@TypeDescriptor(value=List.class, collectionElement=AccountDto.class))
    public static Result<List<AccountDto>> createOffLineAccount(int count, String password) {
        return accountService.createOffLineAccount(count, password);
    }

    @ApiOperation(description="\u79bb\u7ebf - \u6279\u91cf\u521b\u5efa\u5730\u5740\u5e26\u56fa\u5b9a\u524d\u7f00\u7684\u8d26\u6237", order=151, detailDesc="\u521b\u5efa\u7684\u8d26\u6237\u4e0d\u4f1a\u4fdd\u5b58\u5230\u94b1\u5305\u4e2d,\u63a5\u53e3\u76f4\u63a5\u8fd4\u56de\u8d26\u6237\u7684keystore\u4fe1\u606f")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u5730\u5740\u5bf9\u5e94\u7684\u94feId"), @Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="\u521b\u5efa\u6570\u91cf"), @Parameter(parameterName="prefix", requestType=@TypeDescriptor(value=String.class), canNull=true, parameterDes="\u5730\u5740\u524d\u7f00"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2a\u8d26\u6237keystore\u96c6\u5408", responseType=@TypeDescriptor(value=List.class, collectionElement=AccountDto.class))
    public static Result<List<AccountDto>> createOffLineAccount(int chainId, int count, String prefix, String password) {
        return accountService.createOffLineAccount(chainId, count, prefix, password);
    }

    @ApiOperation(description="\u79bb\u7ebf\u4fee\u6539\u8d26\u6237\u5bc6\u7801", order=152)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="encryptedPriKey", parameterDes="\u52a0\u5bc6\u540e\u7684\u79c1\u94a5"), @Parameter(parameterName="oldPassword", parameterDes="\u539f\u5bc6\u7801"), @Parameter(parameterName="newPassword", parameterDes="\u65b0\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u91cd\u7f6e\u5bc6\u7801\u540e\u7684\u52a0\u5bc6\u79c1\u94a5")}))
    public static Result resetPasswordOffline(String address, String encryptedPriKey, String password, String newPassword) {
        return accountService.resetPasswordOffline(address, encryptedPriKey, password, newPassword);
    }

    @ApiOperation(description="\u79bb\u7ebf\u83b7\u53d6\u8d26\u6237\u660e\u6587\u79c1\u94a5", order=153)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="encryptedPriKey", parameterDes="\u52a0\u5bc6\u540e\u7684\u79c1\u94a5"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u660e\u6587\u79c1\u94a5")}))
    public static Result getPriKeyOffline(String address, String encryptedPriKey, String password) {
        return accountService.getPriKeyOffline(address, encryptedPriKey, password);
    }

    @ApiOperation(description="\u591a\u8d26\u6237\u6458\u8981\u7b7e\u540d", order=154, detailDesc="\u7528\u4e8e\u7b7e\u540d\u79bb\u7ebf\u7ec4\u88c5\u7684\u591a\u8d26\u6237\u8f6c\u8d26\u4ea4\u6613\uff0c\u8c03\u7528\u63a5\u53e3\u65f6\uff0c\u53c2\u6570\u53ef\u4ee5\u4f20\u5730\u5740\u548c\u79c1\u94a5\uff0c\u6216\u8005\u4f20\u5730\u5740\u548c\u52a0\u5bc6\u79c1\u94a5\u548c\u52a0\u5bc6\u5bc6\u7801")
    @Parameters(value={@Parameter(parameterName="signDtoList", parameterDes="\u6458\u8981\u7b7e\u540d\u8868\u5355", requestType=@TypeDescriptor(value=SignDto.class)), @Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u7b7e\u540d\u540e\u7684\u4ea4\u661316\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result sign(List<SignDto> signDtoList, String txHex) {
        return accountService.sign(signDtoList, txHex);
    }

    public static Result sign(int chainId, String prefix, List<SignDto> signDtoList, String txHex) {
        return accountService.sign(chainId, prefix, signDtoList, txHex);
    }

    @ApiOperation(description="\u591a\u7b7e\u8d26\u6237\u6458\u8981\u7b7e\u540d", order=155, detailDesc="\u7528\u4e8e\u7b7e\u540d\u79bb\u7ebf\u7ec4\u88c5\u7684\u591a\u7b7e\u8d26\u6237\u8f6c\u8d26\u4ea4\u6613\uff0c\u6bcf\u6b21\u8c03\u7528\u63a5\u53e3\u65f6\uff0c\u53ea\u80fd\u4f20\u5165\u4e00\u4e2a\u8d26\u6237\u7684\u79c1\u94a5\u8fdb\u884c\u7b7e\u540d\uff0c\u7b7e\u540d\u6210\u529f\u540e\u8fd4\u56de\u7684\u4ea4\u6613\u5b57\u7b26\u4e32\u518d\u4ea4\u7ed9\u7b2c\u4e8c\u4e2a\u8d26\u6237\u7b7e\u540d\uff0c\u4f9d\u6b21\u7c7b\u63a8")
    @Parameters(value={@Parameter(parameterName="signDto", parameterDes="\u6458\u8981\u7b7e\u540d\u8868\u5355", requestType=@TypeDescriptor(value=SignDto.class)), @Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u7b7e\u540d\u540e\u7684\u4ea4\u661316\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result multiSign(SignDto signDto, String txHex) {
        return accountService.multiSign(signDto, txHex);
    }

    @ApiOperation(description="\u660e\u6587\u79c1\u94a5\u6458\u8981\u7b7e\u540d", order=156)
    @Parameters(value={@Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32"), @Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="privateKey", parameterDes="\u8d26\u6237\u660e\u6587\u79c1\u94a5")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u7b7e\u540d\u540e\u7684\u4ea4\u661316\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result sign(String txHex, String address, String privateKey) {
        return transactionService.signTx(txHex, address, privateKey);
    }

    @ApiOperation(description="\u5bc6\u6587\u79c1\u94a5\u6458\u8981\u7b7e\u540d", order=157)
    @Parameters(value={@Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32"), @Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="encryptedPrivateKey", parameterDes="\u8d26\u6237\u5bc6\u6587\u79c1\u94a5"), @Parameter(parameterName="password", parameterDes="\u5bc6\u7801")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u7b7e\u540d\u540e\u7684\u4ea4\u661316\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result sign(String txHex, String address, String encryptedPrivateKey, String password) {
        return transactionService.signTx(txHex, address, encryptedPrivateKey, password);
    }

    public static Result sign(String txHex, int chainId, String prefix, String address, String encryptedPrivateKey, String password) {
        return accountService.sign(txHex, chainId, prefix, address, encryptedPrivateKey, password);
    }

    public Result multiSign(int chainId, String prefix, String address, String encryptedPrivateKey, String password, String txHex) {
        return accountService.multiSign(chainId, prefix, address, encryptedPrivateKey, password, txHex);
    }

    @ApiOperation(description="\u521b\u5efa\u591a\u7b7e\u8d26\u6237", order=158, detailDesc="\u6839\u636e\u591a\u4e2a\u8d26\u6237\u7684\u516c\u94a5\u521b\u5efa\u591a\u7b7e\u8d26\u6237\uff0cminSigns\u4e3a\u591a\u7b7e\u8d26\u6237\u521b\u5efa\u4ea4\u6613\u65f6\u9700\u8981\u7684\u6700\u5c0f\u7b7e\u540d\u6570")
    @Parameters(value={@Parameter(parameterName="pubKeys", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="\u8d26\u6237\u516c\u94a5\u96c6\u5408"), @Parameter(parameterName="minSigns", requestType=@TypeDescriptor(value=int.class), parameterDes="\u6700\u5c0f\u7b7e\u540d\u6570")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8d26\u6237\u7684\u5730\u5740")}))
    public static Result createMultiSignAccount(List<String> pubKeys, int minSigns) {
        return accountService.createMultiSignAccount(pubKeys, minSigns);
    }

    @ApiOperation(description="\u6839\u636e\u79c1\u94a5\u83b7\u53d6\u5730\u5740", order=159, detailDesc="\u6839\u636e\u4f20\u5165\u7684\u79c1\u94a5\uff0c\u751f\u6210\u5bf9\u5e94\u7684\u5730\u5740\uff0c\u79c1\u94a5\u4e0d\u4f1a\u5b58\u50a8\u5728\u94b1\u5305\u91cc")
    @Parameters(value={@Parameter(parameterName="priKey", parameterDes="\u539f\u59cb\u79c1\u94a5")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u8d26\u6237\u7684\u5730\u5740")}))
    public static Result getAddressByPriKey(String priKey) {
        return accountService.getAddressByPriKey(priKey);
    }

    @ApiOperation(description="\u8f6c\u6362NULS1.0\u5730\u5740\u4e3aNULS2.0\u5730\u5740", order=160, detailDesc="\u8f6c\u6362NULS1.0\u5730\u5740\u4e3aNULS2.0\u5730\u5740")
    @Parameters(value={@Parameter(parameterName="v1Address", requestType=@TypeDescriptor(value=String.class), parameterDes="NULS1.0\u8d26\u6237\u5730\u5740")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="NULS2.0\u5730\u5740")}))
    public static Result changeV1addressToV2address(String v1Address) {
        return accountService.changeV1addressToV2address(v1Address);
    }

    @ApiOperation(description="\u6d88\u606f\u89e3\u5bc6", order=161)
    @Parameters(value={@Parameter(parameterName="privateKey", parameterDes="\u79c1\u94a5"), @Parameter(parameterName="encryptMsg", parameterDes="\u52a0\u5bc6\u6d88\u606f"), @Parameter(parameterName="encodeType", parameterDes="\u89e3\u5bc6\u6d88\u606f\u7684\u7f16\u7801\u65b9\u5f0f: HEX, UTF8")})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u89e3\u5bc6\u6d88\u606f")}))
    public static Result decryptData(String privateKey, String encryptMsg, EncodeType encodeType) {
        return accountService.decryptData(privateKey, encryptMsg, encodeType);
    }

    @ApiOperation(description="\u6839\u636e\u533a\u5757\u9ad8\u5ea6\u67e5\u8be2\u533a\u5757\u5934", order=201)
    @Parameters(value={@Parameter(parameterName="height", requestType=@TypeDescriptor(value=Long.class), parameterDes="\u533a\u5757\u9ad8\u5ea6")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBlockHeader(long height) {
        return blockService.getBlockHeader(height);
    }

    @ApiOperation(description="\u6839\u636e\u533a\u5757hash\u67e5\u8be2\u533a\u5757\u5934", order=202)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="\u533a\u5757hash")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBlockHeader(String hash) {
        return blockService.getBlockHeader(hash);
    }

    @ApiOperation(description="\u6839\u636e\u533a\u5757\u9ad8\u5ea6\u67e5\u8be2\u533a\u5757\uff0c\u5305\u542b\u533a\u5757\u6253\u5305\u7684\u6240\u6709\u4ea4\u6613\u4fe1\u606f\uff0c\u6b64\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u91cf\u8f83\u591a\uff0c\u8c28\u614e\u8c03\u7528", order=203)
    @Parameters(value={@Parameter(parameterName="height", requestType=@TypeDescriptor(value=Long.class), parameterDes="\u533a\u5757\u9ad8\u5ea6")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBlock(long height) {
        return blockService.getBlock(height);
    }

    @ApiOperation(description="\u6839\u636e\u533a\u5757hash\u67e5\u8be2\u533a\u5757\uff0c\u5305\u542b\u533a\u5757\u6253\u5305\u7684\u6240\u6709\u4ea4\u6613\u4fe1\u606f\uff0c\u6b64\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u91cf\u8f83\u591a\uff0c\u8c28\u614e\u8c03\u7528", order=204)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="\u533a\u5757hash")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBlock(String hash) {
        return blockService.getBlock(hash);
    }

    @ApiOperation(description="\u67e5\u8be2\u6700\u65b0\u533a\u5757\u5934\u4fe1\u606f", order=205)
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public static Result getBestBlockHeader() {
        return blockService.getBestBlockHeader();
    }

    @ApiOperation(description="\u67e5\u8be2\u6700\u65b0\u533a\u5757", order=206)
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=BlockDto.class))
    public static Result getBestBlock() {
        return blockService.getBestBlock();
    }

    @ApiOperation(description="\u6839\u636ehash\u67e5\u8be2\u4ea4\u6613\u8be6\u60c5", order=301)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="\u4ea4\u6613hash")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=TransactionDto.class))
    public static Result getTx(String txHash) {
        return transactionService.getTx(txHash);
    }

    public static Result getTransaction(String txHash) {
        return transactionService.getTransaction(txHash);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u4ea4\u6613", order=302, detailDesc="\u9a8c\u8bc1\u79bb\u7ebf\u7ec4\u88c5\u7684\u4ea4\u6613,\u9a8c\u8bc1\u6210\u529f\u8fd4\u56de\u4ea4\u6613hash\u503c,\u5931\u8d25\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4fe1\u606f")
    @Parameters(value={@Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result validateTx(String txHex) {
        return transactionService.validateTx(txHex);
    }

    @ApiOperation(description="\u5e7f\u64ad\u4ea4\u6613", order=303, detailDesc="\u5e7f\u64ad\u79bb\u7ebf\u7ec4\u88c5\u7684\u4ea4\u6613,\u6210\u529f\u8fd4\u56detrue,\u5931\u8d25\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4fe1\u606f")
    @Parameters(value={@Parameter(parameterName="txHex", parameterDes="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="\u662f\u5426\u6210\u529f"), @Key(name="hash", description="\u4ea4\u6613hash")}))
    public static Result broadcast(String txHex) {
        return transactionService.broadcastTx(txHex);
    }

    @ApiOperation(description="\u5355\u7b14\u8f6c\u8d26", order=304, detailDesc="\u53d1\u8d77\u5355\u8d26\u6237\u5355\u8d44\u4ea7\u7684\u8f6c\u8d26\u4ea4\u6613")
    @Parameters(value={@Parameter(parameterName="transferForm", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=TransferForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result transfer(TransferForm transferForm) {
        return transactionService.transfer(transferForm);
    }

    @ApiOperation(description="\u5355\u7b14\u8de8\u94fe\u8f6c\u8d26", order=305, detailDesc="\u53d1\u8d77\u5355\u8d26\u6237\u5355\u8d44\u4ea7\u7684\u8de8\u94fe\u8f6c\u8d26\u4ea4\u6613")
    @Parameters(value={@Parameter(parameterName="transferForm", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=CrossTransferForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result crossTransfer(CrossTransferForm transferForm) {
        return transactionService.crossTransfer(transferForm);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u6839\u636einputs\u548coutputs\u79bb\u7ebf\u7ec4\u88c5\u8f6c\u8d26\u4ea4\u6613\uff0c\u7528\u4e8e\u5355\u8d26\u6237\u6216\u591a\u8d26\u6237\u7684\u8f6c\u8d26\u4ea4\u6613\u3002\u4ea4\u6613\u624b\u7eed\u8d39\u4e3ainputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u91d1\u989d\u603b\u548c\uff0c\u51cf\u53bboutputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u603b\u548c")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=TransferDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTransferTxOffline(TransferDto transferDto) {
        return transactionService.createTransferTx(transferDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u94fe\u5185\u975eNULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u7ec4\u88c5\u5728NULS\u94fe\u5185\uff0c\u8f6c\u8d26\u975eNULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8f6c\u8d26\u3002\u8be5\u65b9\u6cd5\u4f1a\u4e3b\u52a8\u7528fromAddress\u7ec4\u88c5(NULS\u8d44\u4ea7)\u6253\u5305\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7\u94feid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7id"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTxSimpleTransferOfNonNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount) {
        return transactionService.createTxSimpleTransferOfNonNuls(fromAddress, toAddress, assetChainId, assetId, amount);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u94fe\u5185\u975eNULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u7ec4\u88c5\u5728NULS\u94fe\u5185\uff0c\u8f6c\u8d26\u975eNULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8f6c\u8d26\u3002\u8be5\u65b9\u6cd5\u4f1a\u4e3b\u52a8\u7528fromAddress\u7ec4\u88c5(NULS\u8d44\u4ea7)\u6253\u5305\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7\u94feid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7id"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTxSimpleTransferOfNonNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount, long time, String remark) {
        return transactionService.createTxSimpleTransferOfNonNuls(fromAddress, toAddress, assetChainId, assetId, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u94fe\u5185NULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u7ec4\u88c5\u5728NULS\u94fe\u5185\uff0c\u8f6c\u8d26NULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8f6c\u8d26\u3002\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount) {
        return transactionService.createTxSimpleTransferOfNuls(fromAddress, toAddress, amount);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u94fe\u5185NULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u7ec4\u88c5\u5728NULS\u94fe\u5185\uff0c\u8f6c\u8d26NULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8f6c\u8d26\u3002\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        return transactionService.createTxSimpleTransferOfNuls(fromAddress, toAddress, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94fe\u975eNULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26\u975eNULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8de8\u94fe\u8f6c\u8d26(\u4e0d\u80fd\u7528\u4e8e\u8f6cNULS)\u3002\u8be5\u65b9\u6cd5\u4f1a\u4e3b\u52a8\u7528fromAddress\u7ec4\u88c5(NULS\u8d44\u4ea7)\u6253\u5305\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7\u94feid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7id"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNonNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount, long time, String remark) {
        return transactionService.createCrossTxSimpleTransferOfNonNuls(fromAddress, toAddress, assetChainId, assetId, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94fe\u975eNULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26\u975eNULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8de8\u94fe\u8f6c\u8d26(\u4e0d\u80fd\u7528\u4e8e\u8f6cNULS)\u3002\u8be5\u65b9\u6cd5\u4f1a\u4e3b\u52a8\u7528fromAddress\u7ec4\u88c5(NULS\u8d44\u4ea7)\u6253\u5305\u624b\u7eed\u8d39")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7\u94feid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="\u8f6c\u8d26\u8d44\u4ea7id"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNonNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount) {
        return transactionService.createCrossTxSimpleTransferOfNonNuls(fromAddress, toAddress, assetChainId, assetId, amount);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94feNULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26NULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8de8\u94fe\u8f6c\u8d26\uff08\u53ea\u80fd\u7528\u4e8e\u8f6cNULS\uff09\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", requestType=@TypeDescriptor(value=String.class), parameterDes="\u5907\u6ce8")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        return transactionService.createCrossTxSimpleTransferOfNuls(fromAddress, toAddress, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94feNULS\u8d44\u4ea7\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26NULS\u8d44\u4ea7\u7684\u5355\u8d26\u6237\u5bf9\u5355\u8d26\u6237\u666e\u901a\u8de8\u94fe\u8f6c\u8d26\uff08\u53ea\u80fd\u7528\u4e8e\u8f6cNULS\uff09\u6253\u5305\u624b\u7eed\u8d39\u4e0d\u5305\u542b\u5728amount\u4e2d\uff0c \u672c\u51fd\u6570\u5c06\u4ecefromAddress\u4e2d\u989d\u5916\u83b7\u53d6\u624b\u7eed\u8d39\u8ffd\u52a0\u5230coinfrom\u4e2d\uff0c\u8bf7\u4e0d\u8981\u5c06\u624b\u7eed\u8d39\u4e8b\u5148\u52a0\u5165\u5230amount\u53c2\u6570\u4e2d\uff0c amount\u53c2\u6570\u4f5c\u4e3a\u5b9e\u9645\u5230\u8d26\u7684\u6570\u91cf\u3002")
    @Parameters(value={@Parameter(parameterName="fromAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u51fa\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="toAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="\u8f6c\u5165\u5730\u5740(NULS\u5730\u5740)"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u5230\u8d26\u6570\u91cf")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount) {
        return transactionService.createCrossTxSimpleTransferOfNuls(fromAddress, toAddress, amount);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u8de8\u94fe\u8f6c\u8d26\u4ea4\u6613", order=350, detailDesc="\u6839\u636einputs\u548coutputs\u79bb\u7ebf\u7ec4\u88c5\u8f6c\u8d26\u4ea4\u6613\uff0c\u7528\u4e8e\u5355\u8d26\u6237\u6216\u591a\u8d26\u6237\u7684\u8f6c\u8d26\u4ea4\u6613\u3002\u4ea4\u6613\u624b\u7eed\u8d39\u4e3ainputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u91d1\u989d\u603b\u548c\uff0c\u51cf\u53bboutputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u603b\u548c")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=TransferDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createCrossTransferTxOffline(TransferDto transferDto) {
        return transactionService.createCrossTransferTx(transferDto);
    }

    @ApiOperation(description="\u8ba1\u7b97\u79bb\u7ebf\u521b\u5efa\u8f6c\u8d26\u4ea4\u6613\u6240\u9700\u624b\u7eed\u8d39", order=351)
    @Parameters(value={@Parameter(parameterName="TransferTxFeeDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u624b\u7eed\u8d39", requestType=@TypeDescriptor(value=TransferTxFeeDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u624b\u7eed\u8d39\u91d1\u989d", responseType=@TypeDescriptor(value=BigInteger.class))
    public static BigInteger calcTransferTxFee(TransferTxFeeDto dto) {
        return transactionService.calcTransferTxFee(dto);
    }

    @ApiOperation(description="\u8ba1\u7b97\u79bb\u7ebf\u521b\u5efa\u8de8\u94fe\u8f6c\u8d26\u4ea4\u6613\u6240\u9700\u624b\u7eed\u8d39(\u4e0d\u5efa\u8bae\u4f7f\u7528)", order=351)
    @Parameters(value={@Parameter(parameterName="CrossTransferTxFeeDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u624b\u7eed\u8d39", requestType=@TypeDescriptor(value=CrossTransferTxFeeDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u624b\u7eed\u8d39\u91d1\u989d", responseType=@TypeDescriptor(value=Map.class))
    @Deprecated
    public static Map<String, BigInteger> calcCrossTransferTxFee(CrossTransferTxFeeDto dto) {
        return transactionService.calcCrossTransferTxFee(dto);
    }

    @ApiOperation(description="\u8ba1\u7b97\u79bb\u7ebf\u521b\u5efa\u8de8\u94fe\u8f6c\u8d26\u4ea4\u6613\u6240\u9700NULS\u624b\u7eed\u8d39", order=351)
    @Parameters(value={@Parameter(parameterName="CrossTransferTxFeeDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u624b\u7eed\u8d39", requestType=@TypeDescriptor(value=CrossTransferTxFeeDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u624b\u7eed\u8d39\u91d1\u989d", responseType=@TypeDescriptor(value=Map.class))
    public static BigInteger calcCrossTransferNulsTxFee(CrossTransferTxFeeDto dto) {
        return transactionService.calcCrossTransferNulsTxFee(dto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u591a\u7b7e\u8d26\u6237\u8f6c\u8d26\u4ea4\u6613", order=352, detailDesc="\u6839\u636einputs\u548coutputs\u79bb\u7ebf\u7ec4\u88c5\u8f6c\u8d26\u4ea4\u6613\uff0c\u7528\u4e8e\u5355\u4e2a\u591a\u7b7e\u8d26\u6237\u8f6c\u8d26\u3002\u4ea4\u6613\u624b\u7eed\u8d39\u4e3ainputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u91d1\u989d\u603b\u548c\uff0c\u51cf\u53bboutputs\u91cc\u672c\u94fe\u4e3b\u8d44\u4ea7\u603b\u548c")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=MultiSignTransferDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createMultiSignTransferTxOffline(MultiSignTransferDto transferDto) {
        return transactionService.createMultiSignTransferTx(transferDto);
    }

    @ApiOperation(description="\u8ba1\u7b97\u79bb\u7ebf\u521b\u5efa\u591a\u7b7e\u8d26\u6237\u8f6c\u8d26\u4ea4\u6613\u6240\u9700\u624b\u7eed\u8d39", order=353)
    @Parameters(value={@Parameter(parameterName="MultiSignTransferTxFeeDto", parameterDes="\u8f6c\u8d26\u4ea4\u6613\u624b\u7eed\u8d39", requestType=@TypeDescriptor(value=MultiSignTransferTxFeeDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u624b\u7eed\u8d39\u91d1\u989d", responseType=@TypeDescriptor(value=BigInteger.class))
    public static BigInteger calcMultiSignTransferTxFee(MultiSignTransferTxFeeDto dto) {
        return transactionService.calcMultiSignTransferTxFee(dto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u521b\u5efa\u8bbe\u7f6e\u522b\u540d\u4ea4\u6613", order=354)
    @Parameters(value={@Parameter(parameterName="AliasDto", parameterDes="\u521b\u5efa\u522b\u540d\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=AliasDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createAliasTxOffline(AliasDto dto) {
        return transactionService.createAliasTx(dto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u521b\u5efa\u591a\u7b7e\u8d26\u6237\u8bbe\u7f6e\u522b\u540d\u4ea4\u6613", order=355)
    @Parameters(value={@Parameter(parameterName="MultiSignAliasDto", parameterDes="\u591a\u7b7e\u8d26\u6237\u521b\u5efa\u522b\u540d\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=MultiSignAliasDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createMultiSignAliasTxOffline(MultiSignAliasDto dto) {
        return transactionService.createMultiSignAliasTx(dto);
    }

    @ApiOperation(description="\u53d1\u5e03\u5408\u7ea6", order=401)
    @Parameters(value={@Parameter(parameterName="\u53d1\u5e03\u5408\u7ea6", parameterDes="\u53d1\u5e03\u5408\u7ea6\u8868\u5355", requestType=@TypeDescriptor(value=ContractCreateForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5305\u542b\u4e24\u4e2a\u5c5e\u6027", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="\u53d1\u5e03\u5408\u7ea6\u7684\u4ea4\u6613hash"), @Key(name="contractAddress", description="\u751f\u6210\u7684\u5408\u7ea6\u5730\u5740")}))
    public static Result createContract(ContractCreateForm form) {
        return contractService.createContract(form);
    }

    @ApiOperation(description="\u8c03\u7528\u5408\u7ea6", order=402)
    @Parameters(value={@Parameter(parameterName="\u8c03\u7528\u5408\u7ea6", parameterDes="\u8c03\u7528\u5408\u7ea6\u8868\u5355", requestType=@TypeDescriptor(value=ContractCallForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="\u8c03\u7528\u5408\u7ea6\u7684\u4ea4\u6613hash")}))
    public static Result callContract(ContractCallForm form) {
        return contractService.callContract(form);
    }

    @ApiOperation(description="\u5220\u9664\u5408\u7ea6", order=403)
    @Parameters(value={@Parameter(parameterName="\u5220\u9664\u5408\u7ea6", parameterDes="\u5220\u9664\u5408\u7ea6\u8868\u5355", requestType=@TypeDescriptor(value=ContractDeleteForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="\u5220\u9664\u5408\u7ea6\u7684\u4ea4\u6613hash")}))
    public static Result deleteContract(ContractDeleteForm form) {
        return contractService.deleteContract(form);
    }

    @ApiOperation(description="token\u8f6c\u8d26", order=404)
    @Parameters(value={@Parameter(parameterName="token\u8f6c\u8d26", parameterDes="token\u8f6c\u8d26\u8868\u5355", requestType=@TypeDescriptor(value=ContractTokenTransferForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="\u4ea4\u6613hash")}))
    public static Result tokentransfer(ContractTokenTransferForm form) {
        return contractService.tokentransfer(form);
    }

    @ApiOperation(description="\u4ece\u8d26\u6237\u5730\u5740\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u8d26(\u4e3b\u94fe\u8d44\u4ea7)\u7684\u5408\u7ea6\u4ea4\u6613", order=405)
    @Parameters(value={@Parameter(parameterName="\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u8d26", parameterDes="\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u8d26\u8868\u5355", requestType=@TypeDescriptor(value=ContractTransferForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="\u4ea4\u6613hash")}))
    public static Result transferTocontract(ContractTransferForm form) {
        return contractService.transferTocontract(form);
    }

    @ApiOperation(description="\u83b7\u53d6\u8d26\u6237\u5730\u5740\u7684\u6307\u5b9atoken\u4f59\u989d", order=406)
    @Parameters(value={@Parameter(parameterName="contractAddress", parameterDes="\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="address", parameterDes="\u8d26\u6237\u5730\u5740")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=ContractTokenInfoDto.class))
    public static Result getTokenBalance(String contractAddress, String address) {
        return contractService.getTokenBalance(contractAddress, address);
    }

    @ApiOperation(description="\u83b7\u53d6\u667a\u80fd\u5408\u7ea6\u8be6\u7ec6\u4fe1\u606f", order=407)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="\u5408\u7ea6\u5730\u5740")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=ContractInfoDto.class))
    public static Result getContractInfo(String contractAddress) {
        return contractService.getContractInfo(contractAddress);
    }

    @ApiOperation(description="\u83b7\u53d6\u667a\u80fd\u5408\u7ea6\u6267\u884c\u7ed3\u679c", order=408)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="\u4ea4\u6613hash")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=ContractResultDto.class))
    public static Result getContractResult(String hash) {
        return contractService.getContractResult(hash);
    }

    @ApiOperation(description="\u6839\u636e\u5408\u7ea6\u4ee3\u7801\u83b7\u53d6\u5408\u7ea6\u6784\u9020\u51fd\u6570\u8be6\u60c5", order=409)
    @Parameters(description="\u53c2\u6570", value={@Parameter(parameterName="contractCode", parameterDes="\u667a\u80fd\u5408\u7ea6\u4ee3\u7801(\u5b57\u8282\u7801\u7684Hex\u7f16\u7801\u5b57\u7b26\u4e32)")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u5408\u7ea6\u6784\u9020\u51fd\u6570\u8be6\u60c5", responseType=@TypeDescriptor(value=ContractConstructorInfoDto.class))
    public static Result<ContractConstructorInfoDto> getConstructor(String contractCode) {
        return contractService.getConstructor(contractCode);
    }

    @ApiOperation(description="\u83b7\u53d6\u5df2\u53d1\u5e03\u5408\u7ea6\u6307\u5b9a\u51fd\u6570\u7684\u4fe1\u606f", order=410)
    @Parameters(value={@Parameter(parameterName="\u83b7\u53d6\u5df2\u53d1\u5e03\u5408\u7ea6\u6307\u5b9a\u51fd\u6570\u7684\u4fe1\u606f", parameterDes="\u83b7\u53d6\u5df2\u53d1\u5e03\u5408\u7ea6\u6307\u5b9a\u51fd\u6570\u7684\u4fe1\u606f\u8868\u5355", requestType=@TypeDescriptor(value=ContractMethodForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aMap\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=ProgramMethod.class))
    public static Result getContractMethod(ContractMethodForm form) {
        return contractService.getContractMethod(form);
    }

    @ApiOperation(description="\u83b7\u53d6\u5df2\u53d1\u5e03\u5408\u7ea6\u6307\u5b9a\u51fd\u6570\u7684\u53c2\u6570\u7c7b\u578b\u5217\u8868", order=411)
    @Parameters(value={@Parameter(parameterName="\u83b7\u53d6\u5df2\u53d1\u5e03\u5408\u7ea6\u6307\u5b9a\u51fd\u6570\u7684\u53c2\u6570\u7c7b\u578b\u5217\u8868", parameterDes="\u83b7\u53d6\u5df2\u53d1\u5e03\u5408\u7ea6\u6307\u5b9a\u51fd\u6570\u7684\u53c2\u6570\u7c7b\u578b\u8868\u5355", requestType=@TypeDescriptor(value=ContractMethodForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public static Result getContractMethodArgsTypes(ContractMethodForm form) {
        return contractService.getContractMethodArgsTypes(form);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u53d1\u5e03\u5408\u7ea6", order=412)
    @Parameters(value={@Parameter(parameterName="\u9a8c\u8bc1\u53d1\u5e03\u5408\u7ea6", parameterDes="\u9a8c\u8bc1\u53d1\u5e03\u5408\u7ea6\u8868\u5355", requestType=@TypeDescriptor(value=ContractValidateCreateForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u6d88\u8017\u7684gas\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="success", valueType=boolean.class, description="\u9a8c\u8bc1\u6210\u529f\u4e0e\u5426"), @Key(name="code", description="\u9a8c\u8bc1\u5931\u8d25\u7684\u9519\u8bef\u7801"), @Key(name="msg", description="\u9a8c\u8bc1\u5931\u8d25\u7684\u9519\u8bef\u4fe1\u606f")}))
    public static Result validateContractCreate(ContractValidateCreateForm form) {
        return contractService.validateContractCreate(form);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u8c03\u7528\u5408\u7ea6", order=413)
    @Parameters(value={@Parameter(parameterName="\u9a8c\u8bc1\u8c03\u7528\u5408\u7ea6", parameterDes="\u9a8c\u8bc1\u8c03\u7528\u5408\u7ea6\u8868\u5355", requestType=@TypeDescriptor(value=ContractValidateCallForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u6d88\u8017\u7684gas\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="success", valueType=boolean.class, description="\u9a8c\u8bc1\u6210\u529f\u4e0e\u5426"), @Key(name="code", description="\u9a8c\u8bc1\u5931\u8d25\u7684\u9519\u8bef\u7801"), @Key(name="msg", description="\u9a8c\u8bc1\u5931\u8d25\u7684\u9519\u8bef\u4fe1\u606f")}))
    public static Result validateContractCall(ContractValidateCallForm form) {
        return contractService.validateContractCall(form);
    }

    @ApiOperation(description="\u9a8c\u8bc1\u5220\u9664\u5408\u7ea6", order=414)
    @Parameters(value={@Parameter(parameterName="\u9a8c\u8bc1\u5220\u9664\u5408\u7ea6", parameterDes="\u9a8c\u8bc1\u5220\u9664\u5408\u7ea6\u8868\u5355", requestType=@TypeDescriptor(value=ContractValidateDeleteForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u6d88\u8017\u7684gas\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="success", valueType=boolean.class, description="\u9a8c\u8bc1\u6210\u529f\u4e0e\u5426"), @Key(name="code", description="\u9a8c\u8bc1\u5931\u8d25\u7684\u9519\u8bef\u7801"), @Key(name="msg", description="\u9a8c\u8bc1\u5931\u8d25\u7684\u9519\u8bef\u4fe1\u606f")}))
    public static Result validateContractDelete(ContractValidateDeleteForm form) {
        return contractService.validateContractDelete(form);
    }

    @ApiOperation(description="\u4f30\u7b97\u53d1\u5e03\u5408\u7ea6\u4ea4\u6613\u7684GAS", order=415)
    @Parameters(value={@Parameter(parameterName="\u4f30\u7b97\u53d1\u5e03\u5408\u7ea6\u4ea4\u6613\u7684GAS", parameterDes="\u4f30\u7b97\u53d1\u5e03\u5408\u7ea6\u4ea4\u6613\u7684GAS\u8868\u5355", requestType=@TypeDescriptor(value=ImputedGasContractCreateForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u6d88\u8017\u7684gas\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="gasLimit", valueType=Long.class, description="\u6d88\u8017\u7684gas\u503c\uff0c\u6267\u884c\u5931\u8d25\u8fd4\u56de\u6570\u503c1")}))
    public static Result imputedContractCreateGas(ImputedGasContractCreateForm form) {
        return contractService.imputedContractCreateGas(form);
    }

    @ApiOperation(description="\u4f30\u7b97\u8c03\u7528\u5408\u7ea6\u4ea4\u6613\u7684GAS", order=416)
    @Parameters(value={@Parameter(parameterName="\u4f30\u7b97\u8c03\u7528\u5408\u7ea6\u4ea4\u6613\u7684GAS", parameterDes="\u4f30\u7b97\u8c03\u7528\u5408\u7ea6\u4ea4\u6613\u7684GAS\u8868\u5355", requestType=@TypeDescriptor(value=ImputedGasContractCallForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u6d88\u8017\u7684gas\u503c", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="gasLimit", valueType=Long.class, description="\u6d88\u8017\u7684gas\u503c\uff0c\u6267\u884c\u5931\u8d25\u8fd4\u56de\u6570\u503c1")}))
    public static Result imputedContractCallGas(ImputedGasContractCallForm form) {
        return contractService.imputedContractCallGas(form);
    }

    @ApiOperation(description="\u8c03\u7528\u5408\u7ea6\u4e0d\u4e0a\u94fe\u65b9\u6cd5", order=417)
    @Parameters(value={@Parameter(parameterName="\u8c03\u7528\u5408\u7ea6\u4e0d\u4e0a\u94fe\u65b9\u6cd5", parameterDes="\u8c03\u7528\u5408\u7ea6\u4e0d\u4e0a\u94fe\u65b9\u6cd5\u8868\u5355", requestType=@TypeDescriptor(value=ContractViewCallForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56deMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="\u89c6\u56fe\u65b9\u6cd5\u7684\u8c03\u7528\u7ed3\u679c")}))
    public static Result invokeView(ContractViewCallForm form) {
        return contractService.invokeView(form);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5 - \u53d1\u5e03\u5408\u7ea6\u7684\u4ea4\u6613", order=451)
    @Parameters(value={@Parameter(parameterName="sender", parameterDes="\u4ea4\u6613\u521b\u5efa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8d26\u6237nonce\u503c"), @Parameter(parameterName="alias", parameterDes="\u5408\u7ea6\u522b\u540d"), @Parameter(parameterName="contractCode", parameterDes="\u667a\u80fd\u5408\u7ea6\u4ee3\u7801(\u5b57\u8282\u7801\u7684Hex\u7f16\u7801\u5b57\u7b26\u4e32)"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="\u53c2\u6570\u5217\u8868", canNull=true), @Parameter(parameterName="argsType", requestType=@TypeDescriptor(value=String[].class), parameterDes="\u53c2\u6570\u7c7b\u578b\u5217\u8868", canNull=true), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32"), @Key(name="contractAddress", description="\u751f\u6210\u7684\u5408\u7ea6\u5730\u5740")}))
    public static Result<Map> createContractTxOffline(String sender, BigInteger senderBalance, String nonce, String alias, String contractCode, long gasLimit, Object[] args, String[] argsType, String remark) {
        return contractService.createContractTxOffline(sender, senderBalance, nonce, alias, contractCode, gasLimit, args, argsType, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5 - \u8c03\u7528\u5408\u7ea6\u7684\u4ea4\u6613", order=452)
    @Parameters(value={@Parameter(parameterName="sender", parameterDes="\u4ea4\u6613\u521b\u5efa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8d26\u6237nonce\u503c"), @Parameter(parameterName="value", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8c03\u7528\u8005\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u5165\u7684\u4e3b\u7f51\u8d44\u4ea7\u91d1\u989d\uff0c\u6ca1\u6709\u6b64\u4e1a\u52a1\u65f6\u586bBigInteger.ZERO"), @Parameter(parameterName="multyAssetValues", requestType=@TypeDescriptor(value=String[][].class), parameterDes="\u8c03\u7528\u8005\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u5165\u7684\u5176\u4ed6\u8d44\u4ea7\u91d1\u989d\uff0c\u6ca1\u6709\u6b64\u4e1a\u52a1\u65f6\u586b\u7a7a\uff0c\u89c4\u5219: [[<value>,<assetChainId>,<assetId>]]"), @Parameter(parameterName="contractAddress", parameterDes="\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="methodName", parameterDes="\u5408\u7ea6\u65b9\u6cd5"), @Parameter(parameterName="methodDesc", parameterDes="\u5408\u7ea6\u65b9\u6cd5\u63cf\u8ff0\uff0c\u82e5\u5408\u7ea6\u5185\u65b9\u6cd5\u6ca1\u6709\u91cd\u8f7d\uff0c\u5219\u6b64\u53c2\u6570\u53ef\u4ee5\u4e3a\u7a7a", canNull=true), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="\u53c2\u6570\u5217\u8868", canNull=true), @Parameter(parameterName="argsType", requestType=@TypeDescriptor(value=String[].class), parameterDes="\u53c2\u6570\u7c7b\u578b\u5217\u8868", canNull=true), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true), @Parameter(parameterName="multyAssetValues", requestType=@TypeDescriptor(value=String[][].class), parameterDes="\u8c03\u7528\u8005\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u5165\u7684\u5176\u4ed6\u8d44\u4ea7\u91d1\u989d\uff0c\u6ca1\u6709\u6b64\u4e1a\u52a1\u65f6\u586b\u7a7a\uff0c\u89c4\u5219: [[<value>,<assetChainId>,<assetId>]]"), @Parameter(parameterName="nulsValueToOthers", requestType=@TypeDescriptor(value=String[][].class), parameterDes="\u8c03\u7528\u8005\u5411\u5176\u4ed6\u8d26\u6237\u5730\u5740\u8f6c\u5165\u7684NULS\u8d44\u4ea7\u91d1\u989d\uff0c\u6ca1\u6709\u6b64\u4e1a\u52a1\u65f6\u586b\u7a7a\uff0c\u89c4\u5219: [[<value>,<address>]]")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public static Result<Map> callContractTxOffline(String sender, BigInteger senderBalance, String nonce, BigInteger value, String contractAddress, long gasLimit, String methodName, String methodDesc, Object[] args, String[] argsType, String remark, List<ProgramMultyAssetValue> multyAssetValues, List<AccountAmountDto> nulsValueToOthers) {
        return contractService.callContractTxOffline(sender, senderBalance, nonce, value, contractAddress, gasLimit, methodName, methodDesc, args, argsType, System.currentTimeMillis() / 1000L, remark, multyAssetValues, nulsValueToOthers);
    }

    public static Result<Map> callContractTxOffline(String sender, BigInteger senderBalance, String nonce, BigInteger value, String contractAddress, long gasLimit, String methodName, String methodDesc, Object[] args, String[] argsType, String remark, List<ProgramMultyAssetValue> multyAssetValues) {
        return contractService.callContractTxOffline(sender, senderBalance, nonce, value, contractAddress, gasLimit, methodName, methodDesc, args, argsType, System.currentTimeMillis() / 1000L, remark, multyAssetValues, null);
    }

    public static Result<Map> callContractTxOffline(String sender, BigInteger senderBalance, String nonce, BigInteger value, String contractAddress, long gasLimit, String methodName, String methodDesc, Object[] args, String[] argsType, String remark) {
        return contractService.callContractTxOffline(sender, senderBalance, nonce, value, contractAddress, gasLimit, methodName, methodDesc, args, argsType, System.currentTimeMillis() / 1000L, remark, null, null);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5 - \u5220\u9664\u5408\u7ea6\u7684\u4ea4\u6613", order=453)
    @Parameters(value={@Parameter(parameterName="sender", parameterDes="\u4ea4\u6613\u521b\u5efa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8d26\u6237nonce\u503c"), @Parameter(parameterName="contractAddress", parameterDes="\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public static Result<Map> deleteContractTxOffline(String sender, BigInteger senderBalance, String nonce, String contractAddress, String remark) {
        return contractService.deleteContractTxOffline(sender, senderBalance, nonce, contractAddress, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5 - token\u8f6c\u8d26\u4ea4\u6613", order=454)
    @Parameters(value={@Parameter(parameterName="fromAddress", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237nonce\u503c"), @Parameter(parameterName="toAddress", parameterDes="\u8f6c\u5165\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="contractAddress", parameterDes="token\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u7684token\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public static Result<Map> tokenTransferTxOffline(String fromAddress, BigInteger senderBalance, String nonce, String toAddress, String contractAddress, long gasLimit, BigInteger amount, String remark) {
        return contractService.tokenTransferTxOffline(fromAddress, senderBalance, nonce, toAddress, contractAddress, gasLimit, amount, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5 - token\u8f6c\u8d26\u4ea4\u6613", order=454)
    @Parameters(value={@Parameter(parameterName="fromAddress", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237nonce\u503c"), @Parameter(parameterName="toAddress", parameterDes="\u8f6c\u5165\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="contractAddress", parameterDes="token\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u7684token\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public static Result<Map> tokenTransferTxOffline(String fromAddress, BigInteger senderBalance, String nonce, String toAddress, String contractAddress, long gasLimit, BigInteger amount, long time, String remark) {
        return contractService.tokenTransferTxOffline(fromAddress, senderBalance, nonce, toAddress, contractAddress, gasLimit, amount, time, remark);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5 - \u4ece\u8d26\u6237\u5730\u5740\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u8d26(\u4e3b\u94fe\u8d44\u4ea7)\u7684\u5408\u7ea6\u4ea4\u6613", order=455)
    @Parameters(value={@Parameter(parameterName="fromAddress", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237nonce\u503c"), @Parameter(parameterName="toAddress", parameterDes="\u8f6c\u5165\u7684\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u7684\u4e3b\u94fe\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public static Result<Map> transferToContractTxOffline(String fromAddress, BigInteger senderBalance, String nonce, String toAddress, long gasLimit, BigInteger amount, String remark) {
        return contractService.transferToContractTxOffline(fromAddress, senderBalance, nonce, toAddress, gasLimit, amount, remark);
    }

    @ApiOperation(description=" \u521b\u5efa\u5171\u8bc6\u8282\u70b9", order=501)
    @Parameters(value={@Parameter(parameterName="\u521b\u5efa\u5171\u8bc6(\u4ee3\u7406)\u8282\u70b9", parameterDes="\u521b\u5efa\u5171\u8bc6(\u4ee3\u7406)\u8282\u70b9\u8868\u5355", requestType=@TypeDescriptor(value=CreateAgentForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result createAgent(CreateAgentForm form) {
        return consensusService.createAgent(form);
    }

    @ApiOperation(description="\u6ce8\u9500\u5171\u8bc6\u8282\u70b9", order=502)
    @Parameters(value={@Parameter(parameterName="\u6ce8\u9500\u5171\u8bc6\u8282\u70b9", parameterDes="\u6ce8\u9500\u5171\u8bc6\u8282\u70b9\u8868\u5355", requestType=@TypeDescriptor(value=StopAgentForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result stopAgent(StopAgentForm form) {
        return consensusService.stopAgent(form);
    }

    @ApiOperation(description="deposit nuls to a bank! \u7533\u8bf7\u53c2\u4e0e\u5171\u8bc6", order=503)
    @Parameters(value={@Parameter(parameterName="\u59d4\u6258\u53c2\u4e0e\u5171\u8bc6", parameterDes="\u59d4\u6258\u53c2\u4e0e\u5171\u8bc6\u8868\u5355", requestType=@TypeDescriptor(value=DepositForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result depositToAgent(DepositForm form) {
        return consensusService.depositToAgent(form);
    }

    @ApiOperation(description="\u9000\u51fa\u5171\u8bc6", order=504)
    @Parameters(value={@Parameter(parameterName="\u9000\u51fa\u5171\u8bc6", parameterDes="\u9000\u51fa\u5171\u8bc6\u8868\u5355", requestType=@TypeDescriptor(value=WithdrawForm.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="\u4ea4\u6613hash")}))
    public static Result withdraw(WithdrawForm form) {
        return consensusService.withdraw(form);
    }

    @ApiOperation(description="\u67e5\u8be2\u8282\u70b9\u7684\u59d4\u6258\u5171\u8bc6\u5217\u8868", order=505)
    @Parameters(value={@Parameter(parameterName="agentHash", parameterDes="\u521b\u5efa\u5171\u8bc6\u8282\u70b9\u7684\u4ea4\u6613hash")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u6ce8\u610f: \u8fd4\u56de\u503c\u662f\u4e00\u4e2aList<Map>\u96c6\u5408\u5bf9\u8c61\uff0c\u5185\u90e8key-value\u7ed3\u6784\u662f[responseType]\u63cf\u8ff0\u5bf9\u8c61\u7684\u7ed3\u6784", responseType=@TypeDescriptor(value=List.class, collectionElement=DepositInfoDto.class))
    public static Result getDepositList(String agentHash) {
        return consensusService.getDepositList(agentHash);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u521b\u5efa\u5171\u8bc6\u8282\u70b9\u4ea4\u6613", order=551, detailDesc="\u53c2\u4e0e\u5171\u8bc6\u6240\u9700\u8d44\u4ea7\u53ef\u901a\u8fc7\u67e5\u8be2\u94fe\u4fe1\u606f\u63a5\u53e3\u83b7\u53d6(agentChainId\u548cagentAssetId)")
    @Parameters(value={@Parameter(parameterName="consensusDto", parameterDes="\u521b\u5efa\u8282\u70b9\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=ConsensusDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createConsensusTxOffline(ConsensusDto consensusDto) {
        return transactionService.createConsensusTx(consensusDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u59d4\u6258\u5171\u8bc6\u4ea4\u6613", order=552, detailDesc="\u53c2\u4e0e\u5171\u8bc6\u6240\u9700\u8d44\u4ea7\u53ef\u901a\u8fc7\u67e5\u8be2\u94fe\u4fe1\u606f\u63a5\u53e3\u83b7\u53d6(agentChainId\u548cagentAssetId)")
    @Parameters(value={@Parameter(parameterName="depositDto", parameterDes="\u59d4\u6258\u5171\u8bc6\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=DepositDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createDepositTxOffline(DepositDto depositDto) {
        return transactionService.createDepositTx(depositDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u9000\u51fa\u59d4\u6258\u5171\u8bc6\u4ea4\u6613", order=553, detailDesc="\u63a5\u53e3\u7684input\u6570\u636e\uff0c\u5219\u662f\u59d4\u6258\u5171\u8bc6\u4ea4\u6613\u7684output\u6570\u636e\uff0cnonce\u503c\u53ef\u4e3a\u7a7a")
    @Parameters(value={@Parameter(parameterName="withDrawDto", parameterDes="\u9000\u51fa\u59d4\u6258\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=WithDrawDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createWithdrawDepositTxOffline(WithDrawDto withDrawDto) {
        return transactionService.createWithdrawDepositTx(withDrawDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u6ce8\u9500\u5171\u8bc6\u8282\u70b9\u4ea4\u6613", order=554, detailDesc="\u7ec4\u88c5\u4ea4\u6613\u7684StopDepositDto\u4fe1\u606f\uff0c\u53ef\u901a\u8fc7\u67e5\u8be2\u8282\u70b9\u7684\u59d4\u6258\u5171\u8bc6\u5217\u8868\u83b7\u53d6\uff0cinput\u7684nonce\u503c\u53ef\u4e3a\u7a7a")
    @Parameters(value={@Parameter(parameterName="stopConsensusDto", parameterDes="\u6ce8\u9500\u5171\u8bc6\u8282\u70b9\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=StopConsensusDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createStopConsensusTxOffline(StopConsensusDto stopConsensusDto) {
        return transactionService.createStopConsensusTx(stopConsensusDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u591a\u7b7e\u8d26\u6237\u521b\u5efa\u5171\u8bc6\u8282\u70b9\u4ea4\u6613", order=555, detailDesc="\u53c2\u4e0e\u5171\u8bc6\u6240\u9700\u8d44\u4ea7\u53ef\u901a\u8fc7\u67e5\u8be2\u94fe\u4fe1\u606f\u63a5\u53e3\u83b7\u53d6(agentChainId\u548cagentAssetId)")
    @Parameters(value={@Parameter(parameterName="consensusDto", parameterDes="\u591a\u7b7e\u8d26\u6237\u521b\u5efa\u8282\u70b9\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=MultiSignConsensusDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createMultiSignConsensusTx(MultiSignConsensusDto consensusDto) {
        return transactionService.createMultiSignConsensusTx(consensusDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u591a\u7b7e\u8d26\u6237\u59d4\u6258\u5171\u8bc6\u4ea4\u6613", order=556, detailDesc="\u53c2\u4e0e\u5171\u8bc6\u6240\u9700\u8d44\u4ea7\u53ef\u901a\u8fc7\u67e5\u8be2\u94fe\u4fe1\u606f\u63a5\u53e3\u83b7\u53d6(agentChainId\u548cagentAssetId)")
    @Parameters(value={@Parameter(parameterName="depositDto", parameterDes="\u591a\u7b7e\u8d26\u6237\u59d4\u6258\u5171\u8bc6\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=MultiSignDepositDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createMultiSignDepositTxOffline(MultiSignDepositDto depositDto) {
        return transactionService.createMultiSignDepositTx(depositDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u591a\u7b7e\u8d26\u6237\u9000\u51fa\u59d4\u6258\u5171\u8bc6\u4ea4\u6613", order=557, detailDesc="\u63a5\u53e3\u7684input\u6570\u636e\uff0c\u5219\u662f\u59d4\u6258\u5171\u8bc6\u4ea4\u6613\u7684output\u6570\u636e\uff0cnonce\u503c\u53ef\u4e3a\u7a7a")
    @Parameters(value={@Parameter(parameterName="withDrawDto", parameterDes="\u591a\u7b7e\u8d26\u6237\u9000\u51fa\u59d4\u6258\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=MultiSignWithDrawDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createMultiSignWithdrawDepositTxOffline(MultiSignWithDrawDto withDrawDto) {
        return transactionService.createMultiSignWithdrawDepositTx(withDrawDto);
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5\u591a\u7b7e\u8d26\u6237\u6ce8\u9500\u5171\u8bc6\u8282\u70b9\u4ea4\u6613", order=558, detailDesc="\u7ec4\u88c5\u4ea4\u6613\u7684StopDepositDto\u4fe1\u606f\uff0c\u53ef\u901a\u8fc7\u67e5\u8be2\u8282\u70b9\u7684\u59d4\u6258\u5171\u8bc6\u5217\u8868\u83b7\u53d6\uff0cinput\u7684nonce\u503c\u53ef\u4e3a\u7a7a")
    @Parameters(value={@Parameter(parameterName="stopConsensusDto", parameterDes="\u591a\u7b7e\u8d26\u6237\u6ce8\u9500\u5171\u8bc6\u8282\u70b9\u4ea4\u6613\u8868\u5355", requestType=@TypeDescriptor(value=StopConsensusDto.class))})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u531616\u8fdb\u5236\u5b57\u7b26\u4e32")}))
    public static Result createMultiSignStopConsensusTx(MultiSignStopConsensusDto stopConsensusDto) {
        return transactionService.createMultiSignStopConsensusTx(stopConsensusDto);
    }

    public static Result deserializeTxHex(String txHex) {
        Transaction tx = new Transaction();
        try {
            tx.parse(new NulsByteBuffer(HexUtil.decode((String)txHex)));
            return Result.getSuccess((Object)tx);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    @ApiOperation(description="\u79bb\u7ebf\u7ec4\u88c5 - token\u8f6c\u8d26\u4ea4\u6613", order=559)
    @Parameters(value={@Parameter(parameterName="fromAddress", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237nonce\u503c"), @Parameter(parameterName="toAddress", parameterDes="\u8f6c\u5165\u8005\u8d26\u6237\u5730\u5740(NERVE)"), @Parameter(parameterName="contractAddress", parameterDes="token\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u7684token\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8f6c\u51fa\u7684token\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public static Result<Map> nrc20CrossChainTxOffline(String fromAddress, BigInteger senderBalance, String nonce, String toAddress, String contractAddress, long gasLimit, BigInteger amount, long time, String remark) {
        return contractService.nrc20CrossChainTxOffline(fromAddress, senderBalance, nonce, toAddress, contractAddress, gasLimit, amount, time, remark);
    }

    public static BigDecimal getBalance(int assetChainId, int assetId) {
        Result rs = NulsSDKTool.getSymbolInfo(assetChainId, assetId);
        Map map = (Map)rs.getData();
        String usdPrice = map.get("usdPrice").toString();
        return new BigDecimal(usdPrice);
    }

    public static Result getSymbolInfo(int assetChainId, int assetId) {
        if (assetChainId == 0 || assetId == 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.NULL_PARAMETER).setMsg("assetChainId or assetId is empty");
        }
        RpcResult rpcResult = JsonRpcUtil.request("https://scan.nerve.network/api/", "getSymbolInfo", ListUtil.of(assetChainId, assetId));
        RpcResultError rpcResultError = rpcResult.getError();
        if (rpcResultError != null) {
            return Result.getFailed((ErrorCode)ErrorCode.init((String)rpcResultError.getCode())).setMsg(rpcResultError.getMessage());
        }
        return ContractUtil.getSuccess().setData(rpcResult.getResult());
    }

    static {
        I18nUtils.loadLanguage(NulsSDKTool.class, (String)LANGUAGE_PATH, (String)LANGUAGE);
    }
}

