/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider;

import io.nuls.base.api.provider.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.model.StringUtils;
import java.util.List;

public abstract class BaseService {
    private int chainId;

    protected <T> Result<T> success(T data) {
        return new Result<T>(data);
    }

    protected <T> Result<T> success(List<T> list) {
        return new Result<T>(list);
    }

    public static Result fail(ErrorCode errorCode, String message) {
        return new Result(errorCode.getCode(), (String)(StringUtils.isNotBlank((String)message) ? message : (StringUtils.isBlank((String)errorCode.getMsg()) ? "fail,error code:" + errorCode.getCode() : errorCode.getMsg())));
    }

    public static Result fail(String errorCode) {
        return BaseService.fail(ErrorCode.init((String)errorCode));
    }

    public static Result fail(ErrorCode errorCode) {
        return BaseService.fail(errorCode, errorCode.getMsg());
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }
}

