/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider;

import io.nuls.base.api.provider.BaseService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.ServiceProxy;
import io.nuls.core.core.ioc.ScanUtil;
import io.nuls.core.log.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public class ServiceManager {
    public static boolean inited = false;
    public static Map<Class, Object> serviceImpls = new HashMap<Class, Object>();

    public static <T> T get(Class<T> serviceClass) {
        if (!inited) {
            throw new RuntimeException("ServiceManager not ready, must call init before ");
        }
        return (T)serviceImpls.get(serviceClass);
    }

    public static void init(Integer defaultChainId, Provider.ProviderType providerType) {
        List imps = ScanUtil.scan((String)"io.nuls.base.api.provider");
        imps.forEach(cls -> {
            Provider.ProviderType clsProviderType;
            Provider annotation = cls.getAnnotation(Provider.class);
            if (annotation != null && providerType == (clsProviderType = annotation.value())) {
                Arrays.stream(cls.getInterfaces()).forEach(intf -> {
                    try {
                        if (cls.getSuperclass() == null && !cls.getSuperclass().equals(BaseService.class)) {
                            throw new RuntimeException("api provider init fail, Service must be extends BaseService");
                        }
                        ServiceProxy serviceProxy = new ServiceProxy(defaultChainId);
                        Enhancer enhancer = new Enhancer();
                        enhancer.setSuperclass(cls);
                        enhancer.setCallback((Callback)serviceProxy);
                        BaseService service = (BaseService)enhancer.create();
                        serviceImpls.put((Class)intf, service);
                        service.setChainId(defaultChainId);
                    }
                    catch (Exception e) {
                        Log.error((String)"api provider init fail, service : {}", (Object[])new Object[]{cls, e});
                        System.exit(0);
                    }
                });
            }
        });
        inited = true;
    }
}

