/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.consensus;

import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.consensus.ConsensusProvider;
import io.nuls.base.api.provider.consensus.facade.AgentInfo;
import io.nuls.base.api.provider.consensus.facade.CreateAgentReq;
import io.nuls.base.api.provider.consensus.facade.CreateMultiSignAgentReq;
import io.nuls.base.api.provider.consensus.facade.DepositInfo;
import io.nuls.base.api.provider.consensus.facade.DepositToAgentReq;
import io.nuls.base.api.provider.consensus.facade.GetAgentInfoReq;
import io.nuls.base.api.provider.consensus.facade.GetAgentListReq;
import io.nuls.base.api.provider.consensus.facade.GetDepositListReq;
import io.nuls.base.api.provider.consensus.facade.GetStopAgentCoinDataReq;
import io.nuls.base.api.provider.consensus.facade.MultiSignAccountDepositToAgentReq;
import io.nuls.base.api.provider.consensus.facade.MultiSignAccountWithdrawReq;
import io.nuls.base.api.provider.consensus.facade.StopAgentReq;
import io.nuls.base.api.provider.consensus.facade.StopMultiSignAgentReq;
import io.nuls.base.api.provider.consensus.facade.WithdrawReq;
import io.nuls.base.api.provider.transaction.facade.MultiSignTransferRes;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.log.Log;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.ModuleE;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Provider(value=Provider.ProviderType.RPC)
public class ConsensusProviderForRpc
extends BaseRpcService
implements ConsensusProvider {
    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> callback) {
        return this.callRpc(ModuleE.CS.abbr, method, req, callback);
    }

    @Override
    public Result<String> createAgent(CreateAgentReq req) {
        return this.callReturnString("cs_createAgent", req, "txHash");
    }

    @Override
    public Result<MultiSignTransferRes> createAgentForMultiSignAccount(CreateMultiSignAgentReq req) {
        return this.callRpc(ModuleE.CS.abbr, "cs_createMultiAgent", req, data -> this.success((MultiSignTransferRes)MapUtils.mapToBean((Map)data, (Object)new MultiSignTransferRes())));
    }

    @Override
    public Result<String> stopAgent(StopAgentReq req) {
        return this.callReturnString("cs_stopAgent", req, "txHash");
    }

    @Override
    public Result<String> getStopAgentCoinData(GetStopAgentCoinDataReq req) {
        return this.callReturnString("cs_getStopAgentCoinData", req, "value");
    }

    @Override
    public Result<MultiSignTransferRes> stopAgentForMultiSignAccount(StopMultiSignAgentReq req) {
        return this.callRpc(ModuleE.CS.abbr, "cs_stopMultiAgent", req, data -> this.success((MultiSignTransferRes)MapUtils.mapToBean((Map)data, (Object)new MultiSignTransferRes())));
    }

    @Override
    public Result<String> depositToAgent(DepositToAgentReq req) {
        return this.callReturnString("cs_depositToAgent", req, "txHash");
    }

    @Override
    public Result<MultiSignTransferRes> depositToAgentForMultiSignAccount(MultiSignAccountDepositToAgentReq req) {
        return this.callRpc(ModuleE.CS.abbr, "cs_multiDeposit", req, data -> this.success((MultiSignTransferRes)MapUtils.mapToBean((Map)data, (Object)new MultiSignTransferRes())));
    }

    @Override
    public Result<String> withdraw(WithdrawReq req) {
        return this.callReturnString("cs_withdraw", req, "txHash");
    }

    @Override
    public Result<MultiSignTransferRes> withdrawForMultiSignAccount(MultiSignAccountWithdrawReq req) {
        return this.callRpc(ModuleE.CS.abbr, "cs_multiWithdraw", req, data -> this.success((MultiSignTransferRes)MapUtils.mapToBean((Map)data, (Object)new MultiSignTransferRes())));
    }

    @Override
    public Result<AgentInfo> getAgentInfo(GetAgentInfoReq req) {
        return this.call("cs_getAgentInfo", req, res -> {
            if (res == null) {
                return ConsensusProviderForRpc.fail(RPC_ERROR_CODE, "agent not found");
            }
            AgentInfo agentInfo = (AgentInfo)MapUtils.mapToBean((Map)res, (Object)new AgentInfo());
            return this.success(agentInfo);
        });
    }

    @Override
    public Result<AgentInfo> getAgentList(GetAgentListReq req) {
        return this.call("cs_getAgentList", req, res -> {
            try {
                List list = MapUtils.mapsToObjects((List)((List)res.get("list")), AgentInfo.class);
                return this.success(list);
            }
            catch (Exception e) {
                Log.error((String)"cs_getAgentList fail", (Throwable)e);
                return ConsensusProviderForRpc.fail(CommonCodeConstanst.FAILED);
            }
        });
    }

    @Override
    public Result<DepositInfo> getDepositList(GetDepositListReq req) {
        return this.call("cs_getDepositList", req, res -> {
            try {
                List list = MapUtils.mapsToObjects((List)((List)res.get("list")), DepositInfo.class);
                return this.success(list);
            }
            catch (Exception e) {
                Log.error((String)"cs_getDepositList fail", (Throwable)e);
                return ConsensusProviderForRpc.fail(CommonCodeConstanst.FAILED);
            }
        });
    }
}

