/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.crosschain;

import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.ChainManageProvider;
import io.nuls.base.api.provider.crosschain.facade.AddCrossAssetReq;
import io.nuls.base.api.provider.crosschain.facade.AddCrossLocalAssetReq;
import io.nuls.base.api.provider.crosschain.facade.CrossAssetRegisterInfo;
import io.nuls.base.api.provider.crosschain.facade.CrossChainRegisterInfo;
import io.nuls.base.api.provider.crosschain.facade.DisableAssetReq;
import io.nuls.base.api.provider.crosschain.facade.GetCrossAssetInfoReq;
import io.nuls.base.api.provider.crosschain.facade.GetCrossChainInfoReq;
import io.nuls.base.api.provider.crosschain.facade.RegisterChainReq;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.ModuleE;
import java.util.Map;
import java.util.function.Function;

@Provider(value=Provider.ProviderType.RPC)
public class ChainManageProviderForRpc
extends BaseRpcService
implements ChainManageProvider {
    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> callback) {
        return this.callRpc(ModuleE.CM.abbr, method, req, callback);
    }

    @Override
    public Result<CrossChainRegisterInfo> getCrossChainInfo(GetCrossChainInfoReq req) {
        return this._call("cm_chain", req, res -> {
            if (res == null) {
                return ChainManageProviderForRpc.fail(RPC_ERROR_CODE, "chain not found");
            }
            CrossChainRegisterInfo crossChainRegisterInfo = (CrossChainRegisterInfo)MapUtils.mapToBean((Map)res, (Object)new CrossChainRegisterInfo());
            return this.success(crossChainRegisterInfo);
        });
    }

    @Override
    public Result<Map> getCrossChainsSimpleInfo() {
        return this.callResutlMap("cm_getChainsSimpleInfo", null);
    }

    @Override
    public Result<CrossAssetRegisterInfo> getCrossAssetInfo(GetCrossAssetInfoReq req) {
        return this._call("cm_asset", req, res -> {
            if (res == null) {
                return ChainManageProviderForRpc.fail(RPC_ERROR_CODE, "asset not found");
            }
            CrossAssetRegisterInfo crossAssetRegisterInfo = (CrossAssetRegisterInfo)MapUtils.mapToBean((Map)res, (Object)new CrossAssetRegisterInfo());
            return this.success(crossAssetRegisterInfo);
        });
    }

    @Override
    public Result<Map> registerChain(RegisterChainReq req) {
        return this.callResutlMap("cm_chainReg", req);
    }

    @Override
    public Result<Map> updateChain(RegisterChainReq req) {
        return this.callResutlMap("cm_chainActive", req);
    }

    @Override
    public Result<String> disableCrossAsset(DisableAssetReq req) {
        return this.callReturnString("cm_assetDisable", req, "txHash");
    }

    @Override
    public Result<String> addCrossAsset(AddCrossAssetReq req) {
        return this.callReturnString("cm_assetReg", req, "txHash");
    }

    @Override
    public Result<String> addCrossLocalAsset(AddCrossLocalAssetReq req) {
        return this.callReturnString("cm_mainNetAssetReg", req, "txHash");
    }

    private <T> Result<T> _call(String method, Object req, Function<Map, Result> callback) {
        return this.call(method, req, callback);
    }
}

