/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.crosschain.facade;

import io.nuls.base.api.provider.BaseReq;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CreateCrossTxReq
extends BaseReq {
    private String remark;
    private List<Item> listFrom = new ArrayList<Item>();
    private List<Item> listTo = new ArrayList<Item>();

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    private CreateCrossTxReq(Integer chainId) {
        this.setChainId(chainId);
    }

    public List<Item> getListFrom() {
        return this.listFrom;
    }

    public void setListFrom(List<Item> listFrom) {
        this.listFrom = listFrom;
    }

    public List<Item> getListTo() {
        return this.listTo;
    }

    public void setListTo(List<Item> listTo) {
        this.listTo = listTo;
    }

    public static class CreateCrossTxReqBuilder {
        private List<Item> listForm;
        private List<Item> listTo;
        private String remark;
        private Integer chainId;

        public CreateCrossTxReqBuilder(Integer chainId) {
            this.chainId = chainId;
            this.listForm = new ArrayList<Item>();
            this.listTo = new ArrayList<Item>();
        }

        public CreateCrossTxReq build() {
            CreateCrossTxReq req = new CreateCrossTxReq(this.chainId);
            req.setRemark(this.remark);
            if (this.listForm.isEmpty()) {
                throw new IllegalArgumentException("form info can't be empty");
            }
            this.checkItem(this.listForm);
            req.setListFrom(this.listForm);
            if (this.listTo.isEmpty()) {
                throw new IllegalArgumentException("to info can't be empty");
            }
            this.checkItem(this.listTo);
            req.setListTo(this.listTo);
            return req;
        }

        private void checkItem(List<Item> list) {
            for (Item item : list) {
                if (item.getAssetsChainId() == null) {
                    throw new IllegalArgumentException("assetsChainId can not be null");
                }
                if (item.getAssetsId() != null) continue;
                throw new IllegalArgumentException("assetsId can not be null");
            }
        }

        public CreateCrossTxReqBuilder setRemark(String remark) {
            this.remark = remark;
            return this;
        }

        public CreateCrossTxReqBuilder addForm(Integer assetChainId, Integer assetId, String address, String password, BigInteger amount) {
            this.listForm.add(new Item(address, assetChainId, assetId, amount, password));
            return this;
        }

        public CreateCrossTxReqBuilder addTo(Integer assetChainId, Integer assetId, String address, BigInteger amount) {
            this.listTo.add(new Item(address, assetChainId, assetId, amount));
            return this;
        }
    }

    public static class Item {
        private String address;
        private Integer assetsChainId;
        private Integer assetsId;
        private BigInteger amount;
        private String password;

        public Item(String address, Integer assetsChainId, Integer assetsId, BigInteger amount, String password) {
            this.address = address;
            this.amount = amount;
            this.assetsChainId = assetsChainId;
            this.assetsId = assetsId;
            this.password = password;
        }

        public Item(String address, Integer assetsChainId, Integer assetsId, BigInteger amount) {
            this.address = address;
            this.amount = amount;
            this.assetsChainId = assetsChainId;
            this.assetsId = assetsId;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Integer getAssetsChainId() {
            return this.assetsChainId;
        }

        public void setAssetsChainId(Integer assetsChainId) {
            this.assetsChainId = assetsChainId;
        }

        public Integer getAssetsId() {
            return this.assetsId;
        }

        public void setAssetsId(Integer assetsId) {
            this.assetsId = assetsId;
        }

        public BigInteger getAmount() {
            return this.amount;
        }

        public void setAmount(BigInteger amount) {
            this.amount = amount;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

