/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.protocol;

import io.nuls.base.protocol.ModuleHelper;
import io.nuls.base.protocol.Protocol;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.protocol.TxDefine;
import io.nuls.base.protocol.TxRegisterDetail;
import io.nuls.core.log.Log;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class RegisterHelper {
    public static boolean registerTx(int chainId, Protocol protocol, String moduleCode) {
        try {
            ArrayList<TxRegisterDetail> txRegisterDetailList = new ArrayList<TxRegisterDetail>();
            Set<TxDefine> allowTxs = protocol.getAllowTx();
            for (TxDefine config : allowTxs) {
                TxRegisterDetail detail = new TxRegisterDetail();
                detail.setSystemTx(config.isSystemTx());
                detail.setTxType(config.getType());
                detail.setUnlockTx(config.isUnlockTx());
                detail.setVerifySignature(config.isVerifySignature());
                detail.setVerifyFee(config.getVerifyFee());
                txRegisterDetailList.add(detail);
            }
            if (txRegisterDetailList.isEmpty()) {
                return true;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("moduleCode", moduleCode);
            params.put("list", txRegisterDetailList);
            params.put("delList", protocol.getInvalidTxs());
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_register", params);
            if (!cmdResp.isSuccess()) {
                Log.error((String)("chain \uff1a" + chainId + " Failure of transaction registration,errorMsg: " + cmdResp.getResponseComment()));
                return false;
            }
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
        }
        return true;
    }

    public static boolean registerTx(int chainId, Protocol protocol) {
        return RegisterHelper.registerTx(chainId, protocol, ConnectManager.LOCAL.getAbbreviation());
    }

    public static boolean registerMsg(Protocol protocol, String role) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            ArrayList cmds = new ArrayList();
            map.put("role", role);
            protocol.getAllowMsg().forEach(e -> cmds.addAll(Arrays.asList(e.getProtocolCmd().split(","))));
            if (cmds.isEmpty()) {
                return true;
            }
            map.put("protocolCmds", cmds);
            return ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_protocolRegister", map).isSuccess();
        }
        catch (Exception e2) {
            Log.error((String)"registerMsg fail", (Throwable)e2);
            return false;
        }
    }

    public static boolean registerMsg(Protocol protocol) {
        return RegisterHelper.registerMsg(protocol, ConnectManager.LOCAL.getAbbreviation());
    }

    public static boolean registerProtocol(int chainId) {
        if (!ModuleHelper.isSupportProtocolUpdate()) {
            return true;
        }
        try {
            Collection<Protocol> protocols = ProtocolGroupManager.getProtocols(chainId);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("version", "1.0");
            params.put("chainId", chainId);
            ArrayList<Protocol> list = new ArrayList<Protocol>(protocols);
            params.put("list", list);
            params.put("moduleCode", ConnectManager.LOCAL.getAbbreviation());
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.PU.abbr, (String)"registerProtocol", params);
            if (!cmdResp.isSuccess()) {
                Log.error((String)("chain \uff1a" + chainId + " Failure of transaction registration,errorMsg: " + cmdResp.getResponseComment()));
                return false;
            }
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
        }
        return true;
    }
}

