/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider;

import io.nuls.base.api.provider.BaseService;
import io.nuls.base.api.provider.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class BaseRpcService
extends BaseService {
    public static final ErrorCode RPC_ERROR_CODE = ErrorCode.init((String)"10016");

    protected <T, R> Result<T> callRpc(String module, String method, Object req, Function<R, Result> callback) {
        Map params = MapUtils.beanToLinkedMap((Object)req);
        Log.debug((String)"call {} rpc , method : {},param : {}", (Object[])new Object[]{module, method, params});
        Response cmdResp = null;
        try {
            cmdResp = ResponseMessageProcessor.requestAndResponse((String)module, (String)method, (Map)params);
            Log.debug((String)"result : {}", (Object[])new Object[]{cmdResp});
        }
        catch (Exception e) {
            Log.warn((String)"Calling remote interface failed. module:{} - interface:{} - message:{}", (Object[])new Object[]{module, method, e.getMessage()});
            return BaseRpcService.fail(RPC_ERROR_CODE, e.getMessage());
        }
        if (!cmdResp.isSuccess()) {
            String comment = cmdResp.getResponseComment();
            if (StringUtils.isBlank((String)comment)) {
                comment = "";
            }
            Log.warn((String)"Calling remote interface failed. module:{} - interface:{} - ResponseComment:{}", (Object[])new Object[]{module, method, cmdResp.getResponseComment()});
            if (cmdResp.getResponseStatus() == 65536) {
                String errorCode = cmdResp.getResponseErrorCode();
                if (StringUtils.isBlank((String)errorCode)) {
                    return BaseRpcService.fail(RPC_ERROR_CODE, StringUtils.isBlank((String)comment) ? "unknown error" : comment);
                }
                return BaseRpcService.fail(ErrorCode.init((String)errorCode), comment);
            }
            if (StringUtils.isNotBlank((String)comment)) {
                return BaseRpcService.fail(RPC_ERROR_CODE, comment);
            }
            return BaseRpcService.fail(RPC_ERROR_CODE, "unknown error");
        }
        return callback.apply(((HashMap)cmdResp.getResponseData()).get(method));
    }

    protected abstract <T, R> Result<T> call(String var1, Object var2, Function<R, Result> var3);

    protected Result<String> callReturnString(String method, Object req, String fieldName) {
        Function<Map, Result> fun = res -> {
            String data = (String)res.get(fieldName);
            return this.success(data);
        };
        return this.call(method, req, fun);
    }

    protected Result<Map> callResutlMap(String method, Object req) {
        Function<Map, Result> fun = res -> this.success(res);
        return this.call(method, req, fun);
    }
}

