/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.ledger;

import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ledger.LedgerProvider;
import io.nuls.base.api.provider.ledger.facade.AccountBalanceInfo;
import io.nuls.base.api.provider.ledger.facade.ContractAsset;
import io.nuls.base.api.provider.ledger.facade.GetAssetReq;
import io.nuls.base.api.provider.ledger.facade.GetBalanceReq;
import io.nuls.base.api.provider.ledger.facade.RegLocalAssetReq;
import io.nuls.core.rpc.model.ModuleE;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.Function;

@Provider(value=Provider.ProviderType.RPC)
public class LedgerProviderForRpc
extends BaseRpcService
implements LedgerProvider {
    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> callback) {
        return this.callRpc(ModuleE.LG.abbr, method, req, callback);
    }

    @Override
    public Result<AccountBalanceInfo> getBalance(GetBalanceReq req) {
        Function<Map, Result> callback = res -> {
            BigInteger total = new BigInteger(String.valueOf(res.get("total")));
            BigInteger freeze = new BigInteger(String.valueOf(res.get("freeze")));
            BigInteger available = new BigInteger(String.valueOf(res.get("available")));
            AccountBalanceInfo info = new AccountBalanceInfo();
            info.setAvailable(available);
            info.setFreeze(freeze);
            info.setTotal(total);
            return this.success(info);
        };
        return this.call("getBalance", req, callback);
    }

    @Override
    public Result<Map> getLocalAsset(GetAssetReq req) {
        return this.callResutlMap("getAssetRegInfoByHash", req);
    }

    @Override
    public Result<Map> getContractAsset(ContractAsset req) {
        return this.callResutlMap("getAssetContract", req);
    }

    @Override
    public Result<Map> regLocalAsset(RegLocalAssetReq req) {
        return this.callResutlMap("chainAssetTxReg", req);
    }
}

