/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.transaction;

import io.nuls.base.RPCUtil;
import io.nuls.base.api.provider.BaseReq;
import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.transaction.TransferService;
import io.nuls.base.api.provider.transaction.facade.CreateMultiSignTransferReq;
import io.nuls.base.api.provider.transaction.facade.GetConfirmedTxByHashReq;
import io.nuls.base.api.provider.transaction.facade.GetTxByHashReq;
import io.nuls.base.api.provider.transaction.facade.MultiSignTransferRes;
import io.nuls.base.api.provider.transaction.facade.SignMultiSignTransferReq;
import io.nuls.base.api.provider.transaction.facade.TransactionCoinData;
import io.nuls.base.api.provider.transaction.facade.TransactionData;
import io.nuls.base.api.provider.transaction.facade.TransferReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Coin;
import io.nuls.base.data.Transaction;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.DateUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Provider(value=Provider.ProviderType.RPC)
public class TransferServiceForRpc
extends BaseRpcService
implements TransferService {
    @Override
    public Result transferTest(int method, String addr1, String addr2, String amount) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("version", "1.0");
            params.put("act", method);
            params.put("address1", addr1);
            params.put("address2", addr2);
            Request request = MessageUtil.newRequest((String)"transferCMDTest", params, (String)"1", (String)"0", (String)"0");
            String messageId = ResponseMessageProcessor.requestOnly((String)ModuleE.TX.abbr, (Request)request);
            return messageId.equals("0") ? Result.fail("", "") : new Result();
        }
        catch (Exception e) {
            return Result.fail("", "fail");
        }
    }

    @Override
    public Result<String> transfer(TransferReq req) {
        return this.callReturnString("ac_transfer", req, "value");
    }

    @Override
    public Result<MultiSignTransferRes> multiSignTransfer(CreateMultiSignTransferReq req) {
        return this.callRpc(ModuleE.AC.abbr, "ac_createMultiSignTransfer", req, data -> {
            MultiSignTransferRes res = (MultiSignTransferRes)MapUtils.mapToBean((Map)data, (Object)new MultiSignTransferRes());
            return this.success(res);
        });
    }

    @Override
    public Result<MultiSignTransferRes> signMultiSignTransfer(SignMultiSignTransferReq req) {
        return this.callRpc(ModuleE.AC.abbr, "ac_signMultiSignTransaction", req, data -> {
            MultiSignTransferRes res = (MultiSignTransferRes)MapUtils.mapToBean((Map)data, (Object)new MultiSignTransferRes());
            return this.success(res);
        });
    }

    @Override
    public Result<String> transferByAlias(TransferReq req) {
        return this.callReturnString("ac_transfer", req, "value");
    }

    @Override
    public Result<Transaction> getTxByHash(GetTxByHashReq req) {
        return this.getTx("tx_getTxClient", req);
    }

    @Override
    public Result<String> getTxHexByHash(GetConfirmedTxByHashReq req) {
        Result<Transaction> result = this.getTx("tx_getTxClient", req);
        try {
            return this.success(HexUtil.encode((byte[])result.getData().serialize()));
        }
        catch (IOException e) {
            return Result.fail("failed", "serialize failed!");
        }
    }

    @Override
    public Result<Transaction> getConfirmedTxByHash(GetConfirmedTxByHashReq req) {
        return this.getTx("tx_getConfirmedTxClient", req);
    }

    @Override
    public Result<TransactionData> getSimpleTxDataByHash(GetConfirmedTxByHashReq req) {
        return this.callRpc(ModuleE.TX.abbr, "tx_getTxClient", req, res -> this.tranderTransactionData(this.tranderTransaction((Map<String, Object>)res)));
    }

    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> res) {
        return this.callRpc(ModuleE.AC.abbr, method, req, res);
    }

    private Result<Transaction> getTx(String method, BaseReq req) {
        return this.callRpc(ModuleE.TX.abbr, method, req, this::tranderTransaction);
    }

    private Result<Transaction> tranderTransaction(Map<String, Object> data) {
        try {
            String hexString = (String)data.get("tx");
            if (StringUtils.isNull((String)hexString)) {
                return TransferServiceForRpc.fail(CommonCodeConstanst.DATA_NOT_FOUND, "not found tx");
            }
            Transaction transaction = new Transaction();
            transaction.parse(new NulsByteBuffer(RPCUtil.decode((String)hexString)));
            transaction.setBlockHeight(Long.parseLong(String.valueOf(data.get("height"))));
            Integer state = (Integer)data.get("status");
            transaction.setStatus(state.intValue() == TxStatusEnum.UNCONFIRM.getStatus() ? TxStatusEnum.UNCONFIRM : TxStatusEnum.CONFIRMED);
            return this.success(transaction);
        }
        catch (NulsException e) {
            Log.error((String)"Deserializationtransactionexception occurred", (Throwable)e);
            return TransferServiceForRpc.fail(CommonCodeConstanst.DESERIALIZE_ERROR);
        }
    }

    private Result<TransactionData> tranderTransactionData(Result<Transaction> data) {
        if (data.isFailed()) {
            return TransferServiceForRpc.fail(ErrorCode.init((String)data.getStatus()), data.getMessage());
        }
        try {
            Transaction transaction = data.getData();
            TransactionData res = new TransactionData();
            res.setBlockHeight(transaction.getBlockHeight());
            res.setStatus(transaction.getStatus());
            res.setHash(transaction.getHash().toString());
            res.setRemark(ByteUtils.asString((byte[])transaction.getRemark()));
            res.setInBlockIndex(transaction.getInBlockIndex());
            res.setSize(transaction.getSize());
            res.setTime(DateUtils.timeStamp2DateStr((long)(transaction.getTime() * 1000L)));
            res.setTransactionSignature(RPCUtil.encode((byte[])transaction.getTransactionSignature()));
            res.setType(transaction.getType());
            res.setFrom(transaction.getCoinDataInstance().getFrom().stream().map(coinData -> {
                TransactionCoinData tcd = this.buildTransactionCoinData((Coin)coinData);
                tcd.setNonce(HexUtil.encode((byte[])coinData.getNonce()));
                return tcd;
            }).collect(Collectors.toList()));
            res.setTo(transaction.getCoinDataInstance().getTo().stream().map(to -> {
                TransactionCoinData toData = this.buildTransactionCoinData((Coin)to);
                if (to.getLockTime() == -1L) {
                    toData.setLockTime("No fixed time");
                } else if (to.getLockTime() == 0L) {
                    toData.setLockTime("No lock");
                } else {
                    toData.setLockTime(DateUtils.timeStamp2DateStr((long)(to.getLockTime() * 1000L)));
                }
                return toData;
            }).collect(Collectors.toList()));
            return this.success(res);
        }
        catch (NulsException e) {
            Log.error((String)"Deserializationtransactionexception occurred", (Throwable)e);
            return TransferServiceForRpc.fail(CommonCodeConstanst.DESERIALIZE_ERROR);
        }
    }

    private TransactionCoinData buildTransactionCoinData(Coin coinData) {
        TransactionCoinData tcd = new TransactionCoinData();
        tcd.setAddress(AddressTool.getStringAddressByBytes((byte[])coinData.getAddress()));
        tcd.setAmount(coinData.getAmount());
        tcd.setAssetsChainId(coinData.getAssetsChainId());
        tcd.setAssetsId(coinData.getAssetsId());
        return tcd;
    }
}

