/*
 * Decompiled with CFR 0.152.
 */
package io.nuls;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.nuls.account.util.LoggerUtil;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.basic.AddressPrefixInf;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.protocol.ModuleHelper;
import io.nuls.common.CommonContext;
import io.nuls.common.CommonVersionChangeInvoker;
import io.nuls.common.ConfigManager;
import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.tx.SmartContractVersionChangeInvoker;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.info.HostInfo;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.InvokeBean;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.modulebootstrap.NulsRpcModuleBootstrap;
import io.nuls.core.rpc.modulebootstrap.RpcModule;
import io.nuls.core.rpc.modulebootstrap.RpcModuleState;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.rpc.upgrade.TxVersionChangeInvoker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

@Component
public class NulsCoresBootstrap
extends RpcModule {
    private static String[] args;
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private AddressPrefixDatas addressPrefixDatas;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private ConfigManager configManager;

    public static void main(String[] args) throws Exception {
        NulsCoresBootstrap.initSys();
        if (args == null || args.length == 0) {
            args = new String[]{"ws://" + HostInfo.getLocalIP() + ":7771"};
        }
        NulsCoresBootstrap.args = args;
        NulsRpcModuleBootstrap.run((String)"io.nuls", (String[])args);
    }

    public void init() {
        try {
            super.init();
            CommonVersionChangeInvoker.addProcess(TxVersionChangeInvoker.instance());
            CommonVersionChangeInvoker.addProcess(SmartContractVersionChangeInvoker.instance());
            this.initCfg();
            ModuleHelper.init((RpcModule)this);
        }
        catch (Exception e) {
            io.nuls.transaction.utils.LoggerUtil.LOG.error("Transaction init error!");
            io.nuls.transaction.utils.LoggerUtil.LOG.error(e);
        }
    }

    public boolean doStart() {
        try {
            this.configManager.init();
            NulsDateUtils.getInstance().start();
            LoggerUtil.LOG.info("Nuls-Core onDependenciesReady");
            LoggerUtil.LOG.info("START-SUCCESS");
            try {
                Collection list = SpringLiteContext.getAllBeanList();
                ArrayList<INulsCoresBootstrap> coreList = new ArrayList<INulsCoresBootstrap>();
                for (Object object : list) {
                    if (!(object instanceof INulsCoresBootstrap)) continue;
                    coreList.add((INulsCoresBootstrap)object);
                }
                coreList.sort(new Comparator<INulsCoresBootstrap>(){

                    @Override
                    public int compare(INulsCoresBootstrap o1, INulsCoresBootstrap o2) {
                        if (o1.order() > o2.order()) {
                            return 1;
                        }
                        if (o1.order() < o2.order()) {
                            return -1;
                        }
                        return 0;
                    }
                });
                this.initCores(coreList);
                this.configManager.registerProtocol();
                this.runCores(coreList);
            }
            catch (Exception e) {
                io.nuls.transaction.utils.LoggerUtil.LOG.error(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void onDependenciesReady(Module module) {
    }

    public RpcModuleState onDependenciesReady() {
        io.nuls.transaction.utils.LoggerUtil.LOG.info("Transaction onDependenciesReady");
        NulsDateUtils.getInstance().start();
        CommonContext.START_BOOT.countDown();
        return RpcModuleState.Running;
    }

    public RpcModuleState onDependenciesLoss(Module module) {
        return RpcModuleState.Ready;
    }

    protected long getTryRuningTimeout() {
        return 60000L;
    }

    public Module[] declareDependent() {
        return new Module[]{Module.build((ModuleE)ModuleE.NC)};
    }

    public Module moduleInfo() {
        return new Module(ModuleE.NC.abbr, "1.0");
    }

    private void initCfg() {
        try {
            Object[][] txTypeModules;
            String moduleAbbr;
            Provider.ProviderType providerType = Provider.ProviderType.RPC;
            ServiceManager.init((Integer)this.config.getChainId(), (Provider.ProviderType)providerType);
            AddressTool.init((AddressPrefixInf)this.addressPrefixDatas);
            AddressTool.addPrefix((int)this.config.getChainId(), (String)this.config.getAddressPrefix());
            List cmdList = SpringLiteContext.getBeanList(BaseCmd.class);
            for (BaseCmd cmd : cmdList) {
                Method[] methods;
                Class<?> clazs = cmd.getClass();
                NulsCoresCmd nulsCoresCmd = clazs.getAnnotation(NulsCoresCmd.class);
                if (nulsCoresCmd == null) continue;
                ModuleE module = nulsCoresCmd.module();
                moduleAbbr = module.abbr;
                for (Method method : methods = clazs.getMethods()) {
                    CmdAnnotation annotation = method.getAnnotation(CmdAnnotation.class);
                    if (annotation == null) continue;
                    String cmdName = annotation.cmd();
                    ResponseMessageProcessor.INVOKE_BEAN_MAP.put(moduleAbbr + "_" + cmdName, new InvokeBean(cmd, method));
                }
            }
            for (Object[] txTypeModule : txTypeModules = new Object[][]{{ModuleE.AC.abbr, new int[]{2, 3, 63, 64, 65}}, {ModuleE.BL.abbr, new int[0]}, {ModuleE.CS.abbr, new int[]{1, 4, 5, 6, 7, 8, 9, 20, 21, 22, 23, 34}}, {ModuleE.CM.abbr, new int[]{11, 12, 13, 14}}, {ModuleE.CC.abbr, new int[]{10, 24, 25, 26, 60, 61}}, {ModuleE.LG.abbr, new int[]{27}}, {ModuleE.NW.abbr, new int[0]}, {ModuleE.PU.abbr, new int[0]}, {ModuleE.SC.abbr, new int[]{15, 16, 17, 18, 19}}, {ModuleE.TX.abbr, new int[0]}}) {
                moduleAbbr = (String)txTypeModule[0];
                int[] txTypes = (int[])txTypeModule[1];
                if (txTypes.length == 0) continue;
                for (int txType : txTypes) {
                    ResponseMessageProcessor.TX_TYPE_MODULE_MAP.put(txType, moduleAbbr);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("NulsCores Bootstrap initCfg failed :{}", new Object[]{e.getMessage(), e});
            throw new RuntimeException("NulsCores Bootstrap initCfg failed");
        }
    }

    private static void initSys() throws Exception {
        try {
            Class.forName("io.nuls.core.rpc.netty.processor.ResponseMessageProcessor");
            ConfigurationLoader configurationLoader = new ConfigurationLoader();
            configurationLoader.load();
            int defaultChainId = Integer.parseInt(configurationLoader.getValue("chainId"));
            ServiceManager.init((Integer)defaultChainId, (Provider.ProviderType)Provider.ProviderType.RPC);
            System.setProperty("protostuff.runtime.allow_null_array_element", "true");
            System.setProperty("file.encoding", StandardCharsets.UTF_8.name());
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, StandardCharsets.UTF_8);
            ObjectMapper objectMapper = JSONUtils.getInstance();
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw e;
        }
    }

    private void initCores(List<INulsCoresBootstrap> coreList) {
        for (INulsCoresBootstrap core : coreList) {
            io.nuls.transaction.utils.LoggerUtil.LOG.info("Nerve core module [{}] init", new Object[]{core.moduleInfo().getName()});
            core.mainFunction(args);
        }
    }

    private void runCores(List<INulsCoresBootstrap> coreList) {
        for (INulsCoresBootstrap core : coreList) {
            io.nuls.transaction.utils.LoggerUtil.LOG.info("Nerve core module ready [{}]", new Object[]{core.moduleInfo().getName()});
            core.onDependenciesReady();
        }
    }
}

