/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account;

import io.nuls.account.config.NulsConfig;
import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.basic.AddressPrefixInf;
import io.nuls.base.basic.AddressTool;
import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import java.io.File;

@Component
public class AccountBootstrap
implements INulsCoresBootstrap {
    @Autowired
    private NulsCoresConfig accountConfig;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AddressPrefixDatas addressPrefixDatas;

    @Override
    public int order() {
        return 6;
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.AC.abbr, "1.0");
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    public void init() {
        try {
            this.initCfg();
            this.initDB();
            this.chainManager.initChain();
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("AccountBootsrap init error!");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onDependenciesReady() {
        LoggerUtil.LOG.info("account onDependenciesReady");
        LoggerUtil.LOG.info("START-SUCCESS");
    }

    public void initCfg() {
        try {
            NulsConfig.DATA_PATH = this.accountConfig.getDataPath();
            LoggerUtil.LOG.info("dataPath:{}", new Object[]{NulsConfig.DATA_PATH});
            NulsConfig.DEFAULT_ENCODING = this.accountConfig.getEncoding();
            NulsConfig.MAIN_ASSETS_ID = this.accountConfig.getMainAssetId();
            NulsConfig.MAIN_CHAIN_ID = this.accountConfig.getMainChainId();
            NulsConfig.BLACK_HOLE_PUB_KEY = HexUtil.decode((String)this.accountConfig.getBlackHolePublicKey());
            AddressTool.init((AddressPrefixInf)this.addressPrefixDatas);
            AddressTool.addPrefix((int)this.accountConfig.getChainId(), (String)this.accountConfig.getAddressPrefix());
            if (StringUtils.isNotBlank((String)this.accountConfig.getKeystoreFolder())) {
                NulsConfig.ACCOUNTKEYSTORE_FOLDER_NAME = this.accountConfig.getDataPath() + this.accountConfig.getKeystoreFolder();
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("Account Bootstrap initCfg failed :{}", new Object[]{e.getMessage(), e});
            throw new RuntimeException("Account Bootstrap initCfg failed");
        }
    }

    private void initDB() throws Exception {
        RocksDBService.init((String)(this.accountConfig.getDataPath() + File.separator + ModuleE.AC.name));
        try {
            if (!RocksDBService.existTable((String)"account")) {
                RocksDBService.createTable((String)"account");
            }
            if (!RocksDBService.existTable((String)"multi_account")) {
                RocksDBService.createTable((String)"multi_account");
            }
            if (!RocksDBService.existTable((String)"account_block")) {
                RocksDBService.createTable((String)"account_block");
            }
            if (!RocksDBService.existTable((String)"account_contract_call")) {
                RocksDBService.createTable((String)"account_contract_call");
            }
        }
        catch (Exception e) {
            if (!"DB table exists".equals(e.getMessage())) {
                LoggerUtil.LOG.error(e.getMessage());
                throw new NulsException(AccountErrorCode.DB_TABLE_CREATE_ERROR);
            }
            LoggerUtil.LOG.info(e.getMessage());
        }
    }
}

