/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.service.impl;

import io.nuls.account.config.NulsConfig;
import io.nuls.account.constant.AccountConstant;
import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.NonceBalance;
import io.nuls.account.model.bo.Account;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.bo.tx.AliasTransaction;
import io.nuls.account.model.bo.tx.txdata.Alias;
import io.nuls.account.model.po.AccountPO;
import io.nuls.account.model.po.AliasPO;
import io.nuls.account.model.po.MultiSigAccountPO;
import io.nuls.account.rpc.call.TransactionCall;
import io.nuls.account.service.AccountCacheService;
import io.nuls.account.service.AccountService;
import io.nuls.account.service.AliasService;
import io.nuls.account.service.TransactionService;
import io.nuls.account.storage.AccountStorageService;
import io.nuls.account.storage.AliasStorageService;
import io.nuls.account.storage.MultiSigAccountStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.TxUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Component
public class AliasServiceImpl
implements AliasService,
InitializingBean {
    private Lock locker = new ReentrantLock();
    @Autowired
    private AccountStorageService accountStorageService;
    @Autowired
    private AliasStorageService aliasStorageService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private MultiSigAccountStorageService multiSigAccountStorageService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ChainManager chainManager;
    private AccountCacheService accountCacheService = AccountCacheService.getInstance();

    public void afterPropertiesSet() {
    }

    @Override
    public Transaction setAlias(Chain chain, String address, String password, String aliasName) throws NulsException {
        Transaction tx = null;
        int chainId = chain.getChainId();
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR);
        }
        if (AddressTool.validContractAddress((byte[])AddressTool.getAddress((String)address), (int)chainId)) {
            throw new NulsRuntimeException(AccountErrorCode.CONTRACT_ADDRESS_CAN_NOT_SET_ALIAS);
        }
        if (!FormatValidUtils.validAlias((String)aliasName)) {
            throw new NulsRuntimeException(AccountErrorCode.ALIAS_FORMAT_WRONG);
        }
        Account account = this.accountService.getAccount(chainId, address);
        if (null == account) {
            throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_NOT_EXIST);
        }
        if (account.isEncrypted() && account.isLocked() && !account.validatePassword(password)) {
            throw new NulsRuntimeException(AccountErrorCode.PASSWORD_IS_WRONG);
        }
        if (StringUtils.isNotBlank((String)account.getAlias())) {
            throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_ALREADY_SET_ALIAS);
        }
        if (!this.isAliasUsable(chainId, aliasName)) {
            throw new NulsRuntimeException(AccountErrorCode.ALIAS_EXIST);
        }
        account.setChainId(chainId);
        tx = this.transactionService.createSetAliasTxWithoutSign(chain, account.getAddress(), aliasName);
        this.signTransaction(tx, account, password);
        TransactionCall.newTx(chain, tx);
        return tx;
    }

    @Override
    public String getAliasByAddress(int chainId, String address) {
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            LoggerUtil.LOG.debug("the address is illegal,chainId:{},address:{}", new Object[]{chainId, address});
            throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR);
        }
        AliasPO result = this.aliasStorageService.getAliasByAddress(chainId, address);
        if (result == null) {
            return null;
        }
        return result.getAlias();
    }

    @Override
    public boolean isAliasUsable(int chainId, String alias) {
        return null == this.aliasStorageService.getAlias(chainId, alias);
    }

    @Override
    public Result aliasTxValidate(int chainId, Transaction transaction) throws NulsException {
        Alias alias = new Alias();
        alias.parse(new NulsByteBuffer(transaction.getTxData()));
        byte[] addrByte = alias.getAddress();
        String address = AddressTool.getStringAddressByBytes((byte[])addrByte);
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR);
        }
        if (AddressTool.validContractAddress((byte[])addrByte, (int)chainId)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.CONTRACT_ADDRESS_CAN_NOT_SET_ALIAS);
        }
        if (!FormatValidUtils.validAlias((String)alias.getAlias())) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ALIAS_FORMAT_WRONG);
        }
        if (!this.isAliasUsable(chainId, alias.getAlias())) {
            LoggerUtil.LOG.error("alias is disable,alias: " + alias.getAlias() + ",address: " + addrByte);
            return Result.getFailed((ErrorCode)AccountErrorCode.ALIAS_EXIST);
        }
        AliasPO aliasPo = this.aliasStorageService.getAliasByAddress(chainId, address);
        if (aliasPo != null) {
            LoggerUtil.LOG.error("alias is already exist, alias: " + alias.getAlias() + ",address: " + addrByte);
            return Result.getFailed((ErrorCode)AccountErrorCode.ACCOUNT_ALREADY_SET_ALIAS);
        }
        CoinData coinData = transaction.getCoinDataInstance();
        if (null == coinData) {
            return Result.getFailed((ErrorCode)AccountErrorCode.TX_COINDATA_NOT_EXIST);
        }
        if (null != coinData.getFrom()) {
            for (CoinFrom coinFrom : coinData.getFrom()) {
                if (Arrays.equals(coinFrom.getAddress(), addrByte)) continue;
                LoggerUtil.LOG.error("alias coin contains multiple different addresses, txhash:{}", new Object[]{transaction.getHash().toHex()});
                return Result.getFailed((ErrorCode)AccountErrorCode.TX_DATA_VALIDATION_ERROR);
            }
        }
        if (null != coinData.getTo()) {
            boolean burned = false;
            for (Coin coin : coinData.getTo()) {
                if (!AddressTool.isBlackHoleAddress((byte[])NulsConfig.BLACK_HOLE_PUB_KEY, (int)chainId, (byte[])coin.getAddress()) || !coin.getAmount().equals(AccountConstant.ALIAS_FEE)) continue;
                burned = true;
                break;
            }
            if (!burned) {
                return Result.getFailed((ErrorCode)AccountErrorCode.MUST_BURN_A_NULS);
            }
        }
        return TxUtil.getSuccess();
    }

    @Override
    public boolean aliasTxCommit(int chainId, Alias alias) throws NulsException {
        boolean result = false;
        try {
            AccountPO po;
            byte[] address;
            result = this.aliasStorageService.saveAlias(chainId, alias);
            if (!result) {
                this.rollbackAlias(chainId, alias);
            }
            if (AddressTool.isMultiSignAddress((byte[])(address = alias.getAddress()))) {
                MultiSigAccountPO multiSignAccountPO = this.multiSigAccountStorageService.getAccount(address);
                if (null != multiSignAccountPO) {
                    multiSignAccountPO.setAlias(alias.getAlias());
                    result = this.multiSigAccountStorageService.saveAccount(multiSignAccountPO);
                    if (!result) {
                        this.rollbackAlias(chainId, alias);
                    }
                }
            } else if (AddressTool.validNormalAddress((byte[])address, (int)chainId) && null != (po = this.accountStorageService.getAccount(alias.getAddress()))) {
                po.setAlias(alias.getAlias());
                result = this.accountStorageService.updateAccount(po);
                if (!result) {
                    this.rollbackAlias(chainId, alias);
                }
                Account account = po.toAccount();
                this.accountCacheService.getLocalAccountMaps().put(account.getAddress().getBase58(), account);
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            this.rollbackAlias(chainId, alias);
            return false;
        }
        return result;
    }

    @Override
    public boolean rollbackAlias(int chainId, Alias alias) throws NulsException {
        boolean result = true;
        try {
            AliasPO po = this.aliasStorageService.getAlias(chainId, alias.getAlias());
            if (po != null && Arrays.equals(po.getAddress(), alias.getAddress())) {
                result = this.aliasStorageService.removeAlias(chainId, po);
                AccountPO accountPo = this.accountStorageService.getAccount(alias.getAddress());
                if (accountPo != null) {
                    accountPo.setAlias("");
                    result = this.accountStorageService.updateAccount(accountPo);
                    if (!result) {
                        return result;
                    }
                    Account account = accountPo.toAccount();
                    this.accountCacheService.getLocalAccountMaps().put(account.getAddress().getBase58(), account);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            throw new NulsException(AccountErrorCode.ALIAS_ROLLBACK_ERROR, (Throwable)e);
        }
        return result;
    }

    private Transaction createAliasTrasactionWithoutSign(Chain chain, Account account, String aliasName) throws NulsException {
        AliasTransaction tx = null;
        tx = new AliasTransaction();
        tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
        Alias alias = new Alias();
        alias.setAlias(aliasName);
        alias.setAddress(account.getAddress().getAddressBytes());
        try {
            tx.setTxData(alias.serialize());
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        int assetsId = chain.getConfig().getAssetId();
        NonceBalance nonceBalance = TxUtil.getBalanceNonce(chain, account.getChainId(), assetsId, account.getAddress().getAddressBytes());
        byte[] nonce = nonceBalance.getNonce();
        CoinFrom coinFrom = new CoinFrom(account.getAddress().getAddressBytes(), account.getChainId(), assetsId, AccountConstant.ALIAS_FEE, nonce, 0);
        coinFrom.setAddress(account.getAddress().getAddressBytes());
        CoinTo coinTo = new CoinTo(AddressTool.getAddress((byte[])NulsConfig.BLACK_HOLE_PUB_KEY, (int)account.getChainId()), account.getChainId(), assetsId, AccountConstant.ALIAS_FEE);
        int txSize = tx.size() + coinFrom.size() + coinTo.size() + 110;
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)txSize, (long)100000L);
        BigInteger totalAmount = AccountConstant.ALIAS_FEE.add(fee);
        coinFrom.setAmount(totalAmount);
        BigInteger mainAsset = nonceBalance.getAvailable();
        if (BigIntegerUtils.isLessThan((BigInteger)mainAsset, (BigInteger)totalAmount)) {
            throw new NulsRuntimeException(AccountErrorCode.INSUFFICIENT_FEE);
        }
        CoinData coinData = new CoinData();
        coinData.setFrom(Arrays.asList(coinFrom));
        coinData.setTo(Arrays.asList(coinTo));
        try {
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        return tx;
    }

    private Transaction signTransaction(Transaction transaction, Account account, String password) throws NulsException {
        TransactionSignature transactionSignature = new TransactionSignature();
        ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
        ECKey eckey = account.getEcKey(password);
        P2PHKSignature p2PHKSignature = SignatureUtil.createSignatureByEckey((Transaction)transaction, (ECKey)eckey);
        p2PHKSignatures.add(p2PHKSignature);
        transactionSignature.setP2PHKSignatures(p2PHKSignatures);
        try {
            transaction.setTransactionSignature(transactionSignature.serialize());
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        return transaction;
    }
}

