/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.service.impl;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Account;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.po.MultiSigAccountPO;
import io.nuls.account.service.AccountService;
import io.nuls.account.service.AliasService;
import io.nuls.account.service.MultiSignAccountService;
import io.nuls.account.service.TransactionService;
import io.nuls.account.storage.MultiSigAccountStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Address;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.parse.SerializeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@Component
public class MultiSigAccountServiceImpl
implements MultiSignAccountService {
    @Autowired
    private MultiSigAccountStorageService multiSigAccountStorageService;
    @Autowired
    private AliasService aliasService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private MultiSignAccountService multiSignAccountService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TransactionService transactionService;

    private List<String> getOriginalPubKeys(int chainId, List<String> pubKeys) {
        for (int i = 0; i < pubKeys.size(); ++i) {
            String pubKey = pubKeys.get(i);
            if (!AddressTool.validAddress((int)chainId, (String)pubKey)) continue;
            if (AddressTool.isMultiSignAddress((String)pubKey)) {
                throw new NulsRuntimeException(AccountErrorCode.CONTRACT_ADDRESS_CANNOT_CREATE_MULTISIG_ACCOUNT);
            }
            if (AddressTool.validContractAddress((byte[])AddressTool.getAddress((String)pubKey), (int)chainId)) {
                throw new NulsRuntimeException(AccountErrorCode.MULTISIG_ADDRESS_CANNOT_CREATE_MULTISIG_ACCOUNT);
            }
            if (!AddressTool.validNormalAddress((byte[])AddressTool.getAddress((String)pubKey), (int)chainId)) continue;
            Account account = this.accountService.getAccount(chainId, pubKey);
            if (account == null) {
                throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_NOT_EXIST);
            }
            pubKeys.set(i, HexUtil.encode((byte[])account.getPubKey()));
        }
        return pubKeys;
    }

    @Override
    public MultiSigAccount createMultiSigAccount(Chain chain, List<String> pubKeys, int minSigns) throws NulsException {
        MultiSigAccount multiSigAccount = null;
        int chainId = chain.getChainId();
        this.getOriginalPubKeys(chainId, pubKeys);
        HashSet<String> pubkeySet = new HashSet<String>(pubKeys);
        if (pubkeySet.size() < pubKeys.size()) {
            throw new NulsException(AccountErrorCode.PUBKEY_REPEAT);
        }
        Address address = null;
        try {
            address = new Address(chainId, BaseConstant.P2SH_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])AddressTool.createMultiSigAccountOriginBytes((int)chainId, (int)minSigns, pubKeys)));
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            throw new NulsException(AccountErrorCode.CREATE_MULTISIG_ADDRESS_FAIL);
        }
        multiSigAccount = this.saveMultiSigAccount(chainId, address, pubKeys, minSigns);
        return multiSigAccount;
    }

    @Override
    public MultiSigAccount getMultiSigAccountByAddress(byte[] address) {
        MultiSigAccount multiSigAccount = null;
        try {
            MultiSigAccountPO multiSigAccountPo = this.multiSigAccountStorageService.getAccount(address);
            if (multiSigAccountPo != null) {
                multiSigAccount = multiSigAccountPo.toAccount();
            }
        }
        catch (Exception e) {
            throw new NulsRuntimeException(AccountErrorCode.FAILED);
        }
        return multiSigAccount;
    }

    @Override
    public MultiSigAccount getMultiSigAccountByAddress(String address) {
        return this.getMultiSigAccountByAddress(AddressTool.getAddress((String)address));
    }

    @Override
    public boolean removeMultiSigAccount(int chainId, String address) {
        boolean result;
        try {
            byte[] addressBytes = AddressTool.getAddress((String)address);
            MultiSigAccountPO multiSigAccountPo = this.multiSigAccountStorageService.getAccount(addressBytes);
            if (multiSigAccountPo == null) {
                throw new NulsRuntimeException(AccountErrorCode.MULTISIGN_ACCOUNT_NOT_EXIST);
            }
            Address addressObj = new Address(address);
            result = this.multiSigAccountStorageService.removeAccount(addressObj);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            throw new NulsRuntimeException(AccountErrorCode.FAILED);
        }
        return result;
    }

    private MultiSigAccount saveMultiSigAccount(int chainId, Address addressObj, List<String> pubKeys, int minSigns) {
        MultiSigAccount multiSigAccount = null;
        MultiSigAccountPO multiSigAccountPo = new MultiSigAccountPO();
        multiSigAccountPo.setChainId(chainId);
        multiSigAccountPo.setAddress(addressObj);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (String pubKey : pubKeys) {
            list.add(HexUtil.decode((String)pubKey));
        }
        multiSigAccountPo.setPubKeyList(list);
        multiSigAccountPo.setM((byte)minSigns);
        multiSigAccountPo.setAlias(this.aliasService.getAliasByAddress(chainId, addressObj.getBase58()));
        boolean result = this.multiSigAccountStorageService.saveAccount(multiSigAccountPo);
        if (result) {
            multiSigAccount = multiSigAccountPo.toAccount();
        }
        return multiSigAccount;
    }
}

