/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.storage.impl;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.po.AccountContractCallPO;
import io.nuls.account.storage.AccountForTransferOnContractCallStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class AccountForTransferOnContractCallStorageServiceImpl
implements AccountForTransferOnContractCallStorageService {
    @Override
    public boolean saveAccountList(List<AccountContractCallPO> accountPOList) {
        if (null == accountPOList || accountPOList.size() == 0) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        HashMap<byte[], byte[]> accountPoMap = new HashMap<byte[], byte[]>();
        try {
            for (AccountContractCallPO po : accountPOList) {
                accountPoMap.put(po.getAddress(), po.serialize());
            }
            return RocksDBService.batchPut((String)"account_contract_call", accountPoMap);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_BATCH_ERROR);
        }
    }

    @Override
    public boolean removeAccount(List<byte[]> addresses) {
        if (null == addresses || addresses.size() <= 0) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        try {
            return RocksDBService.deleteKeys((String)"account_contract_call", addresses);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_ERROR);
        }
    }

    @Override
    public List<AccountContractCallPO> getAccountList() {
        ArrayList<AccountContractCallPO> accountPOList = new ArrayList<AccountContractCallPO>();
        try {
            List list = RocksDBService.valueList((String)"account_contract_call");
            if (list != null) {
                for (byte[] value : list) {
                    AccountContractCallPO accountPo = new AccountContractCallPO();
                    accountPo.parse(value, 0);
                    accountPOList.add(accountPo);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return accountPOList;
    }

    @Override
    public AccountContractCallPO getAccount(byte[] address) {
        byte[] accountBytes = RocksDBService.get((String)"account_contract_call", (byte[])address);
        if (null == accountBytes) {
            return null;
        }
        AccountContractCallPO accountPo = new AccountContractCallPO();
        try {
            accountPo.parse(accountBytes, 0);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return accountPo;
    }

    @Override
    public boolean exist(byte[] address) {
        byte[] accountBytes = RocksDBService.get((String)"account_contract_call", (byte[])address);
        return null != accountBytes;
    }
}

