/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.storage.impl;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.tx.txdata.Alias;
import io.nuls.account.model.po.AliasPO;
import io.nuls.account.storage.AliasStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import java.io.File;

@Component
public class AliasStorageServiceImpl
implements AliasStorageService,
InitializingBean {
    @Autowired
    private NulsCoresConfig config;

    public void afterPropertiesSet() throws NulsException {
    }

    @Override
    public AliasPO getAlias(int chainId, String alias) {
        if (alias == null || "".equals(alias.trim())) {
            return null;
        }
        byte[] aliasBytes = RocksDBService.get((String)("account_alias_key_alias" + chainId), (byte[])StringUtils.bytes((String)alias));
        if (null == aliasBytes) {
            return null;
        }
        AliasPO aliasPo = new AliasPO();
        try {
            aliasPo.parse(aliasBytes, 0);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return aliasPo;
    }

    @Override
    public AliasPO getAliasByAddress(int chainId, String address) {
        AliasPO aliasPo;
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            LoggerUtil.LOG.debug("the address is illegal,chainId:{},address:{}", new Object[]{chainId, address});
            throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR);
        }
        try {
            byte[] aliasBytes = RocksDBService.get((String)("account_alias_key_address" + chainId), (byte[])AddressTool.getAddress((String)address));
            if (null == aliasBytes) {
                return null;
            }
            aliasPo = new AliasPO();
            aliasPo.parse(aliasBytes, 0);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR, (Throwable)e);
        }
        return aliasPo;
    }

    @Override
    public boolean saveAlias(int chainId, Alias alias) {
        AliasPO aliasPo = new AliasPO();
        aliasPo.setAlias(alias.getAlias());
        aliasPo.setAddress(alias.getAddress());
        aliasPo.setChainId(chainId);
        String tableNameKeyIsAlias = "account_alias_key_alias" + chainId;
        String tableNameKeyIsAddress = "account_alias_key_address" + chainId;
        boolean result = false;
        try {
            RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.AC.name));
            if (!RocksDBService.existTable((String)tableNameKeyIsAlias) && !(result = RocksDBService.createTable((String)tableNameKeyIsAlias))) {
                return false;
            }
            if (!RocksDBService.existTable((String)tableNameKeyIsAddress) && !(result = RocksDBService.createTable((String)tableNameKeyIsAddress))) {
                return false;
            }
            result = RocksDBService.put((String)tableNameKeyIsAlias, (byte[])StringUtils.bytes((String)aliasPo.getAlias()), (byte[])aliasPo.serialize());
            if (!result) {
                return false;
            }
            result = RocksDBService.put((String)tableNameKeyIsAddress, (byte[])aliasPo.getAddress(), (byte[])aliasPo.serialize());
            return result;
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_ERROR);
        }
    }

    @Override
    public boolean removeAlias(int chainId, AliasPO aliasPO) {
        try {
            RocksDBService.delete((String)("account_alias_key_address" + chainId), (byte[])aliasPO.getAddress());
            return RocksDBService.delete((String)("account_alias_key_alias" + chainId), (byte[])StringUtils.bytes((String)aliasPO.getAlias()));
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            throw new NulsRuntimeException(AccountErrorCode.DB_DELETE_ERROR, (Throwable)e);
        }
    }
}

