/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block;

import io.nuls.block.manager.ChainManager;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.thread.BlockSynchronizer;
import io.nuls.block.thread.monitor.ForkChainsMonitor;
import io.nuls.block.thread.monitor.NetworkResetMonitor;
import io.nuls.block.thread.monitor.NodesMonitor;
import io.nuls.block.thread.monitor.OrphanChainsMaintainer;
import io.nuls.block.thread.monitor.OrphanChainsMonitor;
import io.nuls.block.thread.monitor.StorageSizeMonitor;
import io.nuls.block.thread.monitor.TxGroupRequestor;
import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import io.nuls.core.thread.ThreadUtils;
import io.nuls.core.thread.commom.NulsThreadFactory;
import java.io.File;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Component
public class BlockBootstrap
implements INulsCoresBootstrap {
    @Autowired
    public static NulsCoresConfig blockConfig;
    @Autowired
    private AddressPrefixDatas addressPrefixDatas;
    @Autowired
    private ChainManager chainManager;
    public static boolean started;

    @Override
    public int order() {
        return 0;
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.BL.abbr, "1.0");
    }

    public void init() {
        try {
            this.initDb();
            this.chainManager.initChain();
        }
        catch (Exception e) {
            Log.error((String)"BlockBootstrap init error!");
            throw new RuntimeException(e);
        }
    }

    private void initDb() throws Exception {
        RocksDBService.init((String)(blockConfig.getDataPath() + File.separator + ModuleE.BL.name));
        RocksDBService.createTable((String)"chain_latest_height");
        RocksDBService.createTable((String)"protocol_config");
        RocksDBService.createTable((String)"rollback_height");
    }

    private boolean doStart() {
        try {
            this.chainManager.runChain();
        }
        catch (Exception e) {
            Log.error((String)("block module doStart error!" + e));
            return false;
        }
        Log.info((String)"block module ready");
        return true;
    }

    @Override
    public void onDependenciesReady() {
        Log.info((String)"block onDependenciesReady");
        this.doStart();
        if (started) {
            List<Integer> chainIds = ContextManager.CHAIN_ID_LIST;
            for (Integer chainId : chainIds) {
                BlockSynchronizer.syn(chainId);
            }
        } else {
            List<Integer> chainIds = ContextManager.CHAIN_ID_LIST;
            for (Integer chainId : chainIds) {
                BlockSynchronizer.syn(chainId);
            }
            ScheduledThreadPoolExecutor forkExecutor = ThreadUtils.createScheduledThreadPool((int)1, (NulsThreadFactory)new NulsThreadFactory("fork-chains-monitor"));
            forkExecutor.scheduleWithFixedDelay(ForkChainsMonitor.getInstance(), 0L, blockConfig.getForkChainsMonitorInterval(), TimeUnit.MILLISECONDS);
            ScheduledThreadPoolExecutor orphanExecutor = ThreadUtils.createScheduledThreadPool((int)1, (NulsThreadFactory)new NulsThreadFactory("orphan-chains-monitor"));
            orphanExecutor.scheduleWithFixedDelay(OrphanChainsMonitor.getInstance(), 0L, blockConfig.getOrphanChainsMonitorInterval(), TimeUnit.MILLISECONDS);
            ScheduledThreadPoolExecutor maintainExecutor = ThreadUtils.createScheduledThreadPool((int)1, (NulsThreadFactory)new NulsThreadFactory("orphan-chains-maintainer"));
            maintainExecutor.scheduleWithFixedDelay(OrphanChainsMaintainer.getInstance(), 0L, blockConfig.getOrphanChainsMaintainerInterval(), TimeUnit.MILLISECONDS);
            ScheduledThreadPoolExecutor dbSizeExecutor = ThreadUtils.createScheduledThreadPool((int)1, (NulsThreadFactory)new NulsThreadFactory("storage-size-monitor"));
            dbSizeExecutor.scheduleWithFixedDelay(StorageSizeMonitor.getInstance(), 0L, blockConfig.getStorageSizeMonitorInterval(), TimeUnit.MILLISECONDS);
            ScheduledThreadPoolExecutor monitorExecutor = ThreadUtils.createScheduledThreadPool((int)1, (NulsThreadFactory)new NulsThreadFactory("network-monitor"));
            monitorExecutor.scheduleWithFixedDelay(NetworkResetMonitor.getInstance(), 0L, blockConfig.getNetworkResetMonitorInterval(), TimeUnit.MILLISECONDS);
            ScheduledThreadPoolExecutor txGroupExecutor = ThreadUtils.createScheduledThreadPool((int)1, (NulsThreadFactory)new NulsThreadFactory("txGroup-requestor"));
            txGroupExecutor.scheduleWithFixedDelay(TxGroupRequestor.getInstance(), 0L, blockConfig.getTxGroupRequestorInterval(), TimeUnit.MILLISECONDS);
            ScheduledThreadPoolExecutor nodesExecutor = ThreadUtils.createScheduledThreadPool((int)1, (NulsThreadFactory)new NulsThreadFactory("nodes-monitor"));
            nodesExecutor.scheduleWithFixedDelay(NodesMonitor.getInstance(), 0L, blockConfig.getNodesMonitorInterval(), TimeUnit.MILLISECONDS);
            started = true;
        }
    }

    static {
        started = false;
    }
}

