/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.manager;

import io.nuls.block.model.ChainContext;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.common.ConfigBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ContextManager {
    public static final List<Integer> CHAIN_ID_LIST = new CopyOnWriteArrayList<Integer>();
    private static Map<Integer, ChainContext> contextMap = new ConcurrentHashMap<Integer, ChainContext>();

    private ContextManager() {
    }

    public static void init(ConfigBean chainParameters) {
        ChainContext chainContext = new ChainContext();
        int chainId = chainParameters.getChainId();
        CHAIN_ID_LIST.add(chainId);
        contextMap.put(chainId, chainContext);
        chainContext.setChainId(chainId);
        chainParameters.setResetTime(1800000L);
        chainContext.setParameters(chainParameters);
        chainContext.init();
        LoggerUtil.COMMON_LOG.info("new chainContext add! chainId-" + chainId);
    }

    public static ChainContext getContext(int chainId) {
        return contextMap.get(chainId);
    }
}

