/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.model;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Address;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.NulsSignData;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.BlockSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.core.basic.VarInt;
import io.nuls.core.constant.ToolsConstant;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.io.IoUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GenesisBlock
extends Block {
    private static final String GENESIS_BLOCK_FILE = "genesis-block.json";
    private static final String CONFIG_FILED_TIME = "time";
    private static final String CONFIG_FILED_HEIGHT = "height";
    private static final String CONFIG_FILED_EXTEND = "extend";
    private static final String CONFIG_FILED_TXS = "txs";
    private static final String CONFIG_FILED_ALIAS = "alias";
    private static final String CONFIG_FILED_ADDRESS = "address";
    private static final String CONFIG_FILED_AMOUNT = "amount";
    private static final String CONFIG_FILED_LOCK_TIME = "lockTime";
    private static final String CONFIG_FILED_REMARK = "remark";
    private static final String CONFIG_FILED_PRIVATE_KEY = "privateKey";
    private transient long blockTime;
    private int chainId;
    private int assetsId;
    private BigInteger priKey;

    private GenesisBlock(int chainId, int assetsId, String json) throws IOException {
        Map jsonMap = JSONUtils.json2map((String)json);
        String time = (String)jsonMap.get(CONFIG_FILED_TIME);
        this.blockTime = Long.parseLong(time);
        this.chainId = chainId;
        this.assetsId = assetsId;
        this.initGengsisTxs(jsonMap);
        this.fillHeader(jsonMap);
    }

    public static GenesisBlock getInstance(int chainId, int assetsId, String json) throws IOException {
        return new GenesisBlock(chainId, assetsId, json);
    }

    public static GenesisBlock getInstance(int chainId, int assetsId) throws Exception {
        String json = IoUtils.read((String)("block" + File.separator + GENESIS_BLOCK_FILE));
        return new GenesisBlock(chainId, assetsId, json);
    }

    private void initGengsisTxs(Map<String, Object> jsonMap) throws IOException {
        List list = (List)jsonMap.get(CONFIG_FILED_TXS);
        if (null == list || list.isEmpty()) {
            throw new NulsRuntimeException(BlockErrorCode.DATA_ERROR);
        }
        CoinData coinData = new CoinData();
        for (Map map : list) {
            String address = (String)map.get(CONFIG_FILED_ADDRESS);
            String amount = map.get(CONFIG_FILED_AMOUNT).toString();
            long lockTime = Long.parseLong("" + map.get(CONFIG_FILED_LOCK_TIME));
            Address ads = Address.fromHashs((String)address);
            CoinTo coin = new CoinTo();
            coin.setAddress(ads.getAddressBytes());
            coin.setAmount(new BigInteger(amount));
            coin.setAssetsChainId(this.chainId);
            coin.setAssetsId(this.assetsId);
            coin.setLockTime(lockTime);
            coinData.addTo(coin);
        }
        Transaction tx = new Transaction();
        tx.setType(1);
        tx.setTime(this.blockTime);
        tx.setCoinData(coinData.serialize());
        String remark = (String)jsonMap.get(CONFIG_FILED_REMARK);
        if (StringUtils.isNotBlank((String)remark)) {
            tx.setRemark(HexUtil.decode((String)remark));
        }
        tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
        ArrayList<Transaction> txlist = new ArrayList<Transaction>();
        txlist.add(tx);
        this.fillAliasTxs(txlist, jsonMap);
        this.setTxs(txlist);
    }

    private void fillAliasTxs(List<Transaction> txlist, Map<String, Object> jsonMap) {
        List list = (List)jsonMap.get(CONFIG_FILED_ALIAS);
        if (null == list || list.isEmpty()) {
            return;
        }
        for (Map map : list) {
            byte[] txData;
            Transaction tx = new Transaction();
            tx.setType(3);
            tx.setTime(this.blockTime);
            String address = (String)map.get(CONFIG_FILED_ADDRESS);
            String alias = (String)map.get(CONFIG_FILED_ALIAS);
            try {
                txData = this.getAliasTxData(address, alias);
            }
            catch (UnsupportedEncodingException e) {
                LoggerUtil.COMMON_LOG.error((Exception)e);
                continue;
            }
            tx.setTxData(txData);
            txlist.add(tx);
        }
    }

    private byte[] getAliasTxData(String address, String alias) throws UnsupportedEncodingException {
        byte[] addrByte = AddressTool.getAddress((String)address);
        byte[] addrLength = new VarInt((long)addrByte.length).encode();
        byte[] aliasBytes = alias.getBytes(ToolsConstant.DEFAULT_ENCODING);
        byte[] aliasLength = new VarInt((long)aliasBytes.length).encode();
        byte[] data = new byte[addrByte.length + addrLength.length + aliasBytes.length + aliasLength.length];
        System.arraycopy(addrLength, 0, data, 0, addrLength.length);
        System.arraycopy(addrByte, 0, data, addrLength.length, addrByte.length);
        System.arraycopy(aliasLength, 0, data, addrByte.length + addrLength.length, aliasLength.length);
        System.arraycopy(aliasBytes, 0, data, addrByte.length + addrLength.length + aliasLength.length, aliasBytes.length);
        return data;
    }

    private void fillHeader(Map<String, Object> jsonMap) {
        Integer height = (Integer)jsonMap.get(CONFIG_FILED_HEIGHT);
        String extend = (String)jsonMap.get(CONFIG_FILED_EXTEND);
        BlockHeader header = new BlockHeader();
        this.setHeader(header);
        header.setHeight((long)height.intValue());
        header.setTime(this.blockTime);
        header.setPreHash(NulsHash.calcHash((byte[])new byte[35]));
        header.setTxCount(this.getTxs().size());
        ArrayList<NulsHash> txHashList = new ArrayList<NulsHash>();
        for (Transaction tx : this.getTxs()) {
            txHashList.add(tx.getHash());
        }
        header.setMerkleHash(NulsHash.calcMerkleHash(txHashList));
        header.setExtend(HexUtil.decode((String)extend));
        BlockSignature blockSignature = new BlockSignature();
        this.priKey = new BigInteger(1, HexUtil.decode((String)((String)jsonMap.get(CONFIG_FILED_PRIVATE_KEY))));
        NulsSignData signData = this.signature(header.getHash().getBytes());
        blockSignature.setSignData(signData);
        blockSignature.setPublicKey(this.getGenesisPubkey());
        header.setBlockSignature(blockSignature);
    }

    private NulsSignData signature(byte[] bytes) {
        return SignatureUtil.signDigest((byte[])bytes, (ECKey)ECKey.fromPrivate((BigInteger)this.priKey));
    }

    private byte[] getGenesisPubkey() {
        return ECKey.fromPrivate((BigInteger)this.priKey).getPubKey();
    }
}

