/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.rpc.call;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.protocol.ModuleHelper;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.ChainContext;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.HashMap;

public class ProtocolCall {
    public static boolean rollbackNotice(int chainId, BlockHeader blockHeader) {
        if (!ModuleHelper.isSupportProtocolUpdate()) {
            return true;
        }
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("chainId", chainId);
            params.put("blockHeader", HexUtil.encode((byte[])blockHeader.serialize()));
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.PU.abbr, (String)"rollbackBlock", params);
            return response.isSuccess();
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static boolean saveNotice(int chainId, BlockHeader blockHeader) {
        if (!ModuleHelper.isSupportProtocolUpdate()) {
            return true;
        }
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("chainId", chainId);
            params.put("blockHeader", HexUtil.encode((byte[])blockHeader.serialize()));
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.PU.abbr, (String)"saveBlock", params);
            return response.isSuccess();
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static boolean checkBlockVersion(int chainId, BlockHeader blockHeader) {
        if (!ModuleHelper.isSupportProtocolUpdate()) {
            return true;
        }
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("chainId", chainId);
            params.put("extendsData", HexUtil.encode((byte[])blockHeader.getExtend()));
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.PU.abbr, (String)"checkBlockVersion", params);
            return response.isSuccess();
        }
        catch (Exception e) {
            logger.error(e);
            return false;
        }
    }
}

