/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.test;

import io.nuls.base.data.Address;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.NulsSignData;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.BlockSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.block.model.GenesisBlock;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class BlockGenerator {
    private static final String PRIVATE_KEY = "009cf05b6b3fe8c09b84c13783140c0f1958e8841f8b6f894ef69431522bc65712";
    private static final String ADDRESS = "TTaoMpuLtP4NmiVZWAQpngopcvoDNULS9861";
    private static final String REMARK = "4f70656e2c204c69626572616c2c204175746f6e6f6d6f75732c2053656c662d45766f6c76696e670ae5bc80e694beefbc8ce887aae794b1efbc8ce887aae6b2bbefbc8ce8bf9be58c960a4f75766572742c204c696272652c204175746f6e6f6d652c20c389766f6c757469660ae382aae383bce38397e383b3e38081e38395e383aae383bce38081e887aae6b2bbe38081e980b2e58c960ad09ed182d0bad180d18bd182d18bd0b92c20d0a1d0b2d0bed0b1d0bed0b4d0bdd0b0d18f2c20d090d0b2d182d0bed0bdd0bed0bcd0bdd0b0d18f2c20d18dd0b2d0bed0bbd18ed186d0b8d18f0aeab09cebb0a9eca0812020eca784ebb3b4eca08120ec9e90ec9ca8eca08120ed9881ebaa85eca0810a4162696572746f2c204c696272652c20417574c3b36e6f6d6f2c2045766f6c757469766f0ad981d8aad8ad20d88c20d8add8b120d88c20d985d8b3d8aad982d98420d88c20d8aad8b7d988d8b10a4f6666656e2c20667265692c206175746f6e6f6d2c2045766f6c7574696f6e0a45766f6c75c3a7c3a36f206162657274612c206c69767265206520617574c3b36e6f6d610ac39670706e612c20667269612c206175746f6e6f6d612c2065766f6c7574696f6e0ace91cebdcebfceb9cebacf84ceae2c20ceb5cebbceb5cf8dceb8ceb5cf81ceb72c20ceb1cf85cf84cf8ccebdcebfcebcceb72c20ceb5cebeceadcebbceb9cebeceb70a41c3a7c4b16b2c20c3b67a67c3bc722c20c3b67a65726b2c20657672696d0a4f736361696c2c2073616f7220696e2061697363652c206e65616d6873706c65c3a163682c20c3a96162686cc3b36964";
    private static final long BLOCK_TIME = 1531152L;
    private static final int TX_COUNT = 222;

    public static Block generate(Block latestBlock) throws Exception {
        return BlockGenerator.generate(latestBlock, 1L, "1");
    }

    public static Block generate(Block latestBlock, long seed, String symbol) throws Exception {
        if (latestBlock == null) {
            return GenesisBlock.getInstance(0, 0);
        }
        Block block = new Block();
        block.setTxs(BlockGenerator.getTransactions(222, seed, symbol));
        BlockGenerator.fillHeader(block, latestBlock.getHeader().getHash(), latestBlock.getHeader().getHeight() + 1L);
        return block;
    }

    private static void fillHeader(Block block, NulsHash previousHash, long height) {
        BlockHeader header = new BlockHeader();
        block.setHeader(header);
        header.setHeight(height);
        header.setTime(1531152L);
        header.setPreHash(previousHash);
        header.setTxCount(block.getTxs().size());
        ArrayList<NulsHash> txHashList = new ArrayList<NulsHash>();
        for (Transaction tx : block.getTxs()) {
            txHashList.add(tx.getHash());
        }
        header.setMerkleHash(NulsHash.calcMerkleHash(txHashList));
        BlockSignature signature = new BlockSignature();
        NulsSignData signData = BlockGenerator.signature(header.getHash().getBytes());
        signature.setSignData(signData);
        signature.setPublicKey(BlockGenerator.getGenesisPubkey());
        header.setBlockSignature(signature);
    }

    private static NulsSignData signature(byte[] bytes) {
        return SignatureUtil.signDigest((byte[])bytes, (ECKey)ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)PRIVATE_KEY))));
    }

    private static byte[] getGenesisPubkey() {
        return ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)PRIVATE_KEY))).getPubKey();
    }

    public static List<Transaction> getTransactions(int size, long seed, String symbol) throws IOException {
        ArrayList<Transaction> txlist = new ArrayList<Transaction>();
        CoinData coinData = new CoinData();
        String amount = "10000000" + seed + symbol;
        Address ads = Address.fromHashs((String)ADDRESS);
        CoinTo coin = new CoinTo();
        coin.setAddress(ads.getAddressBytes());
        coin.setAmount(new BigInteger(amount));
        coin.setAssetsChainId(1);
        coin.setAssetsId(1);
        coin.setLockTime(0L);
        coinData.addTo(coin);
        byte[] bytes = coinData.serialize();
        byte[] remark = HexUtil.decode((String)REMARK);
        for (int i = 0; i < size; ++i) {
            Transaction tx = new Transaction();
            tx.setTime(1531152L);
            tx.setCoinData(bytes);
            tx.setRemark(remark);
            tx.setType(i + 1);
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            txlist.add(tx);
        }
        return txlist;
    }
}

