/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread;

import io.nuls.base.data.Block;
import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.constant.NodeEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.BlockDownloaderParams;
import io.nuls.block.model.ChainContext;
import io.nuls.block.model.Node;
import io.nuls.block.service.BlockService;
import io.nuls.block.utils.BlockUtil;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.logback.NulsLogger;
import java.util.List;
import java.util.concurrent.Callable;

public class BlockConsumer
implements Callable<Boolean> {
    private int chainId;
    private BlockService blockService;

    BlockConsumer(int chainId) {
        this.chainId = chainId;
        this.blockService = (BlockService)SpringLiteContext.getBean(BlockService.class);
    }

    @Override
    public Boolean call() {
        ChainContext context = ContextManager.getContext(this.chainId);
        BlockDownloaderParams params = context.getDownloaderParams();
        long netLatestHeight = params.getNetLatestHeight();
        long pendingHeight = params.getLocalLatestHeight() + 1L;
        NulsLogger logger = context.getLogger();
        logger.info("BlockConsumer start work");
        try {
            long begin = System.nanoTime();
            while (pendingHeight <= netLatestHeight && context.isNeedSyn()) {
                Block block = context.getBlockMap().remove(pendingHeight);
                if (block != null) {
                    begin = System.nanoTime();
                    boolean saveBlock = this.blockService.saveBlock(this.chainId, block, true);
                    if (!saveBlock) {
                        logger.error("An exception occurred while saving the downloaded block, height-" + pendingHeight + ", hash-" + block.getHeader().getHash());
                        context.setNeedSyn(false);
                        return false;
                    }
                    ++pendingHeight;
                    context.getCachedBlockSize().addAndGet(-block.size());
                    continue;
                }
                Thread.sleep(10L);
                long end = System.nanoTime();
                if ((end - begin) / 1000000L <= 5000L) continue;
                this.updateNodeStatus(context);
                this.punishNode(pendingHeight, params.getNodes(), context);
                this.retryDownload(pendingHeight, context);
                begin = System.nanoTime();
            }
            logger.info("BlockConsumer stop work normally");
            return context.isNeedSyn();
        }
        catch (Exception e) {
            logger.error("BlockConsumer stop work abnormally", e);
            context.setNeedSyn(false);
            return false;
        }
    }

    private void punishNode(long pendingHeight, List<Node> nodes, ChainContext context) {
        for (Node node : nodes) {
            if (node.getStartHeight() > pendingHeight || pendingHeight > node.getEndHeight()) continue;
            context.getLogger().error("download block from {} failed! failed height {}", new Object[]{node.getId(), pendingHeight});
            node.adjustCredit(false);
            return;
        }
    }

    private void updateNodeStatus(ChainContext context) {
        List<Node> nodes = context.getDownloaderParams().getNodes();
        for (Node node : nodes) {
            if (!node.getNodeEnum().equals((Object)NodeEnum.WORKING) || System.currentTimeMillis() - node.getStartTime() <= 60000L) continue;
            node.adjustCredit(false);
            if (node.getNodeEnum().equals((Object)NodeEnum.TIMEOUT)) continue;
            node.setNodeEnum(NodeEnum.IDLE);
        }
    }

    private void retryDownload(long height, ChainContext context) throws NulsException {
        boolean download = false;
        BlockDownloaderParams downloaderParams = context.getDownloaderParams();
        List<Node> nodeList = downloaderParams.getNodes();
        for (Node node : nodeList) {
            if (node.getNodeEnum().equals((Object)NodeEnum.TIMEOUT)) continue;
            context.getLogger().info("retryDownload, get block from " + node.getId() + " begin, height-" + height);
            Block block = BlockUtil.downloadBlockByHeight(this.chainId, node.getId(), height);
            if (block != null) {
                context.getLogger().info("retryDownload, get block from " + node.getId() + " success, height-" + height);
                download = true;
                context.getBlockMap().put(height, block);
                context.getCachedBlockSize().addAndGet(block.size());
                break;
            }
            node.adjustCredit(false);
        }
        if (!download) {
            throw new NulsException(BlockErrorCode.BLOCK_SYN_ERROR);
        }
    }
}

