/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread.monitor;

import io.nuls.block.constant.StatusEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.ChainContext;
import io.nuls.core.log.logback.NulsLogger;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMonitor
implements Runnable {
    protected List<StatusEnum> runningStatusEnumList = new ArrayList<StatusEnum>();
    protected String symbol = this.getClass().getName();

    BaseMonitor() {
        this.runningStatusEnumList.add(StatusEnum.RUNNING);
    }

    public BaseMonitor(List<StatusEnum> runningStatusEnumList) {
        this();
        this.runningStatusEnumList.addAll(runningStatusEnumList);
    }

    @Override
    public void run() {
        for (Integer chainId : ContextManager.CHAIN_ID_LIST) {
            ChainContext context = ContextManager.getContext(chainId);
            NulsLogger logger = context.getLogger();
            StatusEnum status = context.getStatus();
            try {
                if (!this.runningStatusEnumList.contains((Object)status)) continue;
                this.process(chainId, context, logger);
            }
            catch (Exception e) {
                context.setStatus(status);
                logger.error(this.symbol + " running fail", e);
            }
        }
    }

    protected abstract void process(int var1, ChainContext var2, NulsLogger var3);
}

