/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread.monitor;

import io.nuls.block.constant.StatusEnum;
import io.nuls.block.manager.BlockChainManager;
import io.nuls.block.model.Chain;
import io.nuls.block.model.ChainContext;
import io.nuls.block.model.CheckResult;
import io.nuls.block.rpc.call.ConsensusCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.thread.monitor.BaseMonitor;
import io.nuls.common.ConfigBean;
import io.nuls.core.log.logback.NulsLogger;
import java.util.SortedSet;
import java.util.concurrent.locks.StampedLock;

public class ForkChainsMonitor
extends BaseMonitor {
    private static final ForkChainsMonitor INSTANCE = new ForkChainsMonitor();

    public static ForkChainsMonitor getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void process(int chainId, ChainContext context, NulsLogger commonLog) {
        StampedLock lock = context.getLock();
        long stamp = lock.tryOptimisticRead();
        StatusEnum status = StatusEnum.RUNNING;
        try {
            while (true) {
                if (stamp != 0L) {
                    SortedSet<Chain> forkChains = BlockChainManager.getForkChains(chainId);
                    if (lock.validate(stamp)) {
                        if (forkChains.isEmpty()) {
                            return;
                        }
                        context.printChains();
                        Chain masterChain = BlockChainManager.getMasterChain(chainId);
                        ConfigBean parameters = context.getParameters();
                        int chainSwtichThreshold = parameters.getChainSwtichThreshold();
                        Chain switchChain = new Chain();
                        int maxHeightDifference = 0;
                        for (Chain forkChain : forkChains) {
                            int temp = (int)(forkChain.getEndHeight() - masterChain.getEndHeight());
                            if (temp <= maxHeightDifference) continue;
                            maxHeightDifference = temp;
                            switchChain = forkChain;
                        }
                        commonLog.debug("chainId-" + chainId + ", maxHeightDifference:" + maxHeightDifference + ", chainSwtichThreshold:" + chainSwtichThreshold);
                        if (maxHeightDifference < chainSwtichThreshold) {
                            return;
                        }
                        if ((stamp = lock.tryConvertToWriteLock(stamp)) != 0L) {
                            context.setStatus(StatusEnum.SWITCHING);
                            ConsensusCall.notice(chainId, 0);
                            TransactionCall.notice(chainId, 0);
                            CheckResult checkResult = BlockChainManager.switchChain(chainId, masterChain, switchChain);
                            if (checkResult.isResult()) {
                                commonLog.info("chainId-" + chainId + ", switchChain success");
                            } else {
                                if (checkResult.isTimeout()) {
                                    status = StatusEnum.WAITING;
                                    return;
                                }
                                commonLog.info("chainId-" + chainId + ", switchChain fail, auto rollback success");
                            }
                            context.printChains();
                            ConsensusCall.notice(chainId, 1);
                            TransactionCall.notice(chainId, 1);
                            return;
                        }
                    }
                }
                stamp = lock.writeLock();
            }
        }
        finally {
            context.setStatus(status);
            if (StampedLock.isWriteLockStamp(stamp)) {
                lock.unlockWrite(stamp);
            }
        }
    }
}

